/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAppLoginLogDao;
import com.baijia.tianxiao.dal.org.extractors.StatisticsExtractor;
import com.baijia.tianxiao.dal.org.po.OrgAppLoginLog;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class OrgAppLoginLogDaoIml
extends JdbcTemplateDaoSupport<OrgAppLoginLog>
implements OrgAppLoginLogDao {
    @Override
    public Map<Long, Integer> getOrgAppLoginTotal(Integer tid, Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select count(id) as count,user_id as org_id from cdb.org_app_login_log where user_id in (:orgIds) ";
        if (startDate != null && endDate != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        sql = sql + " GROUP BY user_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new StatisticsExtractor());
    }

    @Override
    public Map<String, Integer> getOrgLoginMap(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        String sql = "select count(distinct(user_id)) count, DATE_FORMAT(create_time,'%y-%m-%d') 'createTime' from cdb.org_app_login_log where user_id in (:orgIds)  and create_time>=:startTime and create_time<=:endTime ";
        sql = sql + "group by MONTH(create_time),DAY(create_time)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                while (rs.next()) {
                    String date = rs.getString("createTime");
                    Integer count = rs.getInt("count");
                    map.put(date, count);
                }
                return map;
            }
        });
    }
}

