/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class AreaDaoImpl
extends JdbcTemplateDaoSupport<Area>
implements AreaDao {
    public AreaDaoImpl() {
        super(Area.class);
    }

    @Override
    public List<Area> getBylevel(int id, long mask, int level) {
        HashMap map = Maps.newHashMap();
        map.put("mask", mask);
        map.put("level", level);
        map.put("id", id);
        StringBuilder sb = new StringBuilder("select id,name,level,bname from cdb.area where id&:mask = :id and level = :level order by display_order desc");
        return this.getNamedJdbcTemplate().query(sb.toString(), (Map)map, (RowMapper)new RowMapper<Area>(){

            public Area mapRow(ResultSet resultSet, int i) throws SQLException {
                Area area = new Area();
                area.setId(resultSet.getInt("id"));
                area.setName(resultSet.getString("name"));
                area.setBname(resultSet.getString("bname"));
                area.setLevel(resultSet.getInt("level"));
                return area;
            }
        });
    }

    @Override
    public List<Area> getBylevel(int level) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("level", (Serializable)Integer.valueOf(level));
        builder.desc("display_order");
        return this.queryList(builder);
    }

    @Override
    public List<Area> getAreaByBname(String name, int level) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("level", (Serializable)Integer.valueOf(level));
        builder.add(Expressions.or((Expression)Expressions.eq((String)"name", (Serializable)((Object)name)), (Expression)Expressions.eq((String)"bname", (Serializable)((Object)name))));
        builder.desc("display_order");
        return this.queryList(builder);
    }
}

