/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.course.dao.impl;

import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.stereotype.Repository;

@Repository(value="teacherClassCourseDao")
public class TeacherClassCourseDaoImpl
extends JdbcTemplateDaoSupport<TeacherClassCourse>
implements TeacherClassCourseDao {
    private static final Logger log = LoggerFactory.getLogger(TeacherClassCourseDaoImpl.class);

    @Override
    public int getVliadClassCourseCount(Integer orgNumber) {
        String sql = "select count(*) from cdb.teacher_class_course where organization_number=? and status=2 and begin_time>now()";
        return this.getNamedJdbcTemplate().getJdbcOperations().queryForInt(sql, new Object[]{orgNumber});
    }

    @Override
    public List<Integer> getOrgDistinctSubject(Integer orgNumber) {
        String sql = "select distinct subject_id from cdb.teacher_class_course where organization_number=? and status=2 and begin_time > now()";
        List subjectIds = this.getNamedJdbcTemplate().getJdbcOperations().query(sql, new Object[]{orgNumber}, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getInt("subject_id");
            }
        });
        return subjectIds;
    }

    @Override
    public List<TeacherClassCourse> getCoursesByNumbers(Collection<Long> numbers, final Long orgNumber, final String ... queryProps) {
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(numbers, (BatchQueryCallback)new BatchQueryCallback<Long, List<TeacherClassCourse>>(){

            public List<TeacherClassCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = TeacherClassCourseDaoImpl.this.createSqlBuilder(queryProps);
                builder.in("number", querySet);
                builder.eq("organizationNumber", (Serializable)orgNumber);
                builder.eq("verifyStatus", (Serializable)Integer.valueOf(1));
                builder.eq("status", (Serializable)Integer.valueOf(2));
                builder.add(Expressions.ne((String)"open_status", (Serializable)Integer.valueOf(3)));
                return TeacherClassCourseDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<TeacherClassCourse> getOrgCourseList(Integer number, Collection<Long> excludeIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("organizationNumber", (Serializable)number);
        builder.eq("status", (Serializable)Integer.valueOf(2));
        builder.gt("beginTime", (Serializable)new Date());
        if (excludeIds != null && !excludeIds.isEmpty()) {
            builder.notin("id", excludeIds);
        }
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public int getValidClassCourseCountByIds(Integer orgNumber, Collection<Long> ids) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.in("id", ids);
        builder.eq("organizationNumber", (Serializable)orgNumber);
        builder.eq("status", (Serializable)Integer.valueOf(2));
        builder.gt("beginTime", (Serializable)new Date());
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<TeacherClassCourse> getOrgCourseListByIn(Integer number, Collection<Long> inludeIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", inludeIds);
        builder.eq("organizationNumber", (Serializable)number);
        builder.eq("status", (Serializable)Integer.valueOf(2));
        builder.gt("beginTime", (Serializable)new Date());
        return this.queryList(builder);
    }

    @Override
    public Map<Long, TeacherClassCourse> getTeacherClassCourses(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        List courses = this.getByIds(ids, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)courses)) {
            HashMap result = Maps.newHashMap();
            for (TeacherClassCourse course : courses) {
                result.put(course.getId(), course);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    public List<TeacherClassCourse> getVisualTeacherCourseByOrgNumber(Integer orgNumber, String subjectIds, String courseTypes, int orderType) {
        String sql = "SELECT id,organization_number,number,name,subject_id,extend_status,rank,transform,page_view FROM cdb.teacher_class_course ";
        sql = sql + " where organization_number=:orgNumber and end_time>now() and (status=2 or verify_status=2) ";
        if (StringUtils.isNotEmpty((CharSequence)subjectIds)) {
            sql = sql + " and subject_id in(:subjectIds) ";
        }
        if (StringUtils.isNotEmpty((CharSequence)courseTypes)) {
            sql = sql + " and lesson_way in(:courseTypes)";
        }
        if (orderType == 0) {
            sql = sql + " order by extend_status desc, rank desc";
        } else if (orderType == 1) {
            sql = sql + " order by rank desc ";
        } else if (orderType == 2) {
            sql = sql + " order by rank asc ";
        } else if (orderType == 3) {
            sql = sql + " order by page_view desc ";
        } else if (orderType == 4) {
            sql = sql + " order by page_view asc ";
        } else if (orderType == 5) {
            sql = sql + " order by transform desc ";
        } else if (orderType == 6) {
            sql = sql + " order by transform asc ";
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgNumber", orgNumber);
        if (StringUtils.isNotEmpty((CharSequence)subjectIds)) {
            String[] subArray = StringUtils.split((String)subjectIds, (String)"|");
            ArrayList subjectList = Lists.newArrayList();
            for (String s : subArray) {
                subjectList.add(Integer.valueOf(s));
            }
            paramMap.put("subjectIds", subjectList);
        }
        if (StringUtils.isNotEmpty((CharSequence)courseTypes)) {
            String[] subArray;
            ArrayList courseList = Lists.newArrayList();
            for (String s : subArray = StringUtils.split((String)courseTypes, (String)",")) {
                courseList.add(Integer.valueOf(s));
            }
            paramMap.put("courseTypes", courseList);
        }
        log.info("teacherClassCourseQuery,sql=" + sql);
        final ArrayList result = Lists.newArrayList();
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (ResultSetExtractor)new ResultSetExtractor<List<TeacherClassCourse>>(){

            public List<TeacherClassCourse> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    TeacherClassCourse course = new TeacherClassCourse();
                    course.setId(rs.getLong("id"));
                    course.setOrganizationNumber(rs.getInt("organization_number"));
                    course.setNumber(rs.getLong("number"));
                    course.setName(rs.getString("name"));
                    course.setSubjectid(rs.getLong("subject_id"));
                    course.setExtendStatus(rs.getInt("extend_status"));
                    course.setRank(rs.getInt("rank"));
                    course.setTransform(rs.getInt("transform"));
                    course.setPageView(rs.getInt("page_view"));
                    result.add(course);
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public TeacherClassCourse getTeacherClassCourse(Integer orgNumber, Long courseNumber) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("organizationNumber", (Serializable)orgNumber);
        builder.eq("number", (Serializable)courseNumber);
        return (TeacherClassCourse)this.uniqueResult(builder);
    }

    @Override
    public TeacherClassCourse getByCouseNumber(Long courseNumber) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("number", (Serializable)courseNumber);
        return (TeacherClassCourse)this.uniqueResult(builder);
    }

    @Override
    public int getAdvertiseCourseCount(Integer orgNumber) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("organizationNumber", (Serializable)orgNumber);
        builder.eq("extendStatus", (Serializable)Integer.valueOf(1));
        builder.count("id");
        Integer result = (Integer)this.queryForObject(builder, Integer.class);
        if (result == null) {
            return 0;
        }
        return result;
    }

    @Override
    public int getMaxId() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.max("id");
        Integer maxId = (Integer)this.queryForObject(builder, Integer.class);
        if (maxId != null) {
            return maxId;
        }
        return 0;
    }

    @Override
    public List<String> getBlobString(Integer orgNumber, Long courseNumber) {
        String sql = "SELECT introduction FROM cdb.teacher_class_course where organization_number=:orgNumber and number=:courseNumber";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgNumber", orgNumber);
        paramMap.put("courseNumber", courseNumber);
        DefaultLobHandler lobHandler = new DefaultLobHandler();
        return this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (RowMapper)new RowMapper<String>((LobHandler)lobHandler){
            final /* synthetic */ LobHandler val$lobHandler;
            {
                this.val$lobHandler = lobHandler;
            }

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                byte[] bytes = this.val$lobHandler.getBlobAsBytes(rs, 1);
                if (bytes != null) {
                    String s = new String(bytes);
                    return s;
                }
                return null;
            }
        });
    }
}

