/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.user.dao.impl;

import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository(value="teacherDao")
public class TeacherDaoImpl
extends JdbcTemplateDaoSupport<Teacher>
implements TeacherDao {
    private static final Logger log = LoggerFactory.getLogger(TeacherDaoImpl.class);

    public TeacherDaoImpl() {
        super(Teacher.class);
    }

    @Override
    public Teacher getByUserId(@NonNull Long userId, String ... queryProp) {
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProp);
        builder.eq("userId", (Serializable)userId);
        return (Teacher)this.uniqueResult(builder);
    }

    @Override
    public List<Teacher> getByUserIds(Collection<Long> userIds, final String ... queryProp) {
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List teachers = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Teacher>>(){

            public List<Teacher> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = TeacherDaoImpl.this.createSqlBuilder(queryProp);
                builder.in("userId", querySet);
                return TeacherDaoImpl.this.queryList(builder);
            }
        });
        return teachers;
    }

    @Override
    public Map<Long, String> getTeacherRealNameMap(@NonNull Collection<Long> teacherIds) {
        if (teacherIds == null) {
            throw new NullPointerException("teacherIds");
        }
        if (teacherIds.isEmpty()) {
            log.warn("teacher ids is empty.");
            return Collections.emptyMap();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List teachers = (List)queryTemplate.batchQuery(teacherIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Teacher>>(){

            public List<Teacher> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = TeacherDaoImpl.this.createSqlBuilder(new String[0]);
                builder.select("realName");
                builder.select("nickName");
                builder.select("userId");
                builder.in("userId", querySet);
                return TeacherDaoImpl.this.queryList(builder);
            }
        });
        if (CollectionUtils.isEmpty((Collection)teachers)) {
            return Collections.emptyMap();
        }
        HashMap teacherRealNameMap = Maps.newHashMap();
        for (Teacher teacher : teachers) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacher.getRealName()})) {
                teacherRealNameMap.put(teacher.getUserId(), teacher.getRealName());
                continue;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacher.getNickName()})) {
                teacherRealNameMap.put(teacher.getUserId(), teacher.getNickName());
                continue;
            }
            teacherRealNameMap.put(teacher.getUserId(), "\u533f\u540d");
        }
        return teacherRealNameMap;
    }

    @Override
    public List<Teacher> getTeachersByOrgId(Long orgId, PageDto page, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProp);
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, List<Teacher>> getBranchTeachMap(Long orgId, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProp);
        builder.eq("orgId", (Serializable)orgId);
        List teachers = this.queryList(builder);
        return CollectorUtil.group((Collection)teachers, (Function)new Function<Teacher, Long>(){

            public Long apply(Teacher from) {
                return from.getBranchId();
            }
        });
    }

    @Override
    public Integer getTeachersCountByOrgId(Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<Teacher> searchTeacherByMobileAndName(Long orgId, String key, Integer limit) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key}), (Object)"search key can not be empty");
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT u.mobile,t.realname realName,t.nickname nickName,t.user_id userId,t.avatar  from cdb.user u join cdb.teacher t on t.user_id = u.id ");
        sql.append("WHERE 1=1 AND ");
        if (orgId != null) {
            sql.append(" t.organization_id=:orgId AND ");
            params.put("orgId", orgId);
        }
        sql.append("( u.mobile like :key or u.number like :key or t.realname like :key or t.nickname like :key )");
        if (limit != null && limit > 0) {
            sql.append(" LIMIT 0,:limit");
            params.put("limit", limit);
        }
        params.put("key", MatchMode.START.toMatchString(key));
        return this.getNamedJdbcTemplate().query(sql.toString(), params, (RowMapper)new BeanPropertyRowMapper(Teacher.class));
    }

    @Override
    public List<Teacher> getByTeacherIds(Collection<Long> teacherIds, final String ... queryProp) {
        if (teacherIds.isEmpty()) {
            log.warn("teacher ids is empty.");
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(teacherIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Teacher>>(){

            public List<Teacher> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = TeacherDaoImpl.this.createSqlBuilder(queryProp);
                builder.in("userId", querySet);
                return TeacherDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<Teacher> getTeachers(Long orgId, List<Long> teacherIds, String key, Date startTime, Date endTime, PageDto page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder countSql = new StringBuilder();
        StringBuilder selectSql = new StringBuilder();
        StringBuilder fromSql = new StringBuilder();
        countSql.append("SELECT count(u.id) ");
        selectSql.append("SELECT u.mobile,t.realname realName,t.nickname nickName,t.user_id userId,t.avatar,t.created_at as createTime ");
        fromSql.append("from cdb.user u join cdb.teacher t on t.user_id = u.id ");
        fromSql.append("WHERE 1=1 AND ");
        if (orgId != null) {
            fromSql.append(" t.organization_id=:orgId AND ");
            params.put("orgId", orgId);
        }
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            fromSql.append("t.user_id in (:teacherIds) AND ");
            params.put("teacherIds", StringUtils.join(teacherIds, (char)','));
        }
        if (startTime != null && endTime != null) {
            fromSql.append("(t.created_at BETWEEN :startTime AND :endTime) AND");
            params.put("startTime", startTime);
            params.put("endTime", endTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            fromSql.append("( u.mobile like :key or u.number like :key or t.realname like :key or t.nickname like :key) AND ");
            params.put("key", MatchMode.START.toMatchString(key.trim()));
        }
        fromSql.append("1=1");
        int count = (Integer)this.getNamedJdbcTemplate().queryForObject(countSql.append((CharSequence)fromSql).toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getInt(1);
            }
        });
        page.setCount(Integer.valueOf(count));
        if (page != null) {
            fromSql.append(" LIMIT :begin,:limit");
            params.put("begin", (page.getPageNum() - 1) * page.getPageSize());
            params.put("limit", page.getPageSize());
        }
        return this.getNamedJdbcTemplate().query(selectSql.append((CharSequence)fromSql).toString(), params, (RowMapper)new BeanPropertyRowMapper(Teacher.class));
    }
}

