/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.user.dao.impl;

import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class StudentDaoImpl
extends JdbcTemplateDaoSupport<Student>
implements StudentDao {
    private static final Logger log = LoggerFactory.getLogger(StudentDaoImpl.class);

    public StudentDaoImpl() {
        super(Student.class);
    }

    @Override
    public Student getByUserId(@NonNull Long userId, String ... queryProp) {
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProp);
        builder.eq("userId", (Serializable)userId);
        return (Student)this.uniqueResult(builder);
    }

    @Override
    public List<Student> getByUserIds(Collection<Long> userIds, final String ... queryProp) {
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List teachers = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Student>>(){

            public List<Student> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = StudentDaoImpl.this.createSqlBuilder(queryProp);
                builder.in("userId", querySet);
                return StudentDaoImpl.this.queryList(builder);
            }
        });
        return teachers;
    }

    @Override
    public Map<Long, String> getStudentNameMap(@NonNull Collection<Long> studentIds) {
        if (studentIds == null) {
            throw new NullPointerException("studentIds");
        }
        if (studentIds.isEmpty()) {
            log.warn("teacher ids is empty.");
            return Collections.emptyMap();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(studentIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Student>>(){

            public List<Student> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = StudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.select("realName");
                builder.select("nickName");
                builder.select("userId");
                builder.in("userId", querySet);
                return StudentDaoImpl.this.queryList(builder);
            }
        });
        if (CollectionUtils.isEmpty((Collection)students)) {
            return Collections.emptyMap();
        }
        HashMap studentRealNameMap = Maps.newHashMap();
        for (Student student : students) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{student.getNickName()})) {
                studentRealNameMap.put(student.getUserId(), student.getNickName());
                continue;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{student.getRealName()})) {
                studentRealNameMap.put(student.getUserId(), student.getRealName());
                continue;
            }
            studentRealNameMap.put(student.getUserId(), "\u533f\u540d");
        }
        return studentRealNameMap;
    }
}

