/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCourseTeacherDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseTeacher>
implements OrgCourseTeacherDao {
    public OrgCourseTeacherDaoImpl() {
        super(OrgCourseTeacher.class);
    }

    @Override
    public List<OrgCourseTeacher> getTeacher(Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgCourseId", (Serializable)courseId);
        builder.asc("createTime");
        return this.queryList(builder);
    }

    @Override
    public Integer getTeacherCourseCount(Long teacherId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("userId", (Serializable)teacherId);
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgCourseTeacher> getCourseTeachers(Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userId", (Serializable)userId);
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourseTeacher> getCourseTeachers(Long courseId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgCourseId", (Serializable)courseId);
        builder.eq("userId", (Serializable)userId);
        return this.queryList(builder);
    }

    @Override
    public List<String> getTeacherNames(Long courseId) {
        String sql = "select ct.nickname, ct.realname from cdb.org_course_teacher ot,cdb.teacher ct where ot.org_course_id=:orgCourseId and ot.user_id=ct.user_id";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgCourseId", courseId);
        List names = this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String nickname = rs.getString("nickname");
                String realname = rs.getString("realname");
                return StringUtils.isNotBlank((CharSequence)realname) ? realname : (StringUtils.isNotBlank((CharSequence)nickname) ? nickname : "");
            }
        });
        return names;
    }

    @Override
    public List<OrgCourseTeacher> getOrgCourseTeacher(Collection<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgCourseTeacher>>(){

            public List<OrgCourseTeacher> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseTeacherDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("orgCourseId", querySet);
                return OrgCourseTeacherDaoImpl.this.queryList(builder);
            }
        });
    }
}

