/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCourseDaoImpl
extends JdbcTemplateDaoSupport<OrgCourse>
implements OrgCourseDao {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseDaoImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public OrgCourseDaoImpl() {
        super(OrgCourse.class);
    }

    @Override
    public List<OrgCourse> getCoursesByOrgNumber(Long orgNumber, String key, Integer status, PageDto page, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            builder.like("name", (Serializable)((Object)key), MatchMode.START);
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        if (page != null) {
            builder.setPage(page);
        }
        return this.queryList(builder);
    }

    @Override
    public Map<Long, OrgCourse> getOrgCourseMap(Collection<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        List courses = this.getByIds(courseIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)courses)) {
            HashMap result = Maps.newHashMap();
            for (OrgCourse course : courses) {
                result.put(course.getId(), course);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    public List<Long> getCourseIdsByOrgNumberAndCourseName(Long orgNumber, String name, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("id");
        builder.eq("orgNumber", (Serializable)orgNumber);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            builder.like("name", (Serializable)((Object)name), MatchMode.START);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public OrgCourse getByCourseId(Long orgCourseId, String ... queryProp) {
        return (OrgCourse)this.getById(orgCourseId, queryProp);
    }

    @Override
    public List<OrgCourse> getByIdsOrderByIn(Collection<Long> courseIds, Integer limit) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.ne("status", (Serializable)Integer.valueOf(1));
        builder.orderByField("id", courseIds);
        builder.setMaxSize(limit);
        List list = this.queryList(builder);
        log.debug("list = {}", (Object)list);
        return list;
    }

    @Override
    public int getValidOrgCourseCount(Integer orgNumber) {
        String sql = "select count(*) from cdb.org_course where organization_number=? and status=0 and verify_status=1";
        return this.jdbcTemplate.queryForInt(sql, new Object[]{orgNumber});
    }

    @Override
    public Map<Long, String> getCourseNameMap(Collection<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        MapBatchQueryTemplate queryTemplate = new MapBatchQueryTemplate();
        return (Map)queryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, String>>(){

            public Map<Long, String> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseDaoImpl.this.createSqlBuilder(new String[]{"id", "name"});
                builder.in("id", querySet);
                List courses = OrgCourseDaoImpl.this.queryList(builder);
                return CollectorUtil.collectMap((Collection)courses, (Function)new Function<OrgCourse, Long>(){

                    public Long apply(OrgCourse from) {
                        return from.getId();
                    }
                }, (Function)new Function<OrgCourse, String>(){

                    public String apply(OrgCourse from) {
                        return from.getName();
                    }
                });
            }
        });
    }

    @Override
    public OrgCourse getCourseByCourseNumberAndOrgNumber(Long orgNumber, Long courseNumber, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("number", (Serializable)courseNumber);
        return (OrgCourse)this.uniqueResult(builder);
    }

    @Override
    public List<Integer> getOrgCourseSubjectIds(Integer orgNumber) {
        String sql = "select distinct subject_id from cdb.org_course where organization_number=? and status=0";
        List subjectIds = this.jdbcTemplate.query(sql, new Object[]{orgNumber}, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getInt("subject_id");
            }
        });
        return subjectIds;
    }

    @Override
    public List<Long> getCourseIdsByCourseNumberAndOrgNumber(final Long orgNumber, Collection<Long> courseNumbers) {
        if (CollectionUtils.isEmpty(courseNumbers)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(courseNumbers, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseDaoImpl.this.createSqlBuilder(new String[]{"id"});
                builder.eq("orgNumber", (Serializable)orgNumber);
                builder.in("number", querySet);
                return OrgCourseDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public List<OrgCourse> getAndFilterOrgCourse(Integer orgNumber, Collection<Long> excludeIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("status", (Serializable)Integer.valueOf(0));
        if (excludeIds != null && !excludeIds.isEmpty()) {
            builder.notin("id", excludeIds);
        }
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourse> getAndFilterOrgCourseByIn(Integer orgNumber, Collection<Long> includeIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("status", (Serializable)Integer.valueOf(0));
        builder.in("id", includeIds);
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public int getValidOrgCourseCount(Integer orgNumber, Collection<Long> ids) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.in("id", ids);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("status", (Serializable)Integer.valueOf(0));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgCourse> getVisualOrgCourseByOrgNumber(Integer orgNumber, String subjectIds, boolean orderAsc) {
        String sql = "SELECT * FROM cdb.org_course where organization_number=:orgNumber and status=0  ";
        if (StringUtils.isNotEmpty((CharSequence)subjectIds)) {
            sql = sql + " and subject_id in(" + subjectIds + ") ";
        }
        sql = sql + " order by extend_status desc ";
        sql = orderAsc ? sql + ",rank asc" : sql + ",rank desc";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgNumber", orgNumber);
        final ArrayList result = Lists.newArrayList();
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (ResultSetExtractor)new ResultSetExtractor<List<OrgCourse>>(){

            public List<OrgCourse> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    OrgCourse orgCourse = new OrgCourse();
                    orgCourse.setId(rs.getLong("id"));
                    orgCourse.setNumber(rs.getLong("number"));
                    orgCourse.setName(rs.getString("name"));
                    orgCourse.setSubjectId(rs.getInt("subject_id"));
                    orgCourse.setRank(rs.getInt("rank"));
                    orgCourse.setExtendStatus(rs.getInt("extend_status"));
                    orgCourse.setTransform(rs.getInt("transform"));
                    orgCourse.setPageView(rs.getInt("page_view"));
                    result.add(orgCourse);
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public OrgCourse getOrgCourse(Integer orgNumber, Long courseNum) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("number", (Serializable)courseNum);
        return (OrgCourse)this.queryForObject(builder, OrgCourse.class);
    }

    @Override
    public int getAdvertiseCourseCount(Integer orgNumber) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("extendStatus", (Serializable)Integer.valueOf(1));
        builder.count("id");
        Integer result = (Integer)this.queryForObject(builder, Integer.class);
        if (result == null) {
            return 0;
        }
        return result;
    }
}

