/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.wx.service.impl;

import com.baijia.tianxiao.biz.wx.dto.request.WxStuSearchDto;
import com.baijia.tianxiao.biz.wx.dto.request.WxStudentReqDto;
import com.baijia.tianxiao.biz.wx.dto.response.CourseLessonRespDto;
import com.baijia.tianxiao.biz.wx.dto.response.WxStuListRespDto;
import com.baijia.tianxiao.biz.wx.dto.response.WxStudentRespDto;
import com.baijia.tianxiao.biz.wx.service.WxStudentService;
import com.baijia.tianxiao.constants.EnableStatus;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseExtraDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.WxStudentExtDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseExtra;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.WxLiveRoom;
import com.baijia.tianxiao.dal.org.po.WxStudentExt;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.wx.api.RegisterService;
import com.baijia.tianxiao.sal.wx.api.WxLessonService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomService;
import com.baijia.tianxiao.sal.wx.enums.RoomStatus;
import com.baijia.tianxiao.sal.wx.enums.WxErrorCode;
import com.baijia.tianxiao.sal.wx.model.ValidateCodeSend;
import com.baijia.tianxiao.sal.wx.model.WxCourseInfoDto;
import com.baijia.tianxiao.sal.wx.model.WxVideoLessonView;
import com.baijia.tianxiao.sal.wx.result.CommonDataResult;
import com.baijia.tianxiao.sal.wx.util.ValidateUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WxStudentServiceImpl
implements WxStudentService {
    private static final Logger log = LoggerFactory.getLogger(WxStudentServiceImpl.class);
    @Autowired
    private WxLiveRoomService wxLiveRoomService;
    @Autowired
    private WxLessonService wxLessonService;
    @Autowired
    private RegisterService registerService;
    @Autowired
    private OrgStudentApiService orgStudentApiService;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private WxStudentExtDao wxStudentExtDao;
    @Autowired
    private OrgCourseExtraDao orgCourseExtraDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;

    @Override
    @Transactional(readOnly=true)
    public WxStudentRespDto getStudentInfo(Long orgId, Long studentId) {
        OrgStudent orgStudent = this.validate(orgId, studentId);
        WxStudentRespDto dto = new WxStudentRespDto();
        Map avatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)Lists.newArrayList((Object[])new OrgStudent[]{orgStudent}));
        dto.poToDto(orgStudent, avatarMap);
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modBaseInfo(Long orgId, WxStudentReqDto param) {
        OrgStudent orgStudent = this.validate(orgId, param.getId());
        param.dtoToPo(orgStudent);
        this.orgStudentDao.updateWithDefaultVal((Object)orgStudent, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modAvatar(Long orgId, Long studentId, Long storageId) {
        Preconditions.checkArgument((storageId != null && storageId > 0L ? 1 : 0) != 0, (Object)"storageId is illegal");
        OrgStudent orgStudent = this.validate(orgId, studentId);
        orgStudent.setAvatar(storageId);
        orgStudent.setUpdateTime(new Date());
        this.orgStudentDao.updateWithDefaultVal((Object)orgStudent, new String[]{"avatar", "updateTime"});
    }

    @Override
    public CommonDataResult<?> getSmsCode(Long orgId, Long studentId, String mobile, Boolean isNew) {
        OrgStudent orgStudent = this.validate(orgId, studentId);
        if (!isNew.booleanValue() && !orgStudent.getMobile().equals(mobile)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f53\u524d\u767b\u5f55\u624b\u673a\u53f7\u5f02\u5e38");
        }
        if (isNew.booleanValue() && orgStudent.getMobile().equals(mobile)) {
            throw new BussinessException((UniverseErrorCode)WxErrorCode.MOBILE_NOT_CHANGE);
        }
        ValidateCodeSend.BizTypeEnum type = ValidateCodeSend.BizTypeEnum.SmsModifyMobile;
        int codeType = isNew != false ? ValidateCodeSend.SendSMSTypeEnum.MODIFY_PHONE.getIndex() : ValidateCodeSend.SendSMSTypeEnum.VALIDATA_OLD_PHONE.getIndex();
        CommonDataResult result = this.registerService.sendSMSCode(orgId, mobile, type.name(), type, codeType);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modMobile(Long orgId, Long studentId, String mobile, String code) {
        OrgStudent orgStudent = this.validate(orgId, studentId);
        if (orgStudent.getMobile().equals(mobile)) {
            throw new BussinessException((UniverseErrorCode)WxErrorCode.MOBILE_NOT_CHANGE);
        }
        CommonDataResult result = this.registerService.checkSMSCode(orgId, mobile, code, ValidateCodeSend.BizTypeEnum.SmsModifyMobile);
        if (!result.isSuccess()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, result.getMsg());
        }
        orgStudent.setMobile(mobile);
        orgStudent.setUpdateTime(new Date());
        this.orgStudentDao.updateWithDefaultVal((Object)orgStudent, new String[]{"mobile", "updateTime"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modPassword(Long orgId, Long studentId, String oldPwd, String newPwd) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{oldPwd, newPwd}), (Object)"\u65b0/\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)ValidateUtil.isPwAllowed((String)newPwd), (Object)"\u5bc6\u7801\u4e0d\u5408\u6cd5,\u8bf7\u8f93\u51656~18\u4f4d\u5bc6\u7801,\u4ee5\u5b57\u6bcd\u5f00\u5934,\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf");
        OrgStudent orgStudent = this.validate(orgId, studentId);
        try {
            if (!PasswordUtil.validatePassword((String)oldPwd, (String)orgStudent.getPwd())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25,\u8bf7\u91cd\u65b0\u8f93\u5165!");
            }
        }
        catch (Exception e) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25,\u8bf7\u91cd\u65b0\u8f93\u5165!");
        }
        orgStudent.setPwd(PasswordUtil.createHash((String)newPwd));
        orgStudent.setUpdateTime(new Date());
        this.orgStudentDao.updateWithDefaultVal((Object)orgStudent, new String[]{"pwd", "updateTime"});
    }

    @Override
    public List<CourseLessonRespDto> myCourseList(Long orgId, Long studentId, Integer courseType, Date start, Date end, PageDto pageDto) {
        OrgStudent orgStudent = this.validate(orgId, studentId);
        ArrayList<CourseLessonRespDto> list = new ArrayList<CourseLessonRespDto>();
        List courseIds = this.orgStudentCourseDao.getStudentCourseIds(orgId, orgStudent.getUserId(), Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        if (CollectionUtils.isNotEmpty((Collection)courseIds)) {
            List courseList;
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"id", "number"});
            Object page = null;
            if (courseType.intValue() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode().intValue()) {
                page = pageDto;
            }
            if (CollectionUtils.isNotEmpty((Collection)(courseList = this.orgCourseDao.getCourseList(Long.valueOf(orgAccount.getNumber().longValue()), (Collection)courseIds, null, null, null, null, null, null, courseType, page, new String[0])))) {
                HashMap<Long, OrgCourse> courseMap = new HashMap<Long, OrgCourse>();
                ArrayList<Long> courseIdArr = new ArrayList<Long>();
                HashSet<Long> coverIds = new HashSet<Long>();
                for (OrgCourse orgCourse : courseList) {
                    courseMap.put(orgCourse.getId(), orgCourse);
                    courseIdArr.add(orgCourse.getId());
                    if (orgCourse.getCover() == null) continue;
                    coverIds.add(orgCourse.getCover().longValue());
                }
                page = courseType.intValue() == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode().intValue() ? pageDto : null;
                List originLessons = this.orgClassLessonDao.queryLessons(orgId, courseMap.keySet(), null, null, start, end, page, Boolean.valueOf(false), new String[0]);
                if (CollectionUtils.isNotEmpty((Collection)originLessons)) {
                    List lessons = new ArrayList();
                    if (courseType.intValue() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode().intValue()) {
                        HashMap<Long, OrgClassLesson> videoCourseMap = new HashMap<Long, OrgClassLesson>();
                        for (OrgClassLesson orgClassLesson : originLessons) {
                            OrgClassLesson firstLesson = (OrgClassLesson)videoCourseMap.get(orgClassLesson.getCourseId());
                            if (firstLesson != null && !orgClassLesson.getCreateTime().before(firstLesson.getCreateTime())) continue;
                            videoCourseMap.put(orgClassLesson.getCourseId(), orgClassLesson);
                        }
                        for (Long courseId : courseIdArr) {
                            lessons.add(videoCourseMap.get(courseId));
                        }
                    } else {
                        lessons = originLessons;
                    }
                    Set lessonIds = BaseUtils.getPropertiesList(lessons, (String)"id");
                    Map<Long, String> lessonTeacherMap = null;
                    Map courseTeacherMap = null;
                    if (courseType.intValue() == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode().intValue()) {
                        lessonTeacherMap = this.cacheLessonTeacherMap(orgId, lessonIds);
                    } else {
                        courseTeacherMap = this.orgCourseTeacherDao.getAllTeacherNames(courseMap.keySet());
                    }
                    Map<Long, String> courseGroupMap = this.cacheCourseGroupMap(orgId, courseMap.keySet());
                    Map<Long, String> coverMap = this.cacheCoverUrl(coverIds);
                    Map lessonCountMap = this.orgClassLessonDao.getCourseLessonCount(orgId, courseMap.keySet(), null, null, null);
                    Map videoLessonMap = null;
                    Map liveRoomMap = null;
                    if (courseType.intValue() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode().intValue()) {
                        List videoLessons = this.wxLessonService.getVideoLessonViewList(orgId, lessons);
                        if (CollectionUtils.isNotEmpty((Collection)videoLessons)) {
                            videoLessonMap = BaseUtils.listToMap((List)videoLessons, (String)"lessonId");
                        }
                    } else if (courseType.intValue() == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode().intValue()) {
                        liveRoomMap = this.wxLiveRoomService.queryMapByOrgLessonIds(orgId, (Collection)lessonIds);
                    }
                    for (OrgClassLesson lesson : lessons) {
                        list.add(this.buildDto(lesson, courseMap, courseGroupMap, coverMap, lessonTeacherMap, courseTeacherMap, courseType, lessonCountMap, videoLessonMap, liveRoomMap));
                    }
                }
            }
        }
        return list;
    }

    private CourseLessonRespDto buildDto(OrgClassLesson lesson, Map<Long, OrgCourse> courseMap, Map<Long, String> courseGroupMap, Map<Long, String> coverMap, Map<Long, String> lessonTeacherMap, Map<Long, List<String>> courseTeacherMap, Integer courseType, Map<Long, Integer> lessonCountMap, Map<Long, WxVideoLessonView> videoLessonMap, Map<Long, WxLiveRoom> liveRoomMap) {
        CourseLessonRespDto dto = new CourseLessonRespDto();
        dto.setCourseType(courseType);
        dto.setCourseId(lesson.getCourseId());
        dto.setCourseName(courseMap.get(lesson.getCourseId()).getName());
        dto.setCoverId(courseMap.get(lesson.getCourseId()).getCover());
        if (courseMap.get(lesson.getCourseId()).getCover() != null && coverMap != null && coverMap.containsKey(courseMap.get(lesson.getCourseId()).getCover().longValue())) {
            dto.setCoverUrl(coverMap.get(courseMap.get(lesson.getCourseId()).getCover().longValue()));
        } else {
            dto.setCoverUrl("https://imgs.genshuixue.com/24489340_jifl3uig.png");
        }
        dto.setLessonId(lesson.getId());
        dto.setLessonName(lesson.getName());
        dto.setGroupName(courseGroupMap.get(lesson.getCourseId()));
        if (lessonCountMap != null && lessonCountMap.containsKey(lesson.getCourseId())) {
            dto.setCount(lessonCountMap.get(lesson.getCourseId()));
        }
        if (courseType.intValue() == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode().intValue()) {
            dto.setTeacherName(lessonTeacherMap != null && lessonTeacherMap.containsKey(lesson.getId()) ? lessonTeacherMap.get(lesson.getId()) : "");
            dto.setStart(lesson.getStartTime());
            dto.setEnd(lesson.getEndTime());
            dto.setDuration(DateUtil.getMinuteDiff((Date)lesson.getStartTime(), (Date)lesson.getEndTime()));
            if (liveRoomMap != null && liveRoomMap.containsKey(lesson.getId())) {
                WxLiveRoom liveRoom = liveRoomMap.get(lesson.getId());
                Date now = new Date();
                if (liveRoom.getStartTime() != null && liveRoom.getStartTime().after(now)) {
                    dto.setRoomStatus(RoomStatus.NOT_BEGIN.getCode());
                } else if (liveRoom.getEndTime() != null && liveRoom.getEndTime().before(now)) {
                    dto.setRoomStatus(RoomStatus.END.getCode());
                } else {
                    dto.setRoomStatus(RoomStatus.ON_GOING.getCode());
                }
                dto.setPlayBack(liveRoom.getPlayBack());
            }
        } else if (courseType.intValue() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode().intValue()) {
            if (courseTeacherMap != null && courseTeacherMap.containsKey(lesson.getCourseId())) {
                dto.setTeacherName(StringUtils.join((Iterable)courseTeacherMap.get(lesson.getCourseId()), (String)","));
            }
            if (videoLessonMap != null && videoLessonMap.containsKey(lesson.getId()) && videoLessonMap.get(lesson.getId()).getLength() != null) {
                int length = videoLessonMap.get(lesson.getId()).getLength();
                dto.setDuration(length / 60 <= 1 ? 1 : length / 60);
            }
        }
        return dto;
    }

    @Override
    public List<WxStuListRespDto> getStudentList(Long orgId, WxStuSearchDto param, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        ArrayList<WxStuListRespDto> list = new ArrayList<WxStuListRespDto>();
        List studentList = this.orgStudentDao.getWxListByParam(orgId, param.getKey(), null, param.getEnableStatus(), param.getStatus(), param.getStart(), param.getEnd(), pageDto);
        if (CollectionUtils.isNotEmpty((Collection)studentList)) {
            for (OrgStudent orgStudent : studentList) {
                WxStuListRespDto dto = new WxStuListRespDto();
                dto.setId(orgStudent.getId());
                dto.setName(orgStudent.getName());
                dto.setNickName(orgStudent.getNickName());
                dto.setMobile(orgStudent.getMobile());
                dto.setCreateTime(orgStudent.getCreateTime());
                dto.setEnableStatus(orgStudent.getEnableStatus());
                dto.setEnableStatusStr(EnableStatus.getMsgByCode((Integer)orgStudent.getEnableStatus()));
                dto.setLessonStatus(orgStudent.getLessonStatus());
                dto.setLessonStatusStr(StudentLessonStatus.getStatus((Integer)orgStudent.getLessonStatus()).getName());
                list.add(dto);
            }
        }
        return list;
    }

    @Override
    public WxStuListRespDto getStudentCourse(Long orgId, Long studentId) {
        Map avatarMap;
        OrgStudent orgStudent = this.validate(orgId, studentId);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"id", "number"});
        WxStuListRespDto data = new WxStuListRespDto();
        ArrayList<WxCourseInfoDto> courseInfos = new ArrayList<WxCourseInfoDto>();
        List signupInfoList = this.orgSignupInfoDao.getPurchases(orgStudent.getUserId(), Long.valueOf(orgAccount.getNumber().longValue()), null, Integer.valueOf(PayStatus.SUCESS.getCode()), new String[]{"signupPurchaseId", "payTime"});
        if (CollectionUtils.isNotEmpty((Collection)signupInfoList)) {
            Map signupInfoMap = BaseUtils.listToMap((List)signupInfoList, (String)"signupPurchaseId");
            List signupCourseList = this.orgSignupCourseDao.loadByPurchaseIds(signupInfoMap.keySet(), new String[]{"orgCourseId", "createTime", "signupPurchaseId"});
            Collections.sort(signupCourseList, new Comparator<OrgSignupCourse>(){

                @Override
                public int compare(OrgSignupCourse o1, OrgSignupCourse o2) {
                    if (o1.getCreateTime().getTime() - o2.getCreateTime().getTime() >= 0L) {
                        return -1;
                    }
                    return 1;
                }
            });
            Set courseIds = BaseUtils.getPropertiesList((List)signupCourseList, (String)"orgCourseId");
            List courseList = this.orgCourseDao.getCourseList(Long.valueOf(orgAccount.getNumber().longValue()), (Collection)courseIds, "", null, null, null, null, null, null, null, new String[0]);
            Map courseMap = BaseUtils.listToMap((List)courseList, (String)"id");
            Map extraMap = this.orgCourseExtraDao.queryMapByCourseIds((Collection)courseIds);
            for (OrgSignupCourse signupCourse : signupCourseList) {
                OrgCourse orgCourse = (OrgCourse)courseMap.get(signupCourse.getOrgCourseId());
                if (orgCourse == null) continue;
                WxCourseInfoDto dto = new WxCourseInfoDto();
                dto.setCourseType(orgCourse.getCourseType());
                dto.setCourseId(orgCourse.getId());
                dto.setCourseName(orgCourse.getName());
                dto.setSignupTime(signupCourse.getCreateTime());
                if (orgCourse.getCourseType().intValue() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode().intValue() && signupInfoMap.containsKey(signupCourse.getSignupPurchaseId())) {
                    Date expireTime = ((OrgSignupInfo)signupInfoMap.get(signupCourse.getSignupPurchaseId())).getPayTime();
                    if (extraMap != null && extraMap.containsKey(orgCourse.getId())) {
                        expireTime = DateUtil.getDiffDateTime((Date)expireTime, (int)((OrgCourseExtra)extraMap.get(orgCourse.getId())).getEffectDays());
                    }
                    dto.setExpireTime(expireTime);
                }
                courseInfos.add(dto);
            }
        }
        if ((avatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)Lists.newArrayList((Object[])new OrgStudent[]{orgStudent}))) != null) {
            data.setAvatarUrl((String)avatarMap.get(orgStudent.getId()));
        }
        data.setId(orgStudent.getId());
        data.setName(orgStudent.getName());
        data.setMobile(orgStudent.getMobile());
        data.setCreateTime(orgStudent.getCreateTime());
        data.setCourseInfos(courseInfos);
        return data;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setStudentIps(Long orgId, Long studentId, String ips) {
        OrgStudent orgStudent = this.validate(orgId, studentId);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ips}), (Object)"\u8bf7\u586b\u5199ip\u6bb5,\u4f7f\u7528\u9017\u53f7\u9694\u5f00");
        WxStudentExt wxStudentExt = this.wxStudentExtDao.getByStudentId(orgId, studentId, new String[0]);
        if (wxStudentExt == null) {
            wxStudentExt = new WxStudentExt();
            wxStudentExt.setOrgId(orgId);
            wxStudentExt.setStudentId(studentId);
            wxStudentExt.setUserId(orgStudent.getUserId());
            wxStudentExt.setCreateTime(new Date());
        }
        wxStudentExt.setIps(ips);
        wxStudentExt.setUpdateTime(new Date());
        this.wxStudentExtDao.saveOrUpdateWithDefaultVal((Object)wxStudentExt, new String[0]);
    }

    @Override
    public String getStudentIps(Long orgId, Long studentId) {
        OrgStudent orgStudent = this.validate(orgId, studentId);
        WxStudentExt wxStudentExt = this.wxStudentExtDao.getByStudentId(orgId, studentId, new String[0]);
        String ips = "";
        if (wxStudentExt != null) {
            ips = wxStudentExt.getIps();
        }
        return ips;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void switchStatus(Long orgId, Long studentId, Integer status) {
        OrgStudent orgStudent = this.validate(orgId, studentId);
        Preconditions.checkArgument((EnableStatus.getByCode((Integer)status) != null ? 1 : 0) != 0, (Object)"\u72b6\u6001\u53c2\u6570\u9519\u8bef");
        if (orgStudent.getEnableStatus().intValue() == status.intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u5458\u72b6\u6001\u4e3a" + EnableStatus.getMsgByCode((Integer)status));
        }
        orgStudent.setEnableStatus(status);
        orgStudent.setUpdateTime(new Date());
        this.orgStudentDao.update((Object)orgStudent, new String[]{"enableStatus", "updateTime"});
    }

    @Override
    public OrgStudent getByMobile(Long orgId, String mobile) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        OrgStudent orgStudent = this.orgStudentDao.getStudentByMobileAndOrgId(orgId, mobile, new String[0]);
        return orgStudent;
    }

    Map<Long, String> cacheCoverUrl(Collection<Long> ids) {
        Map storageMap;
        HashMap<Long, String> cache = new HashMap<Long, String>();
        if (CollectionUtils.isNotEmpty(ids) && (storageMap = this.storageDao.getStorageMapByIds(ids)) != null && storageMap.size() > 0) {
            for (Number number : ids) {
                if (number != null && storageMap.containsKey(number.longValue())) {
                    Storage storage = (Storage)storageMap.get(number.longValue());
                    if (StringUtils.isNotBlank((CharSequence)storage.getAttach_url())) {
                        cache.put(number.longValue(), storage.getAttach_url());
                        continue;
                    }
                    cache.put(number.longValue(), StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
                    continue;
                }
                cache.put(0L, "https://imgs.genshuixue.com/24489340_jifl3uig.png");
            }
        }
        return cache;
    }

    private Map<Long, String> cacheCourseGroupMap(Long orgId, Collection<Long> courseIds) {
        List groupList;
        Map courseGroupMap;
        HashMap<Long, String> cache = new HashMap<Long, String>();
        if (CollectionUtils.isNotEmpty(courseIds) && (courseGroupMap = this.orgCourseGroupRelateDao.getCourseGroupMap(courseIds)) != null && courseGroupMap.size() > 0 && CollectionUtils.isNotEmpty((Collection)(groupList = this.orgCourseGroupDao.getOrgCourseGroupList(Integer.valueOf(orgId.intValue()))))) {
            Map groupMap = BaseUtils.listToMap((List)groupList, (String)"id");
            for (Long courseId : courseGroupMap.keySet()) {
                Set groupIds = (Set)courseGroupMap.get(courseId);
                HashSet<String> groupNames = new HashSet<String>();
                if (CollectionUtils.isNotEmpty((Collection)groupIds)) {
                    for (Integer groupId : groupIds) {
                        if (!groupMap.containsKey(groupId)) continue;
                        groupNames.add(((OrgCourseGroup)groupMap.get(groupId)).getName());
                    }
                }
                if (!CollectionUtils.isNotEmpty(groupNames)) continue;
                cache.put(courseId, StringUtils.join(groupNames, (String)"/"));
            }
        }
        return cache;
    }

    private Map<Long, String> cacheLessonTeacherMap(Long orgId, Collection<Long> lessonIds) {
        HashMap<Long, String> cache = new HashMap<Long, String>();
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            Map lessonTeacherMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
            Map teacherMap = this.teacherDao.getTeacherRealNameMap((Collection)Sets.newHashSet(lessonTeacherMap.values()));
            for (Long lessonId : lessonTeacherMap.keySet()) {
                if (!teacherMap.containsKey(lessonTeacherMap.get(lessonId))) continue;
                cache.put(lessonId, (String)teacherMap.get(lessonTeacherMap.get(lessonId)));
            }
        }
        return cache;
    }

    private OrgStudent validate(Long orgId, Long studentId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((studentId != null && studentId > 0L ? 1 : 0) != 0, (Object)"studentId is illegal");
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (orgAccount == null || orgAccount.getIsDel().intValue() == BizConf.TRUE.intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)WxErrorCode.STUDENT_NOT_EXIST);
        }
        if (orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)WxErrorCode.STUDENT_NOT_IN_ORG);
        }
        return orgStudent;
    }
}

