/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.wx.service.impl;

import com.baijia.tianxiao.biz.wx.constant.StatisticType;
import com.baijia.tianxiao.biz.wx.dto.response.OrderStatisticRespDto;
import com.baijia.tianxiao.biz.wx.dto.response.StuStatisticRespDto;
import com.baijia.tianxiao.biz.wx.service.StatisticService;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticServiceImpl
implements StatisticService {
    private static final Logger log = LoggerFactory.getLogger(StatisticServiceImpl.class);
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;

    @Override
    public StuStatisticRespDto getStudentReport(Long orgId, Integer type) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        StatisticType statisticType = StatisticType.getByCode(type);
        if (statisticType == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u65f6\u95f4\u7ef4\u5ea6\u53c2\u6570\u9519\u8bef");
        }
        Date end = DateUtil.getEndOfDay((Date)new Date());
        Date start = DateUtil.getStartOfDay((Date)DateUtil.getDiffDateTime((Date)end, (int)(-1 * statisticType.getDays() + 1)));
        Map map = this.orgStudentDao.getStudentCount(orgId, start, end);
        ArrayList<StuStatisticRespDto.StudentStatistic> list = new ArrayList<StuStatisticRespDto.StudentStatistic>();
        int max = 0;
        for (int index = 0; index < statisticType.getDays(); ++index) {
            StuStatisticRespDto.StudentStatistic dto = new StuStatisticRespDto.StudentStatistic();
            Date day = DateUtil.getDiffDateTime((Date)start, (int)index);
            String dayStr = DateUtil.getStrByDate((Date)day);
            dto.setDay(day);
            if (map != null && map.containsKey(dayStr)) {
                dto.setCount((Integer)map.get(dayStr));
            } else {
                dto.setCount(0);
            }
            list.add(dto);
            if (dto.getCount() <= max) continue;
            max = dto.getCount();
        }
        StuStatisticRespDto data = new StuStatisticRespDto();
        data.setList(list);
        data.setStart(start);
        data.setEnd(end);
        data.setMax(max);
        return data;
    }

    @Override
    public OrderStatisticRespDto getOrderReport(Long orgId, Integer type) {
        OrderStatisticRespDto.OrderStatistic dto;
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        StatisticType statisticType = StatisticType.getByCode(type);
        if (statisticType == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u65f6\u95f4\u7ef4\u5ea6\u53c2\u6570\u9519\u8bef");
        }
        Date end = DateUtil.getEndOfDay((Date)new Date());
        Date start = DateUtil.getStartOfDay((Date)DateUtil.getDiffDateTime((Date)end, (int)(-1 * statisticType.getDays() + 1)));
        List signupInfoList = this.orgSignupInfoDao.getOrgSignupInfo(null, null, orgId, null, (Collection)Sets.newHashSet((Object[])new Integer[]{PayResult.SUCCESS.getCode()}), null, (Collection)PayType.getAllCode(), null, start, end, null, null, null, null, null, new String[]{"payTime", "signupPurchaseId", "totalPrices"});
        HashMap<String, OrderStatisticRespDto.OrderStatistic> orderMap = new HashMap<String, OrderStatisticRespDto.OrderStatistic>();
        double max = 0.0;
        if (CollectionUtils.isNotEmpty((Collection)signupInfoList)) {
            List signupCourses;
            HashSet<Long> purchaseIds = new HashSet<Long>();
            for (Object signupInfo : signupInfoList) {
                Set<Long> subPurchaseIds;
                purchaseIds.add(signupInfo.getSignupPurchaseId());
                Object day = DateUtil.getStartOfDay((Date)signupInfo.getPayTime());
                String dayStr = DateUtil.getStrByDate((Date)day);
                OrderStatisticRespDto.OrderStatistic dto2 = (OrderStatisticRespDto.OrderStatistic)orderMap.get(dayStr);
                if (dto2 == null) {
                    dto2 = new OrderStatisticRespDto.OrderStatistic();
                    orderMap.put(dayStr, dto2);
                }
                if (CollectionUtils.isEmpty(subPurchaseIds = dto2.getPurchaseIds())) {
                    subPurchaseIds = new HashSet<Long>();
                    dto2.setPurchaseIds(subPurchaseIds);
                }
                subPurchaseIds.add(signupInfo.getSignupPurchaseId());
                dto2.setDay((Date)day);
                double amount = dto2.getAmount();
                dto2.setAmount(amount + (double)signupInfo.getTotalPrices().longValue() / 100.0);
                if (!(dto2.getAmount() > max)) continue;
                max = dto2.getAmount();
            }
            if (CollectionUtils.isNotEmpty(purchaseIds) && CollectionUtils.isNotEmpty((Collection)(signupCourses = this.orgSignupCourseDao.loadByPurchaseIds(purchaseIds, new String[]{"orgCourseId", "signupPurchaseId"})))) {
                for (Object day : orderMap.keySet()) {
                    dto = (OrderStatisticRespDto.OrderStatistic)orderMap.get(day);
                    Set<Long> subPurchaseIds = dto.getPurchaseIds();
                    int courseCount = 0;
                    for (OrgSignupCourse signupCourse : signupCourses) {
                        if (!subPurchaseIds.contains(signupCourse.getSignupPurchaseId())) continue;
                        ++courseCount;
                    }
                    dto.setCourseCount(courseCount);
                }
            }
        }
        ArrayList<OrderStatisticRespDto.OrderStatistic> list = new ArrayList<OrderStatisticRespDto.OrderStatistic>();
        for (int index = 0; index < statisticType.getDays(); ++index) {
            Date day = DateUtil.getDiffDateTime((Date)start, (int)index);
            String dayStr = DateUtil.getStrByDate((Date)day);
            dto = (OrderStatisticRespDto.OrderStatistic)orderMap.get(dayStr);
            if (dto == null) {
                dto = new OrderStatisticRespDto.OrderStatistic();
                dto.setCourseCount(0);
                dto.setAmount(0.0);
                dto.setDay(day);
            }
            list.add(dto);
        }
        OrderStatisticRespDto data = new OrderStatisticRespDto();
        data.setStart(start);
        data.setEnd(end);
        data.setMax(max);
        data.setList(list);
        return data;
    }
}

