/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.wx.service.impl;

import com.baijia.tianxiao.biz.wx.dto.response.WxPcLoginRoleDto;
import com.baijia.tianxiao.biz.wx.service.WxPcLoginRoleService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.wx.dao.WxMobileLastLoginDao;
import com.baijia.tianxiao.dal.wx.po.WxMobileLastLogin;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WxPcLoginRoleServiceImpl
implements WxPcLoginRoleService {
    private static final Logger log = LoggerFactory.getLogger(WxPcLoginRoleServiceImpl.class);
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private WxMobileLastLoginDao wxMobileLastLoginDao;
    @Autowired
    private StringRedisTemplate redisTemplate;
    private static final int JUMP_TOKEN_LAST_TIME = 300;

    @Override
    public List<WxPcLoginRoleDto> getWxPcLoginRoleList(String mobile) {
        if (!StringUtils.isNumeric((CharSequence)mobile)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u624b\u673a\u53f7\u7801\u9519\u8bef!");
        }
        OrgAccount account = this.orgAccountService.getOrgAccountByMobile(mobile);
        OrgSubAccount orgSubAccount = account == null ? null : this.orgSubAccountService.getByOrgId(account.getId(), new String[0]);
        TXCascadeCredential credential = this.txCascadeCredentialService.getByMobile(mobile);
        ArrayList cascades = null == credential ? new ArrayList() : this.txCascadeAccountDao.getByCredentialId(credential.getId());
        ArrayListMultimap orgIdCascadesMap = ArrayListMultimap.create();
        for (TXCascadeAccount cascadeAccount : cascades) {
            orgIdCascadesMap.put((Object)cascadeAccount.getOrgId(), (Object)cascadeAccount);
        }
        List cascadeOrgSubAccounts = this.orgSubAccountService.getByOrgIds((Collection)orgIdCascadesMap.keySet(), new String[0]);
        ArrayList result = Lists.newArrayList();
        String uuid = UUID.randomUUID().toString();
        if (null != orgSubAccount && orgSubAccount.getOnlineType().intValue() == Flag.TRUE.getInt() && orgSubAccount.getStatus() == OrgSubAccountStatus.NORMAL.getCode()) {
            result.add(this.makeWxPcLoginRoleDto(orgSubAccount, null, mobile, uuid));
            log.info("wx headmaster add role...");
        }
        for (OrgSubAccount subAccount : cascadeOrgSubAccounts) {
            if (subAccount.getOnlineType().intValue() != Flag.TRUE.getInt() || subAccount.getStatus() != OrgSubAccountStatus.NORMAL.getCode()) continue;
            for (TXCascadeAccount cascadeAccount : orgIdCascadesMap.get((Object)subAccount.getOrgId())) {
                result.add(this.makeWxPcLoginRoleDto(subAccount, cascadeAccount, mobile, uuid));
                log.info("wx cascade add role...");
            }
        }
        WxMobileLastLogin lastLogin = this.wxMobileLastLoginDao.getByMobile(mobile);
        this.findLastLogin(lastLogin, result);
        return result;
    }

    private void findLastLogin(WxMobileLastLogin lastLogin, List<WxPcLoginRoleDto> result) {
        if (null == lastLogin || CollectionUtils.isEmpty(result)) {
            return;
        }
        for (WxPcLoginRoleDto dto : result) {
            WxPcLoginRoleDto.WxPcAuth wxPcAuth = dto.getWxPcAuth();
            if (wxPcAuth.getOrgId().intValue() != lastLogin.getOrgId().intValue() || wxPcAuth.getCascadeId().intValue() != lastLogin.getCascadeId().intValue()) continue;
            dto.setLastLogin(Flag.TRUE.getInt());
        }
    }

    private WxPcLoginRoleDto makeWxPcLoginRoleDto(OrgSubAccount orgSubAccount, TXCascadeAccount cascadeAccount, String mobile, String uuid) {
        boolean isOrg = null == cascadeAccount;
        WxPcLoginRoleDto.WxPcAuth wxPcAuth = new WxPcLoginRoleDto.WxPcAuth(orgSubAccount.getOrgId(), isOrg ? 0 : cascadeAccount.getId(), mobile, uuid);
        WxPcLoginRoleDto result = new WxPcLoginRoleDto();
        result.setRoleType(isOrg ? (orgSubAccount.getPid() == 0 ? RoleType.PRESIDENT.type : RoleType.BRANCH_SCH_PRESIDENT.type) : cascadeAccount.getAccountType());
        result.setRoleTypeName(RoleType.getRoleType((Integer)result.getRoleType()).desc);
        result.setOrgName(this.orgInfoService.getOrgInfoByOrgId(orgSubAccount.getOrgId()).getShortName());
        result.setCampusLogoUrl(orgSubAccount.getCoverUrl());
        result.setLastLogin(Flag.FALSE.getInt());
        result.setWxPcAuth(wxPcAuth);
        result.createWxPcJumpToken();
        return result;
    }

    @Override
    public boolean createJumpTokenCache(final String mobile, final String uuid) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)mobile), (Object)"mobile is empty!");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)uuid), (Object)"uuid is empty!");
        this.delJumpTokenCache(mobile);
        Boolean result = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                String key = WxPcLoginRoleServiceImpl.this.getKey(mobile);
                boolean result = connection.setNX(key.getBytes(), uuid.getBytes());
                connection.expire(key.getBytes(), 300L);
                return result;
            }
        });
        return null == result ? false : result;
    }

    @Override
    public boolean validateJumpToken(final String mobile, String uuid) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)mobile), (Object)"mobile is empty!");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)uuid), (Object)"uuid is empty!");
        String cachedUuid = (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                String key = WxPcLoginRoleServiceImpl.this.getKey(mobile);
                byte[] value = connection.get(key.getBytes());
                String result = ArrayUtils.isNotEmpty((byte[])value) ? new String(value) : null;
                return result;
            }
        });
        log.info("cachedUUid:{}, now uuid:{}", (Object)cachedUuid, (Object)uuid);
        boolean result = StringUtils.equals((CharSequence)uuid, (CharSequence)cachedUuid);
        if (result) {
            this.delJumpTokenCache(mobile);
        }
        return result;
    }

    @Override
    public boolean validatePassword(String mobile, String password) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)mobile), (Object)"mobile is empty!");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)password), (Object)"password is empty!");
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByMobile(mobile);
        if (null != orgAccount) {
            try {
                return PasswordUtil.validatePassword((String)password, (String)orgAccount.getPassword());
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                log.error("password validate error:{}", (Throwable)e);
            }
        } else {
            TXCascadeCredential txCascadeCredential = this.txCascadeCredentialService.getByMobile(mobile);
            if (null != txCascadeCredential) {
                try {
                    if (StringUtils.isBlank((CharSequence)txCascadeCredential.getPassword())) {
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u5c1d\u8bd5\u5148\u627e\u56de\u5bc6\u7801\u518d\u8fdb\u884c\u767b\u5f55");
                    }
                    return PasswordUtil.validatePassword((String)password, (String)txCascadeCredential.getPassword());
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    log.error("password validate error:{}", (Throwable)e);
                }
            }
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean changePassword(String mobile, String newPwd) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)mobile), (Object)"mobile is empty!");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)newPwd), (Object)"newPwd is empty!");
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByMobile(mobile);
        if (null != orgAccount) {
            this.orgAccountService.modifyPassword(orgAccount.getId(), PasswordUtil.createHash((String)newPwd));
            return true;
        }
        TXCascadeCredential txCascadeCredential = this.txCascadeCredentialService.getByMobile(mobile);
        if (null != txCascadeCredential) {
            this.txCascadeCredentialService.modifyPassword(txCascadeCredential.getId(), PasswordUtil.createHash((String)newPwd));
            return true;
        }
        return false;
    }

    private Long delJumpTokenCache(final String mobile) {
        Long result = (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                String key = WxPcLoginRoleServiceImpl.this.getKey(mobile);
                Long result = connection.del((byte[][])new byte[][]{key.getBytes()});
                return result;
            }
        });
        return result;
    }

    private String getKey(String mobile) {
        return RedisKeyEnums.WX.WANGXIAO_PC_JUMP_TOKEN_PREFIX.getRedisKey() + mobile;
    }
}

