/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.wx.service.impl;

import com.baijia.tianxiao.biz.wx.dto.request.RedisContent;
import com.baijia.tianxiao.biz.wx.dto.response.WxOrderNumRespDto;
import com.baijia.tianxiao.biz.wx.dto.response.WxOrderRespDto;
import com.baijia.tianxiao.biz.wx.service.WxOrderService;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.constants.signup.GsxPayType;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgSinupPurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgSinupPurchase;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.wx.constant.WxOrderStatus;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.constant.OrgSinupPurchaseStatus;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.wx.api.WxCommonCounterService;
import com.baijia.tianxiao.sal.wx.enums.WxErrorCode;
import com.baijia.tianxiao.sal.wx.model.WxCommonCounterKey;
import com.baijia.tianxiao.sal.wx.util.ValidateUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.encrypt.MD5Utils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.properties.UrlProperties;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wxOrderService")
public class WxOrderServiceImpl
implements WxOrderService {
    private static final Logger log = LoggerFactory.getLogger(WxOrderServiceImpl.class);
    private static final String PAY_REDIS_PRE = "pay:auth:TX_WX_KEY_%s";
    @Autowired
    private OrgSinupPurchaseDao orgSinupPurchaseDao;
    @Autowired
    private SignupService signupService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired(required=false)
    @Qualifier(value="payRedisTemplate")
    private RedisTemplate<String, String> payRedisTemplate;
    @Autowired
    private WxCommonCounterService wxCommonCounterService;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    private static List<String> PC_PAY_TYPES = new ArrayList<String>();
    private static List<String> M_PAY_TYPES = new ArrayList<String>();

    @Override
    @Transactional(readOnly=true)
    public WxOrderNumRespDto getOrderNumInfo(Long orgId, Long userId) {
        WxOrderNumRespDto wxOrderNumRespDto = new WxOrderNumRespDto();
        wxOrderNumRespDto.setNotPaidNum(this.orgSignupInfoDao.countByOrgIdUserIdStatus(orgId, userId, Integer.valueOf(WxOrderStatus.NOT_PAY.getCode())));
        wxOrderNumRespDto.setPaidNum(this.orgSignupInfoDao.countByOrgIdUserIdStatus(orgId, userId, Integer.valueOf(WxOrderStatus.FINISH.getCode())));
        wxOrderNumRespDto.setOrderNum(this.orgSignupInfoDao.countByOrgIdUserIdStatus(orgId, userId, Integer.valueOf(WxOrderStatus.ALL.getCode())));
        return wxOrderNumRespDto;
    }

    @Override
    @Transactional(readOnly=true)
    public List<WxOrderRespDto> getOrderList(Long orgId, Long studentId, Integer status, PageDto pageDto) {
        OrgStudent orgStudent = this.validateStudent(orgId, studentId);
        ArrayList<WxOrderRespDto> list = new ArrayList<WxOrderRespDto>();
        List signupInfos = this.orgSignupInfoDao.getSignupInfoList(orgId, orgStudent.getUserId(), status, pageDto, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)signupInfos)) {
            HashMap<Long, ArrayList<Long>> purchaseCourseMap = new HashMap<Long, ArrayList<Long>>();
            HashMap<Long, OrgCourse> courseMap = new HashMap();
            HashMap<Long, String> coverMap = new HashMap();
            HashMap<Long, List<String>> courseTeacherMap = new HashMap();
            Set purchaseIds = BaseUtils.getPropertiesList((List)signupInfos, (String)"signupPurchaseId");
            List signupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)signupCourses)) {
                HashSet<Long> courseIds = new HashSet<Long>();
                for (OrgSignupCourse signupCourse : signupCourses) {
                    ArrayList<Long> subList = (ArrayList<Long>)purchaseCourseMap.get(signupCourse.getSignupPurchaseId());
                    if (subList == null) {
                        subList = new ArrayList<Long>();
                        purchaseCourseMap.put(signupCourse.getSignupPurchaseId(), subList);
                    }
                    subList.add(signupCourse.getOrgCourseId());
                    courseIds.add(signupCourse.getOrgCourseId());
                }
                List courseList = this.orgCourseDao.getCourseList(this.getOrgNumber(orgId), courseIds, "", null, null, null, null, null, null, null, new String[0]);
                if (CollectionUtils.isNotEmpty((Collection)courseList)) {
                    courseMap = BaseUtils.listToMap((List)courseList, (String)"id");
                    Set coverIds = BaseUtils.getPropertiesList((List)courseList, (String)"cover");
                    coverMap = this.cacheCoverUrl(coverIds);
                }
                courseTeacherMap = this.cacheTeacher(courseMap.keySet());
            }
            for (OrgSignupInfo signupInfo : signupInfos) {
                WxOrderRespDto dto = new WxOrderRespDto();
                dto.setId(signupInfo.getId());
                dto.setTotalPrice(signupInfo.getTotalPrices().doubleValue() / 100.0);
                dto.setSignUpTime(signupInfo.getCreateTime());
                dto.setPurchaseId(signupInfo.getSignupPurchaseId());
                dto.setCourseInfos(this.buildCourseInfos((Collection)purchaseCourseMap.get(signupInfo.getSignupPurchaseId()), courseMap, coverMap, courseTeacherMap));
                dto.setTradeNo(signupInfo.getTradeNo());
                if (signupInfo.getStatus() != null && signupInfo.getStatus().intValue() == DeleteStatus.DELETED.getValue()) {
                    dto.setWxOrderStatus(WxOrderStatus.CANCEL.getCode());
                } else {
                    dto.setWxOrderStatus(WxOrderStatus.getOrderStatus((Integer)signupInfo.getPurchaseStatus()));
                }
                if (signupInfo.getPurchaseStatus().intValue() == OrgSinupPurchaseStatus.DEAL_DONE.getCode().intValue()) {
                    dto.setPayTime(signupInfo.getPayTime());
                    dto.setPayType(signupInfo.getPayType());
                    dto.setPayTypeStr(PayType.getPayTypeByTypeStr((String)signupInfo.getPayType().toString()).getNote());
                }
                list.add(dto);
            }
        }
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public WxOrderRespDto getOrderInfo(Long orgId, Long purchaseId) {
        this.signupService.isPurchaseSucce(purchaseId, orgId, Integer.valueOf(-1));
        OrgSignupInfo signupInfo = this.orgSignupInfoDao.getByPurchaseId(orgId, purchaseId);
        HashMap<Long, ArrayList<Long>> purchaseCourseMap = new HashMap<Long, ArrayList<Long>>();
        HashMap<Long, OrgCourse> courseMap = new HashMap();
        Map<Long, String> coverMap = new HashMap<Long, String>();
        HashMap<Long, List<String>> courseTeacherMap = new HashMap();
        List signupCourses = this.orgSignupCourseDao.loadByPurchaseId(purchaseId, new String[0]);
        Integer sumPreferential = 0;
        if (CollectionUtils.isNotEmpty((Collection)signupCourses)) {
            HashSet<Long> courseIds = new HashSet<Long>();
            for (OrgSignupCourse signupCourse : signupCourses) {
                ArrayList<Long> subList = (ArrayList<Long>)purchaseCourseMap.get(signupCourse.getSignupPurchaseId());
                if (subList == null) {
                    subList = new ArrayList<Long>();
                    purchaseCourseMap.put(signupCourse.getSignupPurchaseId(), subList);
                }
                subList.add(signupCourse.getOrgCourseId());
                courseIds.add(signupCourse.getOrgCourseId());
                sumPreferential = sumPreferential + signupCourse.getPreferential();
            }
            List courseList = this.orgCourseDao.getCourseList(this.getOrgNumber(orgId), courseIds, "", null, null, null, null, null, null, null, new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)courseList)) {
                courseMap = BaseUtils.listToMap((List)courseList, (String)"id");
                Set coverIds = BaseUtils.getPropertiesList((List)courseList, (String)"cover");
                coverMap = this.cacheCoverUrl(coverIds);
            }
            courseTeacherMap = this.cacheTeacher(courseMap.keySet());
        }
        WxOrderRespDto dto = new WxOrderRespDto();
        dto.setId(signupInfo.getId());
        dto.setTotalPrice(signupInfo.getTotalPrices().doubleValue() / 100.0);
        dto.setTotalPreferential(sumPreferential.doubleValue() / 100.0);
        dto.setSignUpTime(signupInfo.getCreateTime());
        dto.setPurchaseId(signupInfo.getSignupPurchaseId());
        dto.setCourseInfos(this.buildCourseInfos((Collection)purchaseCourseMap.get(signupInfo.getSignupPurchaseId()), courseMap, coverMap, courseTeacherMap));
        dto.setTradeNo(signupInfo.getTradeNo());
        if (signupInfo.getStatus() != null && signupInfo.getStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            dto.setWxOrderStatus(WxOrderStatus.CANCEL.getCode());
        } else {
            dto.setWxOrderStatus(WxOrderStatus.getOrderStatus((Integer)signupInfo.getPurchaseStatus()));
        }
        if (signupInfo.getPurchaseStatus().intValue() == OrgSinupPurchaseStatus.DEAL_DONE.getCode().intValue()) {
            dto.setPayTime(signupInfo.getPayTime());
            dto.setPayType(signupInfo.getPayType());
            dto.setPayTypeStr(PayType.getPayTypeByTypeStr((String)signupInfo.getPayType().toString()).getNote());
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> addOrder(FillCourseInfoRequestDto fillCourseInfoRequestDto, boolean isPC) {
        OrgSingupInfoDto data;
        Long purchaseId;
        Long orgNum = this.getOrgNumber(fillCourseInfoRequestDto.getOrgId());
        List courseInfos = fillCourseInfoRequestDto.getCourseInfos();
        if (CollectionUtils.isEmpty((Collection)courseInfos)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u9009\u62e9\u8d2d\u4e70\u8bfe\u7a0b");
        }
        HashSet<String> courseIdStrs = new HashSet<String>();
        HashSet<Long> courseIds = new HashSet<Long>();
        for (SignupCourseInfoDto courseDto : courseInfos) {
            if (courseDto.getOrgCourseId() != null && courseDto.getOrgCourseId() > 0L) {
                courseIds.add(courseDto.getOrgCourseId());
                courseIdStrs.add(courseDto.getOrgCourseId().toString());
                continue;
            }
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355\u5185\u8bfe\u7a0b\u4fe1\u606f\u9519\u8bef");
        }
        Map counterMap = this.wxCommonCounterService.getMapByKeys(WxCommonCounterKey.MainKeyType.course_order_count.name(), courseIdStrs);
        if (counterMap != null && counterMap.size() > 0) {
            List courseList = this.orgCourseDao.getCourseList(orgNum, courseIds, null, Integer.valueOf(0), null, null, null, null, null, null, new String[]{"id", "maxStudent", "name"});
            for (OrgCourse orgCourse : courseList) {
                if (!counterMap.containsKey(orgCourse.getId().toString()) || (Long)counterMap.get(orgCourse.getId().toString()) < (long)orgCourse.getMaxStudent().intValue()) continue;
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, orgCourse.getName() + "\u5df2\u8ba2\u6ee1,\u8bf7\u9009\u8d2d\u5176\u4ed6\u8bfe\u7a0b");
            }
        }
        if ((purchaseId = (data = this.signupService.signUp(fillCourseInfoRequestDto)).getSignupPurchaseId()) == null || purchaseId <= 0L) {
            throw new BussinessException((UniverseErrorCode)WxErrorCode.BUY_FAILD);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("purchaseId", purchaseId);
        if (data.getTotalPrice() == 0.0) {
            map.put("freeSuccess", true);
        } else {
            map.put("freeSuccess", false);
            map.put("payUrl", this.generateUrl(data.getStudentId(), purchaseId, orgNum, isPC));
        }
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> payOrder(Long orgId, Long purchaseId, boolean isPC) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u8ba2\u5355\u53f7\u9519\u8bef");
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.getByPurchaseId(orgId, purchaseId);
        if (orgSignupInfo == null || orgSignupInfo.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        Integer purchaseStatus = orgSignupInfo.getPurchaseStatus();
        if (purchaseStatus.intValue() == OrgSinupPurchaseStatus.DEALING.getCode().intValue()) {
            Long userId = orgSignupInfo.getUserId();
            String payUrl = this.generateUrl(userId, purchaseId, this.getOrgNumber(orgId), isPC);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("purchaseId", purchaseId);
            data.put("payUrl", payUrl);
            return data;
        }
        if (orgSignupInfo.getStatus().intValue() == DeleteStatus.DELETED.getValue() && purchaseStatus.intValue() == OrgSinupPurchaseStatus.DEAL_CANCEL.getCode().intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        if (purchaseStatus.intValue() == OrgSinupPurchaseStatus.DEAL_DONE.getCode().intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8ba2\u5355\u5df2\u5b8c\u6210");
        }
        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4ea4\u6613\u5931\u8d25");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelOrder(Long orgId, Long orderId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((orderId != null && orderId > 0L ? 1 : 0) != 0, (Object)"\u8ba2\u5355id\u9519\u8bef");
        OrgSignupInfo orgSignupInfo = (OrgSignupInfo)this.orgSignupInfoDao.getById((Serializable)orderId, new String[0]);
        if (orgSignupInfo == null || orgSignupInfo.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        this.signupService.cancelSignupInfo(orgSignupInfo.getSignupPurchaseId(), orgId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOrder(Long orgId, Long orderId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((orderId != null && orderId > 0L ? 1 : 0) != 0, (Object)"\u8ba2\u5355id\u9519\u8bef");
        OrgSignupInfo orgSignupInfo = (OrgSignupInfo)this.orgSignupInfoDao.getById((Serializable)orderId, new String[0]);
        if (orgSignupInfo == null || orgSignupInfo.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        this.signupService.delSignupInfo(orgSignupInfo.getSignupPurchaseId(), orgId);
    }

    @Override
    public OrgSingupInfoDto getBuyCourseInfo(Long orgId, Long studentId, Collection<Long> ids) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((studentId != null && studentId > 0L ? 1 : 0) != 0, (Object)"\u5b66\u751f\u4fe1\u606f\u9519\u8bef");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"\u8bf7\u9009\u62e9\u5f85\u8d2d\u4e70\u8bfe\u7a0b");
        OrgStudent orgStudent = this.validateStudent(orgId, studentId);
        List courseList = this.orgCourseDao.getCourseList(this.getOrgNumber(orgId), ids, null, Integer.valueOf(0), null, null, null, null, null, null, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)courseList)) {
            Map courseMap = BaseUtils.listToMap((List)courseList, (String)"id");
            Set coverIds = BaseUtils.getPropertiesList((List)courseList, (String)"cover");
            Map<Long, String> coverMap = this.cacheCoverUrl(coverIds);
            Map<Long, List<String>> courseTeacherMap = this.cacheTeacher(courseMap.keySet());
            List<SignupCourseInfoDto> courseInfos = this.buildCourseInfos(ids, courseMap, coverMap, courseTeacherMap);
            double totalPrice = 0.0;
            for (SignupCourseInfoDto course : courseInfos) {
                totalPrice += course.getTotalPrice();
            }
            OrgSingupInfoDto data = new OrgSingupInfoDto();
            data.setStudentName(orgStudent.getName());
            data.setStudentMobile(orgStudent.getMobile());
            data.setTotalPrice(Double.valueOf(totalPrice));
            data.setCourseInfos(courseInfos);
            return data;
        }
        throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6240\u9009\u8bfe\u7a0b\u4e0d\u5b58\u5728");
    }

    @Override
    public List<SignupCourseInfoDto> fillCourseInfos(Long orgId, Collection<Long> ids) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"\u8bf7\u9009\u62e9\u5f85\u8d2d\u4e70\u8bfe\u7a0b");
        List courseList = this.orgCourseDao.getCourseList(this.getOrgNumber(orgId), ids, "", null, null, null, null, null, null, null, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)courseList)) {
            Map courseMap = BaseUtils.listToMap((List)courseList, (String)"id");
            Set coverIds = BaseUtils.getPropertiesList((List)courseList, (String)"cover");
            Map<Long, List<String>> courseTeacherMap = this.cacheTeacher(courseMap.keySet());
            Map<Long, String> coverMap = this.cacheCoverUrl(coverIds);
            List<SignupCourseInfoDto> courseInfos = this.buildCourseInfos(ids, courseMap, coverMap, courseTeacherMap);
            return courseInfos;
        }
        throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6240\u9009\u8bfe\u7a0b\u4e0d\u5b58\u5728");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public WxOrderRespDto getPayResult(Long orgId, Long purchaseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((purchaseId != null && purchaseId > 0L ? 1 : 0) != 0, (Object)"\u8ba2\u5355\u9519\u8bef");
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPayPurchaseId(purchaseId, false, new String[0]);
        if (orgSignupInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        boolean isSuccess = this.signupService.isPurchaseSucce(purchaseId, orgId, Integer.valueOf(-1));
        WxOrderRespDto dto = new WxOrderRespDto();
        dto.setPurchaseId(purchaseId);
        dto.setTotalPrice(orgSignupInfo.getTotalPrices().doubleValue() / 100.0);
        dto.setWxOrderStatus(isSuccess ? WxOrderStatus.FINISH.getCode() : WxOrderStatus.NOT_PAY.getCode());
        return dto;
    }

    @Override
    public boolean getPurchaseStatus(Long orgId, Long purchaseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((purchaseId != null && purchaseId > 0L ? 1 : 0) != 0, (Object)"purchaseId is illegal");
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.getByPurchaseId(orgId, purchaseId);
        if (orgSignupInfo == null || orgSignupInfo.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (orgSignupInfo.getTotalPrices() == 0L) {
            return true;
        }
        return this.signupService.isPurchaseSucce(orgSignupInfo.getSignupPurchaseId(), orgId, Integer.valueOf(-1));
    }

    @Override
    public boolean validate(Long orgId, String mobile, Set<Long> courseIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId illegal");
        Preconditions.checkArgument((boolean)ValidateUtil.isMobileAllowed((String)mobile), (Object)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(courseIds), (Object)"\u8bf7\u9009\u62e9\u8bfe\u7a0b");
        OrgStudent orgStudent = this.orgStudentDao.getStudentByMobileAndOrgId(orgId, mobile, new String[0]);
        Preconditions.checkArgument((orgStudent != null && orgStudent.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue() ? 1 : 0) != 0, (Object)"\u5b66\u751f\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664, \u8bf7\u5c1d\u8bd5\u6dfb\u52a0\u5df2\u6ce8\u518c\u5b66\u5458");
        List signupInfoList = this.orgSignupInfoDao.getSignupInfoList(orgId, orgStudent.getUserId(), null, null, new String[]{"signupPurchaseId", "purchaseStatus", "status"});
        if (CollectionUtils.isNotEmpty((Collection)signupInfoList)) {
            List signupCourseList;
            List sinupPurchaseList;
            HashSet<Long> unSuccPurchaseIds = new HashSet<Long>();
            HashSet<Long> succPurchaseIds = new HashSet<Long>();
            for (Object signupInfo : signupInfoList) {
                if (signupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode() && signupInfo.getStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
                    unSuccPurchaseIds.add(signupInfo.getSignupPurchaseId());
                    continue;
                }
                if (signupInfo.getStatus().intValue() != DeleteStatus.NORMAL.getValue()) continue;
                succPurchaseIds.add(signupInfo.getSignupPurchaseId());
            }
            if (CollectionUtils.isNotEmpty(unSuccPurchaseIds) && CollectionUtils.isNotEmpty((Collection)(sinupPurchaseList = this.orgSinupPurchaseDao.getByPurchaseIds(unSuccPurchaseIds, new String[0])))) {
                for (Object sinupPurchase : sinupPurchaseList) {
                    if (sinupPurchase.getStatus().intValue() != PayResult.SUCCESS.getCode() && (sinupPurchase.getStatus().intValue() != PayResult.IN_PROGRESS.getCode() || sinupPurchase.getTotalPrices() != 0.0)) continue;
                    succPurchaseIds.add(sinupPurchase.getPurchaseId());
                }
            }
            if (CollectionUtils.isNotEmpty(succPurchaseIds) && CollectionUtils.isNotEmpty((Collection)(signupCourseList = this.orgSignupCourseDao.loadByPurchaseIds(succPurchaseIds, new String[0])))) {
                List courseList;
                HashSet<Long> existCourseIds = new HashSet<Long>();
                for (OrgSignupCourse signupCourse : signupCourseList) {
                    existCourseIds.add(signupCourse.getOrgCourseId());
                }
                existCourseIds.retainAll(courseIds);
                if (CollectionUtils.isNotEmpty(existCourseIds) && CollectionUtils.isNotEmpty((Collection)(courseList = this.orgCourseDao.getCourseList(this.getOrgNumber(orgId), existCourseIds, "", null, null, null, null, null, null, null, new String[]{"id", "name"})))) {
                    ArrayList<String> courseNames = new ArrayList<String>();
                    for (OrgCourse orgCourse : courseList) {
                        if (!existCourseIds.contains(orgCourse.getId())) continue;
                        courseNames.add(orgCourse.getName());
                    }
                    if (CollectionUtils.isNotEmpty(courseNames)) {
                        String courseNamesStr = StringUtils.join(courseNames, (String)",");
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\"" + courseNamesStr + "\"\u8bfe\u7a0b\u5df2\u8d2d\u4e70,\u53ef\u76f4\u63a5\u8fdb\u5165\"\u6211\u7684\u8bfe\u7a0b\"\u67e5\u770b");
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean validate(Long orgId, Long purchaseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId illegal");
        Preconditions.checkArgument((purchaseId != null && purchaseId > 0L ? 1 : 0) != 0, (Object)"purchaseId illegal");
        OrgSinupPurchase orgSinupPurchase = this.orgSinupPurchaseDao.getByPurchaseId(purchaseId, new String[0]);
        if (orgSinupPurchase == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (orgSinupPurchase.getStatus().intValue() == PayResult.SUCCESS.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355\u5df2\u652f\u4ed8\u6210\u529f");
        }
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.getByPurchaseId(orgId, purchaseId);
        if (orgSignupInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (orgSignupInfo.getStatus().intValue() == BizConf.TRUE.intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        if (orgSignupInfo.getPurchaseStatus().intValue() == PayResult.SUCCESS.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355\u5df2\u652f\u4ed8\u6210\u529f");
        }
        List signupCourseList = this.orgSignupCourseDao.loadByPurchaseId(purchaseId, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)signupCourseList)) {
            Set courseIds = BaseUtils.getPropertiesList((List)signupCourseList, (String)"orgCourseId");
            return this.validate(orgId, orgSignupInfo.getMobile(), courseIds);
        }
        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8ba2\u5355\u5173\u8054\u8bfe\u7a0b\u4fe1\u606f\u9519\u8bef");
    }

    private Map<Long, List<String>> cacheTeacher(Collection<Long> courseIds) {
        if (CollectionUtils.isNotEmpty(courseIds)) {
            return this.orgCourseTeacherDao.getAllTeacherNames(courseIds);
        }
        return new HashMap<Long, List<String>>();
    }

    private Map<Long, String> cacheCoverUrl(Collection<Long> ids) {
        Map storageMap;
        HashMap<Long, String> cache = new HashMap<Long, String>();
        if (CollectionUtils.isNotEmpty(ids) && (storageMap = this.storageDao.getStorageMapByIds(ids)) != null && storageMap.size() > 0) {
            for (Number number : ids) {
                if (number != null && storageMap.containsKey(number.longValue())) {
                    Storage storage = (Storage)storageMap.get(number.longValue());
                    if (StringUtils.isNotBlank((CharSequence)storage.getAttach_url())) {
                        cache.put(number.longValue(), storage.getAttach_url());
                        continue;
                    }
                    cache.put(number.longValue(), StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
                    continue;
                }
                cache.put(0L, "https://imgs.genshuixue.com/24489340_jifl3uig.png");
            }
        }
        return cache;
    }

    private List<SignupCourseInfoDto> buildCourseInfos(Collection<Long> courseIds, Map<Long, OrgCourse> courseMap, Map<Long, String> coverMap, Map<Long, List<String>> courseTeacherMap) {
        ArrayList<SignupCourseInfoDto> courseInfos = new ArrayList<SignupCourseInfoDto>();
        if (CollectionUtils.isNotEmpty(courseIds) && courseMap != null) {
            for (Long courseId : courseIds) {
                OrgCourse orgCourse = courseMap.get(courseId);
                if (orgCourse == null) continue;
                SignupCourseInfoDto dto = new SignupCourseInfoDto();
                dto.setCourseType(orgCourse.getCourseType().intValue());
                dto.setOrgCourseId(orgCourse.getId());
                dto.setOrgCourseName(orgCourse.getName());
                dto.setOrgCourseNumber(orgCourse.getNumber());
                dto.setCoverId(orgCourse.getCover());
                if (orgCourse.getCover() != null && orgCourse.getCover() > 0 && coverMap != null && coverMap.containsKey(orgCourse.getCover().longValue())) {
                    dto.setCoverUrl(coverMap.get(orgCourse.getCover().longValue()));
                } else {
                    dto.setCoverUrl("https://imgs.genshuixue.com/24489340_jifl3uig.png");
                }
                if (courseTeacherMap != null && CollectionUtils.isNotEmpty((Collection)courseTeacherMap.get(orgCourse.getId()))) {
                    dto.setTeacherNames((Collection)courseTeacherMap.get(orgCourse.getId()));
                    dto.setTeacherNameStr(StringUtils.join((Iterable)courseTeacherMap.get(orgCourse.getId()), (String)","));
                }
                dto.setCount(1);
                dto.setOriginPrice(orgCourse.getPrice());
                dto.setTotalPrice(dto.getOriginPrice() * (double)dto.getCount());
                dto.setLessonCount(Integer.valueOf(orgCourse.getFreq() != null ? orgCourse.getFreq() : 0));
                courseInfos.add(dto);
            }
        }
        return courseInfos;
    }

    private OrgStudent validateStudent(Long orgId, Long studentId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((studentId != null && studentId > 0L ? 1 : 0) != 0, (Object)"studentId is illegal");
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (orgAccount == null || orgAccount.getIsDel().intValue() == BizConf.TRUE.intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)WxErrorCode.STUDENT_NOT_EXIST);
        }
        if (orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)WxErrorCode.STUDENT_NOT_IN_ORG);
        }
        return orgStudent;
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    private String getAuthSign(String key) {
        String md5 = MD5Utils.MD5((String)String.format("value=%s", key));
        String sign = MD5Utils.MD5((String)String.format("%s,%s", md5, UrlProperties.getProperty((String)"pay.sign.url")));
        return sign;
    }

    private boolean saveContent(final String key, final byte[] contents) throws BussinessException {
        boolean result = (Boolean)this.payRedisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                boolean result = connection.setNX(key.getBytes(), contents);
                connection.expire(key.getBytes(), 60L);
                return result;
            }
        });
        return result;
    }

    private String generateUrl(Long userId, Long purchaseId, Long orgNum, boolean isPC) {
        String key = String.format(PAY_REDIS_PRE, purchaseId);
        String sign = this.getAuthSign(key);
        String prefix = null;
        String jumpPayFormat = null;
        String successUrl = null;
        String payType = null;
        if (isPC) {
            prefix = PropertiesReader.getProperties((String)"config.properties").getProperty("wx.school.url");
            jumpPayFormat = "%s?order_number=%s&pay_type=%s&client=pc&success_url=%s";
            successUrl = String.format("%s/%s/order/result?purchaseId=%s", prefix, orgNum.toString(), purchaseId.toString());
            payType = StringUtils.join(PC_PAY_TYPES, (String)",");
        } else {
            prefix = PropertiesReader.getProperties((String)"config.properties").getProperty("wx.school.m.url");
            jumpPayFormat = "%s?order_number=%s&pay_type=%s&client=m&success_url=%s";
            successUrl = String.format("%s/%s/order/result.do?purchaseId=%s", prefix, orgNum.toString(), purchaseId.toString());
            payType = StringUtils.join(M_PAY_TYPES, (String)",");
        }
        String next = String.format(jumpPayFormat, UrlProperties.getProperty((String)"pay.authPayment"), purchaseId, payType, successUrl);
        RedisContent redisContent = new RedisContent(userId, UserRoleEnum.STUDENT.getCode());
        String value = new Gson().toJson((Object)redisContent);
        try {
            this.saveContent(key, value.getBytes("utf-8"));
            String authFormat = "%s?key=%s&sign=%s&next=%s";
            String url = String.format(authFormat, UrlProperties.getProperty((String)"pay.auth.url"), key, sign, URLEncoder.encode(next, "UTF-8"));
            return url;
        }
        catch (Exception e) {
            log.error("redis save faild, catch error:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)WxErrorCode.BUY_FAILD);
        }
    }

    static {
        PC_PAY_TYPES.add(GsxPayType.ALI_PC_PAY.getType());
        PC_PAY_TYPES.add(GsxPayType.ALI_QR_PAY.getType());
        PC_PAY_TYPES.add(GsxPayType.WEIXIN_QR_PAY.getType());
        PC_PAY_TYPES.add(GsxPayType.BANK_PAY.getType());
        M_PAY_TYPES.add(GsxPayType.ALI_M_PAY.getType());
        M_PAY_TYPES.add(GsxPayType.ALI_QR_PAY.getType());
        M_PAY_TYPES.add(GsxPayType.WEIXIN_JS_PAY.getType());
        M_PAY_TYPES.add(GsxPayType.WEIXIN_QR_PAY.getType());
        M_PAY_TYPES.add(GsxPayType.BILL_POS_PAY.getType());
    }
}

