/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.wx.dto.response;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;

public class WxPcLoginRoleDto {
    private String orgName;
    private Integer roleType;
    private String roleTypeName;
    private Integer lastLogin;
    private String campusLogoUrl;
    private String wxPcJumpToken;
    @JsonIgnore
    private WxPcAuth wxPcAuth;

    public void createWxPcJumpToken() {
        Preconditions.checkArgument((null != this.wxPcAuth ? 1 : 0) != 0, (Object)"null != wxPcAuth!");
        String json = new Gson().toJson((Object)this.wxPcAuth);
        this.wxPcJumpToken = EncryptUtils.base64EncodeStrWithFactor((String)json);
    }

    public static WxPcAuth makeWxPcAuthFromToken(String wxPcJumpToken) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)wxPcJumpToken), (Object)"wxPcJumpToken is empty!");
        try {
            String json = EncryptUtils.strDecode((String)wxPcJumpToken);
            return (WxPcAuth)new Gson().fromJson(json, WxPcAuth.class);
        }
        catch (Exception e) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "token\u89e3\u6790\u5931\u8d25:" + e.getMessage());
        }
    }

    public String getOrgName() {
        return this.orgName;
    }

    public Integer getRoleType() {
        return this.roleType;
    }

    public String getRoleTypeName() {
        return this.roleTypeName;
    }

    public Integer getLastLogin() {
        return this.lastLogin;
    }

    public String getCampusLogoUrl() {
        return this.campusLogoUrl;
    }

    public String getWxPcJumpToken() {
        return this.wxPcJumpToken;
    }

    public WxPcAuth getWxPcAuth() {
        return this.wxPcAuth;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setRoleType(Integer roleType) {
        this.roleType = roleType;
    }

    public void setRoleTypeName(String roleTypeName) {
        this.roleTypeName = roleTypeName;
    }

    public void setLastLogin(Integer lastLogin) {
        this.lastLogin = lastLogin;
    }

    public void setCampusLogoUrl(String campusLogoUrl) {
        this.campusLogoUrl = campusLogoUrl;
    }

    public void setWxPcJumpToken(String wxPcJumpToken) {
        this.wxPcJumpToken = wxPcJumpToken;
    }

    public void setWxPcAuth(WxPcAuth wxPcAuth) {
        this.wxPcAuth = wxPcAuth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPcLoginRoleDto)) {
            return false;
        }
        WxPcLoginRoleDto other = (WxPcLoginRoleDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        Integer this$roleType = this.getRoleType();
        Integer other$roleType = other.getRoleType();
        if (this$roleType == null ? other$roleType != null : !((Object)this$roleType).equals(other$roleType)) {
            return false;
        }
        String this$roleTypeName = this.getRoleTypeName();
        String other$roleTypeName = other.getRoleTypeName();
        if (this$roleTypeName == null ? other$roleTypeName != null : !this$roleTypeName.equals(other$roleTypeName)) {
            return false;
        }
        Integer this$lastLogin = this.getLastLogin();
        Integer other$lastLogin = other.getLastLogin();
        if (this$lastLogin == null ? other$lastLogin != null : !((Object)this$lastLogin).equals(other$lastLogin)) {
            return false;
        }
        String this$campusLogoUrl = this.getCampusLogoUrl();
        String other$campusLogoUrl = other.getCampusLogoUrl();
        if (this$campusLogoUrl == null ? other$campusLogoUrl != null : !this$campusLogoUrl.equals(other$campusLogoUrl)) {
            return false;
        }
        String this$wxPcJumpToken = this.getWxPcJumpToken();
        String other$wxPcJumpToken = other.getWxPcJumpToken();
        if (this$wxPcJumpToken == null ? other$wxPcJumpToken != null : !this$wxPcJumpToken.equals(other$wxPcJumpToken)) {
            return false;
        }
        WxPcAuth this$wxPcAuth = this.getWxPcAuth();
        WxPcAuth other$wxPcAuth = other.getWxPcAuth();
        return !(this$wxPcAuth == null ? other$wxPcAuth != null : !((Object)this$wxPcAuth).equals(other$wxPcAuth));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxPcLoginRoleDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        Integer $roleType = this.getRoleType();
        result = result * 59 + ($roleType == null ? 43 : ((Object)$roleType).hashCode());
        String $roleTypeName = this.getRoleTypeName();
        result = result * 59 + ($roleTypeName == null ? 43 : $roleTypeName.hashCode());
        Integer $lastLogin = this.getLastLogin();
        result = result * 59 + ($lastLogin == null ? 43 : ((Object)$lastLogin).hashCode());
        String $campusLogoUrl = this.getCampusLogoUrl();
        result = result * 59 + ($campusLogoUrl == null ? 43 : $campusLogoUrl.hashCode());
        String $wxPcJumpToken = this.getWxPcJumpToken();
        result = result * 59 + ($wxPcJumpToken == null ? 43 : $wxPcJumpToken.hashCode());
        WxPcAuth $wxPcAuth = this.getWxPcAuth();
        result = result * 59 + ($wxPcAuth == null ? 43 : ((Object)$wxPcAuth).hashCode());
        return result;
    }

    public String toString() {
        return "WxPcLoginRoleDto(orgName=" + this.getOrgName() + ", roleType=" + this.getRoleType() + ", roleTypeName=" + this.getRoleTypeName() + ", lastLogin=" + this.getLastLogin() + ", campusLogoUrl=" + this.getCampusLogoUrl() + ", wxPcJumpToken=" + this.getWxPcJumpToken() + ", wxPcAuth=" + this.getWxPcAuth() + ")";
    }

    public static class WxPcAuth {
        private Integer orgId;
        private Integer cascadeId;
        private String mobile;
        private String uuid;

        public Integer getOrgId() {
            return this.orgId;
        }

        public Integer getCascadeId() {
            return this.cascadeId;
        }

        public String getMobile() {
            return this.mobile;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setOrgId(Integer orgId) {
            this.orgId = orgId;
        }

        public void setCascadeId(Integer cascadeId) {
            this.cascadeId = cascadeId;
        }

        public void setMobile(String mobile) {
            this.mobile = mobile;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WxPcAuth)) {
                return false;
            }
            WxPcAuth other = (WxPcAuth)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$orgId = this.getOrgId();
            Integer other$orgId = other.getOrgId();
            if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
                return false;
            }
            Integer this$cascadeId = this.getCascadeId();
            Integer other$cascadeId = other.getCascadeId();
            if (this$cascadeId == null ? other$cascadeId != null : !((Object)this$cascadeId).equals(other$cascadeId)) {
                return false;
            }
            String this$mobile = this.getMobile();
            String other$mobile = other.getMobile();
            if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
                return false;
            }
            String this$uuid = this.getUuid();
            String other$uuid = other.getUuid();
            return !(this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WxPcAuth;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $orgId = this.getOrgId();
            result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
            Integer $cascadeId = this.getCascadeId();
            result = result * 59 + ($cascadeId == null ? 43 : ((Object)$cascadeId).hashCode());
            String $mobile = this.getMobile();
            result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
            String $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
            return result;
        }

        public String toString() {
            return "WxPcLoginRoleDto.WxPcAuth(orgId=" + this.getOrgId() + ", cascadeId=" + this.getCascadeId() + ", mobile=" + this.getMobile() + ", uuid=" + this.getUuid() + ")";
        }

        @ConstructorProperties(value={"orgId", "cascadeId", "mobile", "uuid"})
        public WxPcAuth(Integer orgId, Integer cascadeId, String mobile, String uuid) {
            this.orgId = orgId;
            this.cascadeId = cascadeId;
            this.mobile = mobile;
            this.uuid = uuid;
        }
    }
}

