
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.www.authentication.handler;

import com.baijia.tianxiao.biz.www.LoginAccountDtoHelper;
import com.baijia.tianxiao.biz.www.Util.InitPageUtils;
import com.baijia.tianxiao.biz.www.Util.LoginAppInfoContext;
import com.baijia.tianxiao.biz.www.Util.PermissionTransformUtil;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.Credential;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.biz.www.constant.BizConstant;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.memcached.MemcachedUtil;
import com.baijia.yunying.hag.service.HagService;

import com.google.common.collect.Lists;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

import lombok.extern.slf4j.Slf4j;
import net.rubyeye.xmemcached.exception.MemcachedException;

/**
 * @author caoliang
 * @version 1.0
 * @title TxAccountAuthenticateHandler
 * @desc O(∩_∩)O~
 * @date 2016年8月24日
 */
@Slf4j
public class TxAccountAuthenticateHandler extends AbstractAuthenticateHandler {

    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private LoginAccountDtoHelper loginAccountDtoHelper;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private HagService hagService;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;

    @Override
    protected boolean doAuthentication(Credential credential, Map<String, Object> options) throws BussinessException {
        OrgAccount orgAccount = orgAccountService.getOrgAccountByMobile(credential.getMobile());
        if (orgAccount == null) {
            log.info("can not find mobile:{}", credential.getMobile());
            return false;
        }
        options.put(ORG_ACCOUNT_KEY, orgAccount);
        // 临时密码
        Boolean isTemp = false;
        try {
            String tempPwd = MemcachedUtil.get("uniq_temp_tx_password_" + credential.getMobile());
            if (StringUtils.isNoneBlank(tempPwd)) {
                if (tempPwd.equals(credential.getPassword())) {
                    // 这里注释掉缓存删除, 因为后面可能有子帐号也要用到临时密码, 届时再做删除操作 by hongyan FIXBUG:临时密码登录时无法选择多身份
                    // MemcachedUtil.delete("uniq_temp_tx_password_" + credential.getMobile());
                    isTemp = true;
                }
            }
        } catch (TimeoutException | InterruptedException | MemcachedException e) {
            log.error("get temp pwd error!mobile:{}", credential.getMobile(), e);
        }

        try {
            if (!isTemp) {
                if (!PasswordUtil.validatePassword(credential.getPassword(), orgAccount.getPassword())) {
                    log.info("orgaccount pwd error!");
                    return false;
                }
            }
        } catch (Exception e) {
            log.info("login pwd:{},hash:{},error!:{}", credential.getPassword(), orgAccount.getPassword(), e);
            return false;
        }

        boolean hasTXPermission = hagService.hasPermission(orgAccount.getNumber(), BizConf.DEFAULT_TYPE,
                BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER);
        if (!hasTXPermission) {
            log.info("right pwd but hag not permission orgNumber:{}", orgAccount.getNumber());
            return false;
        }

        OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());

        if (null == orgSubAccount || orgSubAccount.getStatus().intValue() != OrgSubAccountStatus.NORMAL.getCode().intValue()) {
            log.info("org:{}, can not login because the orgSubAccount is forbidden", orgSubAccount);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "账号已停用");
        }

        TXAccount txAccount =
                txAccountService.getByOrgId(0 != orgSubAccount.getPid() ? orgSubAccount.getPid() : orgAccount.getId());
        options.put(TX_ACCOUNT_KEY, txAccount);

        // 线上校区不允许app登录
        if (null != orgSubAccount && orgSubAccount.getOnlineType() == Flag.TRUE.getInt()) {
            log.info("orgSubAccount onlineType is invalide! orgId:{}", orgAccount.getId());
            return false;
        }

        if (orgSubAccount.getPid() != 0) {
            // 找主帐号版本
            if (orgSubAccount.getStatus() != OrgSubAccountStatus.NORMAL.getCode().intValue()) {
                log.info("orgSubAccount status is invalide! orgId:{}", orgAccount.getId());
                return false;
            }
            txAccount = txAccountService.getByOrgId(orgSubAccount.getPid());
            if (txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode()) {
                // 大众版不能有分校，有的话算脏数据，不给登录
                log.info("fenxiaoqu");
                return false;
            }
            options.put(MASTER_FLAG, Boolean.FALSE);
        } else {
            Object version = options.get(BizConstant.VERSION);
            // 检查主校区
            if (version != null
                    && !loginAccountDtoHelper.validTXVersion(txAccount, options.get(BizConstant.VERSION).toString())) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "大众版用户请升级至最新版本");
            }
            options.put(MASTER_FLAG, Boolean.TRUE);
            options.put(IS_FROM_MASTER, orgAccount.getId());
        }
        options.put(TX_ACCOUNT_VERSION, orgSubAccount.getAccountVersion());
        return true;
    }

    @Override
    protected boolean postAuthenticate(Credential credential, boolean authenticated, List<TXLoginAccountDto> loginDtos,
                                       Map<String, Object> options) throws BussinessException, Exception {
        OrgAccount orgAccount = (OrgAccount) options.get(ORG_ACCOUNT_KEY);
        TXAccount txAccount = (TXAccount) options.get(TX_ACCOUNT_KEY);
        OrgInfo orgInfo = orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
        TXLoginAccountDto dto = loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
        dto.setDataAccountType(BizConf.NORMAL_ACCOUNT);
        List<RoleDto> roleDtos = Lists.newArrayList();
        RoleDto roleDto = new RoleDto();
        roleDto.setId(orgAccount.getNumber());
        roleDto.setNickName(orgInfo.getContacts());
        roleDto.setName("校长");
        roleDto.setMobile(orgAccount.getMobile());
        roleDtos.add(roleDto);
        String auth_token = null;
        Boolean masterFlag = (Boolean) options.get(MASTER_FLAG);
        Integer fromMasterOrgId = GenericsUtils.getNullWithoutError(options, IS_FROM_MASTER);

        Integer accountVersion = (Integer) options.get(TX_ACCOUNT_VERSION);
        if (masterFlag) {
            roleDto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
            // version<2.2.0的版本有个地方支持的auth_token的长度只有126,不是新的登录接口返回的token,会报错
            if (LoginAppInfoContext.isInitPageLoginUsers()) {
                auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), null, txAccount.getId(), orgAccount.getId(),
                        accountVersion, TX_APP_ENVIRONMENT, fromMasterOrgId);
            } else {
                auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), null, txAccount.getId(), accountVersion,
                        TX_APP_ENVIRONMENT);
            }
        } else {
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            if (LoginAppInfoContext.isInitPageLoginUsers()) {
                auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), null, null, orgAccount.getId(),
                        accountVersion, TX_APP_ENVIRONMENT, fromMasterOrgId);
            } else {
                auth_token =
                        EncryptUtils.txStrEncode(orgAccount.getId(), null, null, accountVersion, TX_APP_ENVIRONMENT);
            }
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
        }
        TxAccountPermissionsDto txAccountPermissionDto =
                txAccountPermissionService.universalGetPermissions(orgAccount.getId(), null);
        roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
        roleDto.setAuth_token(auth_token);
        roleDto.setCreateTime(orgAccount.getCreateTime().getTime());
        // 天校写死的常量
        roleDto.setRoleAvatar(dto.getAvatar());
        InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShowName());
        dto.setHasRoles(roleDtos);
        loginDtos.add(dto);
        return true;
    }

    public static void main(String[] args) throws Exception {
        String txStrEncode = EncryptUtils.txStrEncode(123, null, 1234, 3974, 1, "https://fdsf", null);
        System.out.println("token is : " + txStrEncode);
        System.out.println("strDecode is : " + EncryptUtils.strDecode(txStrEncode));

    }

}