/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www.authentication;

import com.baijia.tianxiao.biz.www.IllegalAccessCtrlService;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.AuthenticateManager;
import com.baijia.tianxiao.biz.www.authentication.Credential;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthenticateManagerImpl
implements AuthenticateManager {
    private static final Logger log = LoggerFactory.getLogger(AuthenticateManagerImpl.class);
    private static final String LOGIN_KEY_PREFIX = "tx_login_code_";
    private List<AbstractAuthenticateHandler> handlers;
    @Autowired
    private IllegalAccessCtrlService accessCtrService;

    @Override
    public List<TXLoginAccountDto> authenticate(Credential credential, Map<String, Object> options) throws BussinessException, Exception {
        ArrayList loginDtos = Lists.newArrayList();
        log.info("login credential:{}", (Object)credential);
        String redisKey = LOGIN_KEY_PREFIX + credential.getMobile();
        if (this.accessCtrService.isLocked(redisKey)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d26\u6237\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf71\u5c0f\u65f6\u5019\u518d\u8bd5");
        }
        boolean succAuthenticate = false;
        log.info("handlers:{}", this.handlers);
        for (AbstractAuthenticateHandler handler : this.handlers) {
            if (!handler.authenticate(credential, loginDtos, options)) continue;
            succAuthenticate = true;
        }
        if (!succAuthenticate) {
            log.debug("login fail");
            WebResponse<Object> detectRes = this.accessCtrService.detect(redisKey);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, detectRes.getMsg());
        }
        log.info("login loginDtos:{}", (Object)loginDtos);
        return loginDtos;
    }

    public List<AbstractAuthenticateHandler> getHandlers() {
        return this.handlers;
    }

    public IllegalAccessCtrlService getAccessCtrService() {
        return this.accessCtrService;
    }

    public void setHandlers(List<AbstractAuthenticateHandler> handlers) {
        this.handlers = handlers;
    }

    public void setAccessCtrService(IllegalAccessCtrlService accessCtrService) {
        this.accessCtrService = accessCtrService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticateManagerImpl)) {
            return false;
        }
        AuthenticateManagerImpl other = (AuthenticateManagerImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AbstractAuthenticateHandler> this$handlers = this.getHandlers();
        List<AbstractAuthenticateHandler> other$handlers = other.getHandlers();
        if (this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers)) {
            return false;
        }
        IllegalAccessCtrlService this$accessCtrService = this.getAccessCtrService();
        IllegalAccessCtrlService other$accessCtrService = other.getAccessCtrService();
        return !(this$accessCtrService == null ? other$accessCtrService != null : !this$accessCtrService.equals(other$accessCtrService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthenticateManagerImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AbstractAuthenticateHandler> $handlers = this.getHandlers();
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        IllegalAccessCtrlService $accessCtrService = this.getAccessCtrService();
        result = result * 59 + ($accessCtrService == null ? 43 : $accessCtrService.hashCode());
        return result;
    }

    public String toString() {
        return "AuthenticateManagerImpl(handlers=" + this.getHandlers() + ", accessCtrService=" + this.getAccessCtrService() + ")";
    }
}

