/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www.authentication.handler;

import com.baijia.tianxiao.biz.www.LoginAccountDtoHelper;
import com.baijia.tianxiao.biz.www.Util.InitPageUtils;
import com.baijia.tianxiao.biz.www.Util.LoginAppInfoContext;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.Credential;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.biz.www.constant.ExpTxPermission;
import com.baijia.tianxiao.dal.index.constant.TxVisitorStatus;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.pcAuthority.dao.TXPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.hag.HagDownload;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionHasType;
import com.baijia.tianxiao.sal.organization.index.service.TxVisitorService;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TxVisitorAuthenticateHandler
extends AbstractAuthenticateHandler {
    private static final Logger log = LoggerFactory.getLogger(TxVisitorAuthenticateHandler.class);
    public static final int EXP_USED = 1;
    public static List<ExpTxPermission> FORBID_PERMISSIONS = Lists.newArrayList((Object[])new ExpTxPermission[]{ExpTxPermission.PAY_PWD, ExpTxPermission.DRAW, ExpTxPermission.GATHERING_H5, ExpTxPermission.ORG_TEL_ADD, ExpTxPermission.ORG_TEL_DEL, ExpTxPermission.ORG_TEL_EDIT, ExpTxPermission.SET_PAY_PWD});
    @Autowired
    private TxVisitorService txVisitorService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private LoginAccountDtoHelper loginAccountDtoHelper;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private TXPermissionDao txPermissionDao;

    @Override
    protected boolean preAuthenticate(Credential credential, Map<String, Object> options) throws BussinessException {
        if (!super.preAuthenticate(credential, options)) {
            return false;
        }
        String vReq = options.get("version").toString().replace(".", "");
        String vBase = "131";
        for (int index = 0; index < vBase.length() && Integer.valueOf(String.valueOf(vBase.charAt(0))) >= Integer.valueOf(String.valueOf(vReq.charAt(0))) && Integer.valueOf(String.valueOf(vBase.charAt(1))) >= Integer.valueOf(String.valueOf(vReq.charAt(1))) && Integer.valueOf(String.valueOf(vBase.charAt(1))) >= Integer.valueOf(String.valueOf(vReq.charAt(1))); ++index) {
            Integer base = Integer.valueOf(String.valueOf(vBase.charAt(index)));
            Integer req = Integer.valueOf(String.valueOf(vReq.charAt(index)));
            if (base <= req) continue;
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u5347\u7ea7\u81f3\u6700\u65b0\u7248\u672c");
        }
        return true;
    }

    @Override
    protected boolean doAuthentication(Credential credential, Map<String, Object> options) throws BussinessException {
        List txVisitors = this.txVisitorService.getByMobile(credential.getMobile());
        if (CollectionUtils.isEmpty((Collection)txVisitors)) {
            return false;
        }
        TxVisitor txVisitor = (TxVisitor)txVisitors.get(0);
        if (txVisitor.getStatus().intValue() != TxVisitorStatus.ACTIVE.getCode()) {
            return false;
        }
        if (txVisitor.getStartTime() == null) {
            return false;
        }
        if (Days.daysBetween((ReadableInstant)new DateTime(txVisitor.getStartTime().getTime()), (ReadableInstant)DateTime.now()).isGreaterThan(Days.days((int)txVisitor.getRemainDay()))) {
            return false;
        }
        try {
            if (!PasswordUtil.validatePassword((String)credential.getPassword(), (String)txVisitor.getPassword())) {
                return false;
            }
        }
        catch (Exception e) {
            log.info("login pwd:{},hash:{},error!:{}", new Object[]{credential.getPassword(), txVisitor.getPassword(), e});
            return false;
        }
        options.put("txVisitor", txVisitor);
        return true;
    }

    @Override
    protected boolean postAuthenticate(Credential credential, boolean authenticated, List<TXLoginAccountDto> loginDtos, Map<String, Object> options) throws BussinessException, Exception {
        HashMap params = Maps.newHashMap();
        params.put("resource", "tianxiao_trial_account");
        String url = PropertiesReader.getValue((String)"hag", (String)"hag.http.url.downloadList");
        String response = HttpClientUtils.doPost((String)url, (Map)params);
        HagDownload hagDto = (HagDownload)JacksonUtil.str2Obj((String)response, HagDownload.class);
        log.info("hagDto:{}", (Object)hagDto);
        if (hagDto == null || CollectionUtils.isEmpty((Collection)hagDto.getData())) {
            return false;
        }
        String numberStr = ((String)hagDto.getData().get(0)).split("#")[0];
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(Integer.valueOf(numberStr), new String[0]);
        if (orgAccount == null) {
            return false;
        }
        TxVisitor txVisitor = (TxVisitor)options.get("txVisitor");
        Integer fromMasterOrgId = (Integer)GenericsUtils.getNullWithoutError(options, (String)"fromMasterOrgId");
        OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
        TXLoginAccountDto txLoginAccountDto = this.loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
        txLoginAccountDto.setDataAccountType(1);
        ArrayList roleDtos = Lists.newArrayList();
        RoleDto roleDto = new RoleDto();
        roleDto.setNickName(orgInfo.getShortName());
        roleDto.setName(credential.getMobile());
        roleDto.setMobile(credential.getMobile());
        roleDto.setType(1);
        roleDto.setId(orgAccount.getNumber());
        TXAccount txAccount = this.txAccountService.getByOrgId(orgAccount.getId(), new String[0]);
        String auth_token = null;
        auth_token = LoginAppInfoContext.isInitPageLoginUsers() ? EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, (Integer)txAccount.getId(), null, (Integer)txVisitor.getId(), null, (String)TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId) : EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, (Integer)txAccount.getId(), null, (String)TX_APP_ENVIRONMENT);
        roleDto.setAuth_token(auth_token);
        roleDto.setCreateTime(txVisitor.getCreateTime().getTime());
        ArrayList permissions = Lists.newArrayList();
        for (ExpTxPermission tp : FORBID_PERMISSIONS) {
            PermissionDto pd = new PermissionDto();
            pd.setName(tp.getLabel());
            pd.setTag(ExpTxPermission.getCompleteValue(tp));
            pd.setType(Integer.valueOf(TXPermissionHasType.LOST.getCode()));
            permissions.add(pd);
        }
        List txPermissionsInDB = this.txPermissionDao.getAll(new String[0]);
        for (TXPermission txPermission : txPermissionsInDB) {
            PermissionDto pd = new PermissionDto();
            pd.setName(txPermission.getName());
            pd.setTag(txPermission.getCode().toString());
            pd.setType(Integer.valueOf(TXPermissionHasType.OWN.getCode()));
            permissions.add(pd);
        }
        roleDto.setHasPermissions(permissions);
        roleDtos.add(roleDto);
        txLoginAccountDto.setHasRoles(roleDtos);
        if (txVisitor.getIsUsed() != null && txVisitor.getIsUsed() != 1) {
            txVisitor.setIsUsed(Integer.valueOf(1));
            this.txVisitorService.updateVisitor(txVisitor);
        }
        log.info("txLoginAccountDto of txVisitor is :{} ", (Object)txLoginAccountDto);
        InitPageUtils.fillInitPageInfos(txAccount, txLoginAccountDto, orgInfo.getShortName());
        loginDtos.add(txLoginAccountDto);
        return true;
    }
}

