/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www.authentication.handler;

import com.baijia.tianxiao.biz.www.LoginAccountDtoHelper;
import com.baijia.tianxiao.biz.www.Util.InitPageUtils;
import com.baijia.tianxiao.biz.www.Util.LoginAppInfoContext;
import com.baijia.tianxiao.biz.www.Util.PermissionTransformUtil;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.Credential;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.memcached.MemcachedUtil;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TxCascadeAccountAuthenticateHandler
extends AbstractAuthenticateHandler {
    private static final Logger log = LoggerFactory.getLogger(TxCascadeAccountAuthenticateHandler.class);
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private LoginAccountDtoHelper loginAccountDtoHelper;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private HagService hagService;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;

    @Override
    protected boolean doAuthentication(Credential credential, Map<String, Object> options) throws BussinessException {
        Boolean isTemp = false;
        try {
            String tempPwd = (String)MemcachedUtil.get((String)("uniq_temp_tx_password_" + credential.getMobile()));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tempPwd}) && tempPwd.equals(credential.getPassword())) {
                MemcachedUtil.delete((String)("uniq_temp_tx_password_" + credential.getMobile()));
                isTemp = true;
            }
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            log.error("get temp pwd error!mobile:{}", (Object)credential.getMobile(), (Object)e);
        }
        TXCascadeCredential txCascadeCredential = this.txCascadeCredentialDao.getByMobile(credential.getMobile());
        if (txCascadeCredential == null) {
            return false;
        }
        OrgAccount txOrgAccount = this.orgAccountService.getOrgAccountByMobile(credential.getMobile());
        if (txOrgAccount == null) {
            List subAccountList;
            boolean isAllDelAccount = true;
            ArrayList allSubAccount = Lists.newArrayList();
            List txCascadeAccounts = this.txCascadeAccountDao.getByCredentialId(txCascadeCredential.getId());
            if (CollectionUtils.isNotEmpty((Collection)txCascadeAccounts)) {
                for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
                    if (txCascadeAccount.getStatus().intValue() != DataStatus.NORMAL.getValue()) continue;
                    isAllDelAccount = false;
                    allSubAccount.add(txCascadeAccount.getOrgId());
                }
                if (isAllDelAccount) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d26\u53f7\u5df2\u505c\u7528");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)allSubAccount) && CollectionUtils.isEmpty((Collection)(subAccountList = this.orgSubAccountService.getByOrgIds((Collection)allSubAccount, new String[0])))) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d26\u53f7\u5df2\u505c\u7528");
            }
        }
        OrgAccount orgAccount = null;
        if (options.get("orgAccount") != null) {
            orgAccount = (OrgAccount)options.get("orgAccount");
        }
        try {
            if (!isTemp.booleanValue()) {
                if (orgAccount != null) {
                    if (!PasswordUtil.validatePassword((String)credential.getPassword(), (String)orgAccount.getPassword())) {
                        log.info("cascade orgAccount pwd error mobile:{}", (Object)credential.getMobile());
                        return false;
                    }
                } else if (!PasswordUtil.validatePassword((String)credential.getPassword(), (String)txCascadeCredential.getPassword())) {
                    log.info("no orgAccount and cascade credential pwd error mobile:{}", (Object)credential.getMobile());
                    return false;
                }
            }
        }
        catch (Exception e) {
            log.info("login pwd:{},hash:{},error!:{}", new Object[]{credential.getPassword(), txCascadeCredential.getPassword(), e});
            return false;
        }
        options.put("txCascadeCredential", txCascadeCredential);
        return true;
    }

    @Override
    protected boolean postAuthenticate(Credential credential, boolean authenticated, List<TXLoginAccountDto> loginDtos, Map<String, Object> options) throws BussinessException, Exception {
        TXCascadeCredential txCascadeCredential = (TXCascadeCredential)options.get("txCascadeCredential");
        Integer fromMasterOrgId = (Integer)GenericsUtils.getNullWithoutError(options, (String)"fromMasterOrgId");
        OrgAccount masterOrgAccount = (OrgAccount)options.get("orgAccount");
        Integer fromOrgId = null;
        List txCascadeAccounts = this.txCascadeAccountDao.getValidAccountsByCredentialId(txCascadeCredential.getId());
        if (CollectionUtils.isEmpty((Collection)txCascadeAccounts)) {
            return false;
        }
        if (masterOrgAccount != null) {
            fromOrgId = masterOrgAccount.getId();
        }
        HashMap existDto = Maps.newHashMap();
        log.info("txCascadeAccounts:{}", (Object)txCascadeAccounts);
        for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
            OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(txCascadeAccount.getOrgId());
            log.info("for orgAccount :{} , fromOrgId is:{} ", (Object)orgAccount, (Object)fromOrgId);
            boolean hasTXPermission = this.hagService.hasPermission((Object)orgAccount.getNumber(), 0, "jigou_tianxiao_orgNumber", new Object[0]);
            if (!hasTXPermission) {
                log.info("no hag txCascadeAccount:{}", (Object)txCascadeAccount);
                continue;
            }
            OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId(), new String[0]);
            if (null == orgSubAccount || orgSubAccount.getStatus().intValue() != OrgSubAccountStatus.NORMAL.getCode().intValue()) {
                log.info("cascade:{}, can not login because the orgSubAccount is forbidden", (Object)txCascadeAccount);
                continue;
            }
            if (null != orgSubAccount && orgSubAccount.getOnlineType().intValue() == Flag.TRUE.getInt()) {
                log.info("cascade orgSubAccount onlineType invalid:{}", (Object)orgSubAccount);
                continue;
            }
            TXAccount txAccount = this.txAccountService.getByOrgId(orgSubAccount.getPid() > 0 ? orgSubAccount.getPid() : orgSubAccount.getOrgId(), new String[0]);
            String auth_token = null;
            if (txAccount == null) {
                log.info("this cascade:{} can not find txAccount, maybe txAccount is forbidden", (Object)txCascadeAccount);
                continue;
            }
            if (txAccount.getVipLevel() == TXAccountType.DAZHONG.getCode()) {
                log.info("cascade txAccount invalid111:{}", (Object)txAccount);
                continue;
            }
            auth_token = orgSubAccount.getPid() == 0 && txCascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue() ? (LoginAppInfoContext.isInitPageLoginUsers() ? EncryptUtils.txStrEncode((Integer)orgAccount.getId(), (Integer)txCascadeAccount.getId(), (Integer)txAccount.getId(), (Integer)fromOrgId, (Integer)txCascadeAccount.getAccountVersion(), (String)TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId) : EncryptUtils.txStrEncode((Integer)orgAccount.getId(), (Integer)txCascadeAccount.getId(), (Integer)txAccount.getId(), (Integer)txCascadeAccount.getAccountVersion(), (String)TX_APP_ENVIRONMENT)) : (LoginAppInfoContext.isInitPageLoginUsers() ? EncryptUtils.txStrEncode((Integer)orgAccount.getId(), (Integer)txCascadeAccount.getId(), null, (Integer)fromOrgId, (Integer)txCascadeAccount.getAccountVersion(), (String)TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId) : EncryptUtils.txStrEncode((Integer)orgAccount.getId(), (Integer)txCascadeAccount.getId(), null, (Integer)txCascadeAccount.getAccountVersion(), (String)TX_APP_ENVIRONMENT));
            OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
            TXLoginAccountDto dto = null;
            if (existDto.containsKey(orgAccount.getId())) {
                dto = (TXLoginAccountDto)existDto.get(orgAccount.getId());
            } else {
                dto = this.loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
                ArrayList roleDtos = Lists.newArrayList();
                dto.setHasRoles(roleDtos);
                existDto.put(orgAccount.getId(), dto);
                loginDtos.add(dto);
            }
            dto.setDataAccountType(0);
            RoleDto roleDto = new RoleDto();
            roleDto.setId(txCascadeAccount.getId());
            roleDto.setNickName(txCascadeCredential.getName());
            roleDto.setType(txCascadeAccount.getAccountType());
            roleDto.setAuth_token(auth_token);
            log.info("Token={}", (Object)auth_token);
            roleDto.setMobile(txCascadeCredential.getMobile());
            roleDto.setCreateTime(txCascadeAccount.getCreateTime().getTime());
            InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShowName());
            TxAccountPermissionsDto txAccountPermissionDto = this.txAccountPermissionService.universalGetPermissions(orgAccount.getId().intValue(), txCascadeAccount.getId());
            roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
            if (StringUtils.isNotBlank((CharSequence)txCascadeCredential.getAvatar())) {
                roleDto.setRoleAvatar(txCascadeCredential.getAvatar());
            } else {
                roleDto.setRoleAvatar("https://imgs.genshuixue.com/21644918_xqjeiipb.png");
            }
            dto.getHasRoles().add(roleDto);
        }
        return true;
    }
}

