/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www.authentication.handler;

import com.baijia.tianxiao.biz.www.LoginAccountDtoHelper;
import com.baijia.tianxiao.biz.www.Util.InitPageUtils;
import com.baijia.tianxiao.biz.www.Util.LoginAppInfoContext;
import com.baijia.tianxiao.biz.www.Util.PermissionTransformUtil;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.Credential;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.memcached.MemcachedUtil;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TxAccountAuthenticateHandler
extends AbstractAuthenticateHandler {
    private static final Logger log = LoggerFactory.getLogger(TxAccountAuthenticateHandler.class);
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private LoginAccountDtoHelper loginAccountDtoHelper;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private HagService hagService;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;

    @Override
    protected boolean doAuthentication(Credential credential, Map<String, Object> options) throws BussinessException {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByMobile(credential.getMobile());
        if (orgAccount == null) {
            log.info("can not find mobile:{}", (Object)credential.getMobile());
            return false;
        }
        options.put("orgAccount", orgAccount);
        Boolean isTemp = false;
        try {
            String tempPwd = (String)MemcachedUtil.get((String)("uniq_temp_tx_password_" + credential.getMobile()));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tempPwd}) && tempPwd.equals(credential.getPassword())) {
                isTemp = true;
            }
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            log.error("get temp pwd error!mobile:{}", (Object)credential.getMobile(), (Object)e);
        }
        try {
            if (!isTemp.booleanValue() && !PasswordUtil.validatePassword((String)credential.getPassword(), (String)orgAccount.getPassword())) {
                log.info("orgaccount pwd error!");
                return false;
            }
        }
        catch (Exception e) {
            log.info("login pwd:{},hash:{},error!:{}", new Object[]{credential.getPassword(), orgAccount.getPassword(), e});
            return false;
        }
        boolean hasTXPermission = this.hagService.hasPermission((Object)orgAccount.getNumber(), 0, "jigou_tianxiao_orgNumber", new Object[0]);
        if (!hasTXPermission) {
            log.info("right pwd but hag not permission orgNumber:{}", (Object)orgAccount.getNumber());
            return false;
        }
        OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId(), new String[0]);
        if (null == orgSubAccount || orgSubAccount.getStatus().intValue() != OrgSubAccountStatus.NORMAL.getCode().intValue()) {
            log.info("org:{}, can not login because the orgSubAccount is forbidden", (Object)orgSubAccount);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d26\u53f7\u5df2\u505c\u7528");
        }
        TXAccount txAccount = this.txAccountService.getByOrgId(0 != orgSubAccount.getPid() ? orgSubAccount.getPid() : orgAccount.getId(), new String[0]);
        options.put("txAccount", txAccount);
        if (null != orgSubAccount && orgSubAccount.getOnlineType().intValue() == Flag.TRUE.getInt()) {
            log.info("orgSubAccount onlineType is invalide! orgId:{}", (Object)orgAccount.getId());
            return false;
        }
        if (orgSubAccount.getPid() != 0) {
            if (orgSubAccount.getStatus().intValue() != OrgSubAccountStatus.NORMAL.getCode().intValue()) {
                log.info("orgSubAccount status is invalide! orgId:{}", (Object)orgAccount.getId());
                return false;
            }
            txAccount = this.txAccountService.getByOrgId(orgSubAccount.getPid(), new String[0]);
            if (txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode().intValue()) {
                log.info("fenxiaoqu");
                return false;
            }
            options.put("masterFlag", Boolean.FALSE);
        } else {
            Object version = options.get("version");
            if (version != null && !this.loginAccountDtoHelper.validTXVersion(txAccount, options.get("version").toString())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5927\u4f17\u7248\u7528\u6237\u8bf7\u5347\u7ea7\u81f3\u6700\u65b0\u7248\u672c");
            }
            options.put("masterFlag", Boolean.TRUE);
            options.put("fromMasterOrgId", orgAccount.getId());
        }
        options.put("orgSubAccountVersion", orgSubAccount.getAccountVersion());
        return true;
    }

    @Override
    protected boolean postAuthenticate(Credential credential, boolean authenticated, List<TXLoginAccountDto> loginDtos, Map<String, Object> options) throws BussinessException, Exception {
        OrgAccount orgAccount = (OrgAccount)options.get("orgAccount");
        TXAccount txAccount = (TXAccount)options.get("txAccount");
        OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
        TXLoginAccountDto dto = this.loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
        dto.setDataAccountType(0);
        ArrayList roleDtos = Lists.newArrayList();
        RoleDto roleDto = new RoleDto();
        roleDto.setId(orgAccount.getNumber());
        roleDto.setNickName(orgInfo.getContacts());
        roleDto.setName("\u6821\u957f");
        roleDto.setMobile(orgAccount.getMobile());
        roleDtos.add(roleDto);
        String auth_token = null;
        Boolean masterFlag = (Boolean)options.get("masterFlag");
        Integer fromMasterOrgId = (Integer)GenericsUtils.getNullWithoutError(options, (String)"fromMasterOrgId");
        Integer accountVersion = (Integer)options.get("orgSubAccountVersion");
        if (masterFlag.booleanValue()) {
            roleDto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
            auth_token = LoginAppInfoContext.isInitPageLoginUsers() ? EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, (Integer)txAccount.getId(), (Integer)orgAccount.getId(), (Integer)accountVersion, (String)TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId) : EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, (Integer)txAccount.getId(), (Integer)accountVersion, (String)TX_APP_ENVIRONMENT);
        } else {
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            auth_token = LoginAppInfoContext.isInitPageLoginUsers() ? EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, null, (Integer)orgAccount.getId(), (Integer)accountVersion, (String)TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId) : EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, null, (Integer)accountVersion, (String)TX_APP_ENVIRONMENT);
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
        }
        TxAccountPermissionsDto txAccountPermissionDto = this.txAccountPermissionService.universalGetPermissions(orgAccount.getId().intValue(), null);
        roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
        roleDto.setAuth_token(auth_token);
        roleDto.setCreateTime(orgAccount.getCreateTime().getTime());
        roleDto.setRoleAvatar(dto.getAvatar());
        InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShowName());
        dto.setHasRoles(roleDtos);
        loginDtos.add(dto);
        return true;
    }

    public static void main(String[] args) throws Exception {
        String txStrEncode = EncryptUtils.txStrEncode((Integer)123, null, (Integer)1234, (Integer)3974, (Integer)1, (String)"https://fdsf", null);
        System.out.println("token is : " + txStrEncode);
        System.out.println("strDecode is : " + EncryptUtils.strDecode((String)txStrEncode));
    }
}

