/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www.impl;

import com.baijia.tianxiao.biz.www.LoginAccountDtoHelper;
import com.baijia.tianxiao.biz.www.OrgInitPageService;
import com.baijia.tianxiao.biz.www.Util.InitPageUtils;
import com.baijia.tianxiao.biz.www.Util.PermissionTransformUtil;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.biz.www.authentication.handler.TxVisitorAuthenticateHandler;
import com.baijia.tianxiao.biz.www.constant.ExpTxPermission;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.index.dao.TxVisitorDao;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.pcAuthority.dao.TXPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.hag.HagDownload;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionHasType;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgInitPageServiceImpl
implements OrgInitPageService {
    private static final Logger log = LoggerFactory.getLogger(OrgInitPageServiceImpl.class);
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private LoginAccountDtoHelper loginAccountDtoHelper;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired(required=false)
    private HagService hagService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private TXPermissionDao txPermissionDao;
    @Autowired
    private OrgPhotoDao orgPhotoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TxVisitorDao txVisitorDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TXAccount saveStartUpPageInfo(Integer orgId, String initOrgName, String orgSlogan, String orgLogo, Long storageId) {
        try {
            TXAccount saveOrUpdateStartUpPageInfo = this.txAccountDao.saveOrUpdateStartUpPageInfo(orgId, initOrgName, orgSlogan, orgLogo);
            this.updateMasterAccountPhotoAndOrgName(orgId, initOrgName, orgLogo, storageId);
            return saveOrUpdateStartUpPageInfo;
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)"can not saveOrUpdateStartUpPageInfo with orgId :{} initOrgName:{} orgSlogan :{} orgLogo :{} ", (Object[])new Object[]{orgId, initOrgName, orgSlogan, orgLogo});
            return null;
        }
    }

    private void updateMasterAccountPhotoAndOrgName(Integer orgId, String initOrgName, String orgLogo, Long storageId) {
        List photos;
        if (storageId == null) {
            return;
        }
        OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(orgId);
        if (orgInfo != null) {
            orgInfo.setShortName(initOrgName);
            this.orgInfoDao.update((Object)orgInfo, new String[]{"shortName"});
        }
        if ((photos = this.orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), 1)) != null && photos.size() > 0) {
            OrgPhoto photo = (OrgPhoto)photos.get(0);
            photo.setOrgStorageId(Integer.valueOf(storageId.intValue()));
            photo.setUpdateTime(new Date());
            this.orgPhotoDao.update((Object)photo, Boolean.valueOf(false), new String[0]);
        } else {
            OrgPhoto orgPhoto = new OrgPhoto();
            orgPhoto.setOrgId(Integer.valueOf(orgId));
            orgPhoto.setOrgStorageId(Integer.valueOf(storageId.intValue()));
            orgPhoto.setAuditstatus(AuditStatus.PASS.getValue());
            orgPhoto.setCategory(OrgImgType.ORG_LOGO.getValue());
            orgPhoto.setGroupId(Integer.valueOf(OrgImgType.ORG_LOGO.getGroupId()));
            orgPhoto.setCreateTime(new Date());
            orgPhoto.setUpdateTime(new Date());
            orgPhoto.setIsdel(DataStatus.NORMAL.getValue());
            this.orgPhotoDao.save((Object)orgPhoto, new String[0]);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void hasSetUpInitPage(Integer orgId) {
        this.txAccountDao.findAndUpdateInfoFillStatus(orgId);
    }

    @Override
    public List<TXLoginAccountDto> listAllCampusRoles(Integer orgId, Integer fromOrgId, Integer txVisitorId, Integer fromMasterOrgId, Integer cascadeId) {
        boolean isFromMasterLogin;
        ArrayList retDtos = Lists.newArrayList();
        TXLoginAccountDto txVisitorLoginData = null;
        boolean isTxVisitor = false;
        orgId = this.checkoutJustFromSlaveOrg(orgId, fromOrgId, cascadeId);
        boolean bl = isFromMasterLogin = fromMasterOrgId != null && orgId.intValue() == fromMasterOrgId.intValue();
        if (txVisitorId != null) {
            try {
                TxVisitor txVisitor = (TxVisitor)this.txVisitorDao.getById((Serializable)txVisitorId, new String[0]);
                txVisitorLoginData = this.createTxVisitorLoginData(txVisitor, txVisitor.getMobile(), fromMasterOrgId);
                log.info("txVisitorLoginData is :{} ", (Object)txVisitorLoginData);
            }
            catch (BussinessException ex) {
                GenericsUtils.logErrorAndInfo((Logger)log, (Exception)((Object)ex), (String)"can not find txVisitorLoginData with tXCascadeCredential cause by BussinessException :{} ", (Object[])new Object[]{txVisitorId});
                throw ex;
            }
            catch (Exception e) {
                log.info("can not find txVisitorLoginData with tXCascadeCredential :{} ", (Throwable)e);
                log.info("txVisitId:{} ", (Object)txVisitorId);
            }
            if (txVisitorLoginData != null) {
                retDtos.add(txVisitorLoginData);
                isTxVisitor = true;
            }
        }
        if (!isTxVisitor || isTxVisitor && fromOrgId != null) {
            TXCascadeAccount tXCascadeAccountById;
            String mobile = "";
            String encryptionPassword = "";
            TXAccount txAccount = null;
            boolean isMaster = false;
            Integer version = 0;
            boolean canLogMasterAccount = true;
            OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgId(orgId, new String[0]);
            TXCascadeCredential tXCascadeCredential = null;
            version = orgSubAccount.getAccountVersion();
            OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
            if (orgAccount != null) {
                encryptionPassword = orgAccount.getPassword();
                mobile = orgAccount.getMobile();
                tXCascadeCredential = this.txCascadeCredentialDao.getByMobile(mobile);
            }
            if ((txAccount = this.txAccountDao.getByOrgId(orgId, TXAccountStatus.VALID.getCode(), new String[0])) == null) {
                txAccount = this.txAccountDao.getByOrgId(orgSubAccount.getPid(), TXAccountStatus.VALID.getCode(), new String[0]);
            } else if (cascadeId == null) {
                isMaster = true;
            }
            if (cascadeId != null && (tXCascadeAccountById = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0])) != null) {
                tXCascadeCredential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)tXCascadeAccountById.getCredentialId(), new String[0]);
                mobile = tXCascadeCredential.getMobile();
                if (!encryptionPassword.equals(tXCascadeCredential.getPassword())) {
                    canLogMasterAccount = false;
                }
                encryptionPassword = tXCascadeCredential.getPassword();
            }
            log.info("with mobile :{} and encryptionPassword :{} isCanLoginMasterAccount ", new Object[]{mobile, encryptionPassword, canLogMasterAccount});
            TXLoginAccountDto orgAccountLoginData = null;
            try {
                if (canLogMasterAccount) {
                    orgAccountLoginData = this.createOrgAccountLoginData(fromOrgId, orgAccount, txAccount, isMaster, version, fromMasterOrgId);
                } else {
                    log.info("try to match other master account with mobile :{} ", (Object)mobile);
                    orgAccountLoginData = this.createOrgAccountLoginData(mobile, fromMasterOrgId, fromOrgId, encryptionPassword);
                }
                log.info("orgAccountLoginData is :{} ", (Object)orgAccountLoginData);
            }
            catch (Exception e1) {
                log.info("can not find orgAccountLoginData with orgAccount :{} ", (Throwable)e1);
                log.info("orgAccount is :{} ", (Object)orgAccount);
            }
            List<TXLoginAccountDto> cascadeAccounts = GenericsUtils.emptyList();
            try {
                cascadeAccounts = this.createCascadeAccountLoginData(fromOrgId, tXCascadeCredential, fromMasterOrgId);
                log.info("cascadeAccounts is :{} ", cascadeAccounts);
            }
            catch (Exception e) {
                log.info("can not find cascadeAccounts with tXCascadeCredential :{} ", (Throwable)e);
                log.info("tXCascadeCredential is:{} ", (Object)tXCascadeCredential);
            }
            if (orgAccountLoginData != null) {
                retDtos.add(orgAccountLoginData);
            }
            retDtos.addAll(cascadeAccounts);
        }
        if (fromMasterOrgId != null) {
            OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)fromMasterOrgId, new String[0]);
            this.loginAccountDtoHelper.addSpecialLoginLogicForMasterAccount(retDtos, orgAccount, fromOrgId, isFromMasterLogin);
        }
        return this.loginAccountDtoHelper.transformLoginDtos(retDtos);
    }

    private Integer checkoutJustFromSlaveOrg(Integer orgId, Integer fromOrgId, Integer cascadeId) {
        List byIds;
        Integer orgIdRet = orgId;
        if (orgId != null && fromOrgId != null && orgId.intValue() != fromOrgId.intValue() && cascadeId == null && GenericsUtils.notNullAndEmpty((Object)(byIds = this.orgAccountDao.getByIds(Arrays.asList(orgId, fromOrgId), new String[0])))) {
            String fromOrgMobile;
            String currentOrgMobile = ((OrgAccount)byIds.get(0)).getMobile();
            orgIdRet = currentOrgMobile.equals(fromOrgMobile = ((OrgAccount)byIds.get(1)).getMobile()) ? orgId : fromOrgId;
        }
        return orgIdRet;
    }

    private TXLoginAccountDto createOrgAccountLoginData(String mobile, Integer fromMasterOrgId, Integer fromOrgId, String encryptionPassword) throws Exception {
        boolean isFromMasterChoose;
        if (GenericsUtils.isNullOrEmpty((Object)mobile)) {
            throw new IllegalArgumentException(GenericsUtils.formatOutput((String)"can not find txLoginAccountDto with mobile :{} ", (Object[])new Object[]{mobile}));
        }
        boolean isMaster = false;
        OrgAccount orgAccount = this.orgAccountDao.getAccountByMobile(mobile);
        if (orgAccount == null) {
            throw new IllegalArgumentException(GenericsUtils.formatOutput((String)"can not find orgAccount with mobile :{} ", (Object[])new Object[]{mobile}));
        }
        boolean bl = isFromMasterChoose = fromOrgId != null && fromOrgId.equals(orgAccount.getId());
        if (isFromMasterChoose || orgAccount.getPassword().equals(encryptionPassword)) {
            TXAccount txAccount = this.txAccountDao.getByOrgId(orgAccount.getId(), TXAccountStatus.VALID.getCode(), new String[0]);
            OrgSubAccount osa = this.orgSubAccountService.getByOrgId(orgAccount.getId(), new String[0]);
            if (osa == null) {
                throw new IllegalArgumentException(GenericsUtils.formatOutput((String)"can not find OrgSubAccount with mobile :{} ", (Object[])new Object[]{orgAccount.getId()}));
            }
            if (txAccount == null) {
                txAccount = this.txAccountDao.getByOrgId(osa.getPid(), TXAccountStatus.VALID.getCode(), new String[0]);
            } else {
                isMaster = true;
            }
            Integer version = osa.getAccountVersion();
            return this.createOrgAccountLoginData(fromOrgId, orgAccount, txAccount, isMaster, version, fromMasterOrgId);
        }
        throw new IllegalArgumentException(GenericsUtils.formatOutput((String)"can not find orgAccount with mobile :{} and encryptionPassword:{} ", (Object[])new Object[]{mobile, encryptionPassword}));
    }

    private TXLoginAccountDto createTxVisitorLoginData(TxVisitor txVisitor, String mobile, Integer fromMasterOrgId) throws Exception {
        if (GenericsUtils.isNullOrEmpty((Object)txVisitor)) {
            return null;
        }
        HashMap params = Maps.newHashMap();
        params.put("resource", "tianxiao_trial_account");
        String url = PropertiesReader.getValue((String)"hag", (String)"hag.http.url.downloadList");
        String response = HttpClientUtils.doPost((String)url, (Map)params);
        HagDownload hagDto = (HagDownload)JacksonUtil.str2Obj((String)response, HagDownload.class);
        log.info("hagDto:{}", (Object)hagDto);
        if (hagDto == null || CollectionUtils.isEmpty((Collection)hagDto.getData())) {
            return null;
        }
        String numberStr = ((String)hagDto.getData().get(0)).split("#")[0];
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(Integer.valueOf(numberStr));
        if (orgAccount == null) {
            return null;
        }
        if (txVisitor.getStartTime() == null) {
            throw new IllegalArgumentException(GenericsUtils.formatOutput((String)"txVisitor is expired :{} ", (Object[])new Object[]{txVisitor}));
        }
        if (Days.daysBetween((ReadableInstant)new DateTime(txVisitor.getStartTime().getTime()), (ReadableInstant)DateTime.now()).isGreaterThan(Days.days((int)txVisitor.getRemainDay()))) {
            throw new IllegalArgumentException(GenericsUtils.formatOutput((String)"txVisitor is expired :{} ", (Object[])new Object[]{txVisitor}));
        }
        OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
        TXLoginAccountDto txLoginAccountDto = this.loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
        txLoginAccountDto.setDataAccountType(1);
        ArrayList roleDtos = Lists.newArrayList();
        RoleDto roleDto = new RoleDto();
        roleDto.setNickName(orgInfo.getShortName());
        roleDto.setName(mobile);
        roleDto.setMobile(mobile);
        roleDto.setType(1);
        roleDto.setId(orgAccount.getNumber());
        roleDto.setCreateTime(orgAccount.getCreateTime().getTime());
        TXAccount txAccount = this.txAccountService.getByOrgId(orgAccount.getId(), new String[0]);
        if (txAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.INVALIDATE_CLIENTID, "\u4e3b\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u5df2\u6682\u505c\u4f7f\u7528");
        }
        String auth_token = EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, (Integer)txAccount.getId(), null, (Integer)txVisitor.getId(), null, (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId);
        roleDto.setAuth_token(auth_token);
        ArrayList permissions = Lists.newArrayList();
        for (ExpTxPermission tp : TxVisitorAuthenticateHandler.FORBID_PERMISSIONS) {
            PermissionDto pd = new PermissionDto();
            pd.setName(tp.getLabel());
            pd.setTag(ExpTxPermission.getCompleteValue(tp));
            pd.setType(Integer.valueOf(TXPermissionHasType.LOST.getCode()));
            permissions.add(pd);
        }
        List txPermissionsInDB = this.txPermissionDao.getAll(new String[0]);
        for (TXPermission txPermission : txPermissionsInDB) {
            PermissionDto pd = new PermissionDto();
            pd.setName(txPermission.getName());
            pd.setTag(txPermission.getCode().toString());
            pd.setType(Integer.valueOf(TXPermissionHasType.OWN.getCode()));
            permissions.add(pd);
        }
        roleDto.setHasPermissions(permissions);
        roleDtos.add(roleDto);
        txLoginAccountDto.setHasRoles(roleDtos);
        InitPageUtils.fillInitPageInfos(txAccount, txLoginAccountDto, orgInfo.getShortName());
        return txLoginAccountDto;
    }

    private List<TXLoginAccountDto> createCascadeAccountLoginData(Integer fromOrgId, TXCascadeCredential txCascadeCredential, Integer fromMasterOrgId) throws Exception {
        ArrayList loginDtos = Lists.newArrayList();
        List txCascadeAccounts = this.txCascadeAccountDao.getValidAccountsByCredentialId(txCascadeCredential.getId());
        if (CollectionUtils.isEmpty((Collection)txCascadeAccounts)) {
            return Lists.newArrayList();
        }
        HashMap existDto = Maps.newHashMap();
        log.info("txCascadeAccounts:{}", (Object)txCascadeAccounts);
        for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
            OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(txCascadeAccount.getOrgId());
            log.info("for orgAccount :{} , fromOrgId is:{} ", (Object)orgAccount, (Object)fromOrgId);
            boolean hasTXPermission = this.hagService.hasPermission((Object)orgAccount.getNumber(), 0, "jigou_tianxiao_orgNumber", new Object[0]);
            if (!hasTXPermission) {
                log.info("no hag txCascadeAccount:{}", (Object)txCascadeAccount);
                continue;
            }
            OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId(), new String[0]);
            if (null == orgSubAccount || orgSubAccount.getStatus().intValue() != OrgSubAccountStatus.NORMAL.getCode().intValue()) {
                log.info("cascade:{}, can not login because the orgSubAccount is forbidden", (Object)txCascadeAccount);
                continue;
            }
            if (null != orgSubAccount && orgSubAccount.getOnlineType().intValue() == Flag.TRUE.getInt()) {
                log.info("cascade orgSubAccount onlineType invalid:{}", (Object)orgSubAccount);
                continue;
            }
            TXAccount txAccount = this.txAccountService.getByOrgId(orgSubAccount.getPid() > 0 ? orgSubAccount.getPid() : orgSubAccount.getOrgId(), new String[0]);
            String auth_token = null;
            if (txAccount == null) {
                log.info("this cascade:{} can not find txAccount, maybe txAccount is forbidden", (Object)txCascadeAccount);
                continue;
            }
            if (txAccount.getVipLevel() == TXAccountType.DAZHONG.getCode()) {
                log.info("cascade txAccount invalid111:{}", (Object)txAccount);
                continue;
            }
            auth_token = orgSubAccount.getPid() == 0 && txCascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue() ? EncryptUtils.txStrEncode((Integer)orgAccount.getId(), (Integer)txCascadeAccount.getId(), (Integer)txAccount.getId(), (Integer)fromOrgId, (Integer)txCascadeAccount.getAccountVersion(), (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId) : EncryptUtils.txStrEncode((Integer)orgAccount.getId(), (Integer)txCascadeAccount.getId(), null, (Integer)fromOrgId, (Integer)txCascadeAccount.getAccountVersion(), (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId);
            OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
            TXLoginAccountDto dto = null;
            if (existDto.containsKey(orgAccount.getId())) {
                dto = (TXLoginAccountDto)existDto.get(orgAccount.getId());
            } else {
                dto = this.loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
                ArrayList roleDtos = Lists.newArrayList();
                dto.setHasRoles(roleDtos);
                existDto.put(orgAccount.getId(), dto);
                loginDtos.add(dto);
            }
            dto.setDataAccountType(0);
            RoleDto roleDto = new RoleDto();
            roleDto.setId(txCascadeAccount.getId());
            roleDto.setNickName(txCascadeCredential.getName());
            roleDto.setType(txCascadeAccount.getAccountType());
            roleDto.setAuth_token(auth_token);
            roleDto.setMobile(txCascadeCredential.getMobile());
            roleDto.setCreateTime(txCascadeAccount.getCreateTime().getTime());
            InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShowName());
            TxAccountPermissionsDto txAccountPermissionDto = this.txAccountPermissionService.universalGetPermissions(orgAccount.getId().intValue(), txCascadeAccount.getId());
            roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
            if (StringUtils.isNotBlank((CharSequence)txCascadeCredential.getAvatar())) {
                roleDto.setRoleAvatar(txCascadeCredential.getAvatar());
            } else {
                roleDto.setRoleAvatar("https://imgs.genshuixue.com/21644918_xqjeiipb.png");
            }
            dto.getHasRoles().add(roleDto);
            InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShortName());
        }
        return loginDtos;
    }

    private TXLoginAccountDto createOrgAccountLoginData(Integer fromOrgId, OrgAccount orgAccount, TXAccount txAccount, boolean isMaster, Integer version, Integer fromMasterOrgId) throws Exception {
        OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
        TXLoginAccountDto dto = this.loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
        dto.setDataAccountType(0);
        ArrayList roleDtos = Lists.newArrayList();
        RoleDto roleDto = new RoleDto();
        roleDto.setId(orgAccount.getNumber());
        roleDto.setNickName(orgInfo.getContacts());
        roleDto.setCreateTime(orgAccount.getCreateTime().getTime());
        roleDto.setName("\u6821\u957f");
        roleDto.setMobile(orgAccount.getMobile());
        roleDtos.add(roleDto);
        String auth_token = null;
        if (isMaster) {
            roleDto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
            auth_token = EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, (Integer)txAccount.getId(), (Integer)fromOrgId, (Integer)version, (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId);
        } else {
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            auth_token = EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, null, (Integer)fromOrgId, (Integer)version, (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId);
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
        }
        TxAccountPermissionsDto txAccountPermissionDto = this.txAccountPermissionService.universalGetPermissions(orgAccount.getId().intValue(), null);
        roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
        roleDto.setAuth_token(auth_token);
        roleDto.setRoleAvatar(dto.getAvatar());
        InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShortName());
        dto.setHasRoles(roleDtos);
        return dto;
    }
}

