/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www.impl;

import com.baijia.tianxiao.biz.www.IllegalAccessCtrlService;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.util.WebResponseHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class IllegalAccessCtrlServiceImpl
implements IllegalAccessCtrlService {
    private static final int INVALID_ACCESS_LIMIT = 20;
    private static final long INCRBY_OFFSET = 1L;
    private static final long ACCOUNT_LOCKED_TIME = 3600L;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public WebResponse<Object> detect(final String key, final long offset, long expire) {
        final RedisSerializer<String> serializer = this.getRedisSerializer();
        return (WebResponse)this.redisTemplate.execute((RedisCallback)new RedisCallback<WebResponse<Object>>(){

            public WebResponse<Object> doInRedis(RedisConnection connection) throws DataAccessException {
                Long currTime = System.currentTimeMillis();
                byte[] time = serializer.serialize((Object)currTime.toString());
                byte[] keyByte = serializer.serialize((Object)key);
                if (connection.exists(key.getBytes()).booleanValue()) {
                    if (this.isAccountLocked(connection, keyByte, "locked".getBytes())) {
                        return WebResponseHelper.error((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef,\u8d26\u6237\u5c06\u88ab\u9501\u5b9a\u4e00\u5c0f\u65f6");
                    }
                    long invalidCount = this.hincrBy(connection, keyByte, "count".getBytes(), offset);
                    if (invalidCount >= 20L) {
                        connection.hSet(keyByte, "etime".getBytes(), time);
                        connection.hSet(keyByte, "locked".getBytes(), "true".getBytes());
                        return WebResponseHelper.error((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, (String)"\u60a8\u7684\u8d26\u6237\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf71\u5c0f\u65f6\u540e\u518d\u8bd5");
                    }
                    if (invalidCount >= 17L) {
                        connection.hSet(keyByte, "etime".getBytes(), time);
                        return WebResponseHelper.error((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, (String)("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u53ef\u8f93\u5165" + (20L - invalidCount) + "\u6b21"));
                    }
                    return WebResponseHelper.error((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                }
                connection.hSet(keyByte, "stime".getBytes(), time);
                connection.hSet(keyByte, "etime".getBytes(), time);
                connection.hSet(keyByte, "locked".getBytes(), "false".getBytes());
                this.hincrBy(connection, keyByte, "count".getBytes(), offset);
                connection.expire(keyByte, 3600L);
                return WebResponseHelper.error((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }

            boolean isAccountLocked(RedisConnection connection, byte[] key2, byte[] filed) {
                byte[] locked = connection.hGet(key2, filed);
                if (locked != null) {
                    return Boolean.parseBoolean((String)serializer.deserialize(locked));
                }
                return false;
            }

            long hincrBy(RedisConnection connection, byte[] key2, byte[] filed, long offset2) {
                return connection.hIncrBy(key2, filed, offset2);
            }
        });
    }

    @Override
    public WebResponse<Object> detect(String key) {
        return this.detect(key, 1L, 3600L);
    }

    @Override
    public WebResponse<Object> detectChangePwd(String key) {
        return this.detectChangePwd(key, 1L, 3600L);
    }

    @Override
    public WebResponse<Object> detectChangePwd(final String key, final long offset, long expire) {
        final RedisSerializer<String> serializer = this.getRedisSerializer();
        return (WebResponse)this.redisTemplate.execute((RedisCallback)new RedisCallback<WebResponse<Object>>(){

            public WebResponse<Object> doInRedis(RedisConnection connection) throws DataAccessException {
                Long currTime = System.currentTimeMillis();
                byte[] time = serializer.serialize((Object)currTime.toString());
                byte[] keyByte = serializer.serialize((Object)key);
                if (connection.exists(key.getBytes()).booleanValue()) {
                    if (this.isAccountLocked(connection, keyByte, "locked".getBytes())) {
                        return WebResponseHelper.error((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, (String)"\u9a8c\u8bc1\u7801\u586b\u5199\u9519\u8bef,\u8d26\u6237\u5c06\u88ab\u9501\u5b9a\u4e00\u5c0f\u65f6");
                    }
                    long invalidCount = this.hincrBy(connection, keyByte, "count".getBytes(), offset);
                    if (invalidCount >= 20L) {
                        connection.hSet(keyByte, "etime".getBytes(), time);
                        connection.hSet(keyByte, "locked".getBytes(), "true".getBytes());
                        return WebResponseHelper.error((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, (String)"\u60a8\u7684\u8d26\u6237\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf71\u5c0f\u65f6\u540e\u518d\u8bd5");
                    }
                    if (invalidCount >= 17L) {
                        connection.hSet(keyByte, "etime".getBytes(), time);
                        return WebResponseHelper.error((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, (String)("\u9a8c\u8bc1\u7801\u586b\u5199\u9519\u8bef\uff0c\u8fd8\u53ef\u8f93\u5165" + (20L - invalidCount) + "\u6b21"));
                    }
                    return WebResponseHelper.error((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, (String)"\u9a8c\u8bc1\u7801\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                }
                connection.hSet(keyByte, "stime".getBytes(), time);
                connection.hSet(keyByte, "etime".getBytes(), time);
                connection.hSet(keyByte, "locked".getBytes(), "false".getBytes());
                this.hincrBy(connection, keyByte, "count".getBytes(), offset);
                connection.expire(keyByte, 3600L);
                return WebResponseHelper.error((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, (String)"\u9a8c\u8bc1\u7801\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }

            boolean isAccountLocked(RedisConnection connection, byte[] key2, byte[] filed) {
                byte[] locked = connection.hGet(key2, filed);
                if (locked != null) {
                    return Boolean.parseBoolean((String)serializer.deserialize(locked));
                }
                return false;
            }

            long hincrBy(RedisConnection connection, byte[] key2, byte[] filed, long offset2) {
                return connection.hIncrBy(key2, filed, offset2);
            }
        });
    }

    protected RedisSerializer<String> getRedisSerializer() {
        return this.redisTemplate.getStringSerializer();
    }

    @Override
    public boolean isLocked(final String key) {
        final RedisSerializer<String> serializer = this.getRedisSerializer();
        return (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] locked = connection.hGet(serializer.serialize((Object)key), "locked".getBytes());
                if (locked != null) {
                    return Boolean.parseBoolean((String)serializer.deserialize(locked));
                }
                return false;
            }
        });
    }
}

