
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.www.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.constant.Flag;
import com.google.common.collect.Lists;
import com.baijia.tianxiao.enums.CommonErrorCode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.biz.www.LoginAccountDtoHelper;
import com.baijia.tianxiao.biz.www.OrgInitPageService;
import com.baijia.tianxiao.biz.www.Util.InitPageUtils;
import com.baijia.tianxiao.biz.www.Util.PermissionTransformUtil;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.biz.www.authentication.handler.TxVisitorAuthenticateHandler;
import com.baijia.tianxiao.biz.www.constant.BizConstant;
import com.baijia.tianxiao.biz.www.constant.ExpTxPermission;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.index.dao.TxVisitorDao;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.pcAuthority.dao.TXPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dto.hag.HagDownload;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionHasType;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Jan 19, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Service
@Slf4j
public class OrgInitPageServiceImpl implements OrgInitPageService {

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private LoginAccountDtoHelper loginAccountDtoHelper;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired(required = false)
    private HagService hagService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private TXPermissionDao txPermissionDao;
    @Autowired
    private OrgPhotoDao orgPhotoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TxVisitorDao txVisitorDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TXAccount saveStartUpPageInfo(Integer orgId, String initOrgName, String orgSlogan, String orgLogo,
        Long storageId) {
        try {
            TXAccount saveOrUpdateStartUpPageInfo =
                this.txAccountDao.saveOrUpdateStartUpPageInfo(orgId, initOrgName, orgSlogan, orgLogo);
            updateMasterAccountPhotoAndOrgName(orgId, initOrgName, orgLogo, storageId);
            return saveOrUpdateStartUpPageInfo;
        } catch (Exception e) {
            GenericsUtils.logErrorAndInfo(log, e,
                "can not saveOrUpdateStartUpPageInfo with orgId :{} initOrgName:{} orgSlogan :{} orgLogo :{} ", orgId,
                initOrgName, orgSlogan, orgLogo);
            return null;
        }
    }

    /**
     * @param orgId
     * @param orgLogo
     * @param orgLogo
     * @param storageId
     */
    private void updateMasterAccountPhotoAndOrgName(Integer orgId, String initOrgName, String orgLogo, Long storageId) {
        if (storageId == null) {
            return;
        }
        OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(orgId);
        if (orgInfo != null) {
            orgInfo.setShortName(initOrgName);
            this.orgInfoDao.update(orgInfo, "shortName");
        }
        // 校长更新logo
        List<OrgPhoto> photos = orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), 1);
        if (photos != null && photos.size() > 0) {
            OrgPhoto photo = photos.get(0);
            photo.setOrgStorageId(storageId.intValue());
            photo.setUpdateTime(new Date());
            orgPhotoDao.update(photo, false);
        } else {
            OrgPhoto orgPhoto = new OrgPhoto();
            orgPhoto.setOrgId(orgId.intValue());
            orgPhoto.setOrgStorageId(storageId.intValue());
            orgPhoto.setAuditstatus(AuditStatus.PASS.getValue());
            orgPhoto.setCategory(OrgImgType.ORG_LOGO.getValue());
            orgPhoto.setGroupId(OrgImgType.ORG_LOGO.getGroupId());
            orgPhoto.setCreateTime(new Date());
            orgPhoto.setUpdateTime(new Date());
            orgPhoto.setIsdel(DataStatus.NORMAL.getValue());
            orgPhotoDao.save(orgPhoto);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void hasSetUpInitPage(Integer orgId) {
        this.txAccountDao.findAndUpdateInfoFillStatus(orgId);
    }

    /**
     * 根据登录信息auth_token中提取到的orgId和cascadeId来获取到
     */
    @Override
    public List<TXLoginAccountDto> listAllCampusRoles(Integer orgId, Integer fromOrgId, Integer txVisitorId,
        Integer fromMasterOrgId, Integer cascadeId) {

        List<TXLoginAccountDto> retDtos = Lists.newArrayList();
        TXLoginAccountDto txVisitorLoginData = null;
        boolean isTxVisitor = false;
        orgId = checkoutJustFromSlaveOrg(orgId, fromOrgId, cascadeId);
        boolean isFromMasterLogin = (fromMasterOrgId != null && orgId.intValue() == fromMasterOrgId.intValue());
        if (txVisitorId != null) {
            try {
                TxVisitor txVisitor = txVisitorDao.getById(txVisitorId);
                txVisitorLoginData = createTxVisitorLoginData(txVisitor, txVisitor.getMobile(), fromMasterOrgId);
                log.info("txVisitorLoginData is :{} ", txVisitorLoginData);
            } catch (BussinessException ex) {
                GenericsUtils.logErrorAndInfo(log, ex,
                    "can not find txVisitorLoginData with tXCascadeCredential cause by BussinessException :{} ",
                    txVisitorId);
                throw ex;
            } catch (Exception e) {
                log.info("can not find txVisitorLoginData with tXCascadeCredential :{} ", e);
                log.info("txVisitId:{} ", txVisitorId);
            }
            if (txVisitorLoginData != null) {
                retDtos.add(txVisitorLoginData);
                isTxVisitor = true;
            }
        }

        if (!isTxVisitor || (isTxVisitor && fromOrgId != null)) {
            String mobile = "";
            String encryptionPassword = "";
            TXAccount txAccount = null;
            boolean isMaster = false;
            Integer version = 0;
            boolean canLogMasterAccount = true;

            OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgId);
            TXCascadeCredential tXCascadeCredential = null;
            version = orgSubAccount.getAccountVersion();
            OrgAccount orgAccount = orgAccountDao.getById(orgId);
            if (orgAccount != null) {
                encryptionPassword = orgAccount.getPassword();
                mobile = orgAccount.getMobile();
                tXCascadeCredential = this.txCascadeCredentialDao.getByMobile(mobile);
            }
            txAccount = this.txAccountDao.getByOrgId(orgId, TXAccountStatus.VALID.getCode());
            if (txAccount == null) {
                txAccount = this.txAccountDao.getByOrgId(orgSubAccount.getPid(), TXAccountStatus.VALID.getCode());
            } else if (cascadeId == null) {
                isMaster = true;
            }
            if (cascadeId != null) {
                TXCascadeAccount tXCascadeAccountById = this.txCascadeAccountDao.getById(cascadeId);
                if (tXCascadeAccountById != null) {
                    tXCascadeCredential = txCascadeCredentialDao.getById(tXCascadeAccountById.getCredentialId());
                    mobile = tXCascadeCredential.getMobile();
                    if (!encryptionPassword.equals(tXCascadeCredential.getPassword())) {
                        canLogMasterAccount = false;
                    }
                    encryptionPassword = tXCascadeCredential.getPassword();
                }
            }

            log.info("with mobile :{} and encryptionPassword :{} isCanLoginMasterAccount ", mobile, encryptionPassword,
                canLogMasterAccount);

            TXLoginAccountDto orgAccountLoginData = null;

            try {
                if (canLogMasterAccount) {
                    orgAccountLoginData =
                        createOrgAccountLoginData(fromOrgId, orgAccount, txAccount, isMaster, version, fromMasterOrgId);
                } else {
                    // try to match other master account
                    log.info("try to match other master account with mobile :{} ", mobile);
                    orgAccountLoginData =
                        createOrgAccountLoginData(mobile, fromMasterOrgId, fromOrgId, encryptionPassword);
                }
                log.info("orgAccountLoginData is :{} ", orgAccountLoginData);
            } catch (Exception e1) {
                log.info("can not find orgAccountLoginData with orgAccount :{} ", e1);
                log.info("orgAccount is :{} ", orgAccount);
            }

            List<TXLoginAccountDto> cascadeAccounts = GenericsUtils.emptyList();
            try {
                cascadeAccounts = createCascadeAccountLoginData(fromOrgId, tXCascadeCredential, fromMasterOrgId);
                log.info("cascadeAccounts is :{} ", cascadeAccounts);
            } catch (Exception e) {
                log.info("can not find cascadeAccounts with tXCascadeCredential :{} ", e);
                log.info("tXCascadeCredential is:{} ", tXCascadeCredential);
            }

            if (orgAccountLoginData != null) {
                retDtos.add(orgAccountLoginData);
            }
            retDtos.addAll(cascadeAccounts);
        }

        if (fromMasterOrgId != null) {
            OrgAccount orgAccount = this.orgAccountDao.getById(fromMasterOrgId);
            this.loginAccountDtoHelper.addSpecialLoginLogicForMasterAccount(retDtos, orgAccount, fromOrgId,
                isFromMasterLogin);
        }

        return this.loginAccountDtoHelper.transformLoginDtos(retDtos);
    }

    /**
     * @param orgId
     * @param fromOrgId
     * @param cascadeId
     * @return
     */
    private Integer checkoutJustFromSlaveOrg(Integer orgId, Integer fromOrgId, Integer cascadeId) {
        Integer orgIdRet = orgId;
        if (orgId != null && fromOrgId != null && orgId.intValue() != fromOrgId.intValue() && cascadeId == null) {
            List<OrgAccount> byIds = this.orgAccountDao.getByIds(Arrays.asList(orgId, fromOrgId));
            if (GenericsUtils.notNullAndEmpty(byIds)) {
                String currentOrgMobile = byIds.get(0).getMobile();
                String fromOrgMobile = byIds.get(1).getMobile();
                orgIdRet = (currentOrgMobile.equals(fromOrgMobile) ? orgId : fromOrgId);
            }
        }
        return orgIdRet;
    }

    /**
     * @param mobile
     * @param fromOrgId
     * @return
     * @throws Exception
     */
    private TXLoginAccountDto createOrgAccountLoginData(String mobile, Integer fromMasterOrgId, Integer fromOrgId,
        String encryptionPassword) throws Exception {
        if (GenericsUtils.isNullOrEmpty(mobile)) {
            throw new IllegalArgumentException(
                GenericsUtils.formatOutput("can not find txLoginAccountDto with mobile :{} ", mobile));
        }
        boolean isMaster = false;
        OrgAccount orgAccount = this.orgAccountDao.getAccountByMobile(mobile);
        if (orgAccount == null) {
            throw new IllegalArgumentException(
                GenericsUtils.formatOutput("can not find orgAccount with mobile :{} ", mobile));
        }
        boolean isFromMasterChoose = (fromOrgId != null && fromOrgId.equals(orgAccount.getId()));
        if (isFromMasterChoose || orgAccount.getPassword().equals(encryptionPassword)) {
            TXAccount txAccount = this.txAccountDao.getByOrgId(orgAccount.getId(), TXAccountStatus.VALID.getCode());
            OrgSubAccount osa = this.orgSubAccountService.getByOrgId(orgAccount.getId());
            if (osa == null) {
                throw new IllegalArgumentException(
                    GenericsUtils.formatOutput("can not find OrgSubAccount with mobile :{} ", orgAccount.getId()));
            }
            if (txAccount == null) {
                txAccount = this.txAccountDao.getByOrgId(osa.getPid(), TXAccountStatus.VALID.getCode());
            } else {
                isMaster = true;
            }
            Integer version = osa.getAccountVersion();
            return createOrgAccountLoginData(fromOrgId, orgAccount, txAccount, isMaster, version, fromMasterOrgId);
        } else {
            throw new IllegalArgumentException(GenericsUtils.formatOutput(
                "can not find orgAccount with mobile :{} and encryptionPassword:{} ", mobile, encryptionPassword));
        }
    }

    /**
     * @return
     * @throws Exception
     */

    private TXLoginAccountDto createTxVisitorLoginData(TxVisitor txVisitor, String mobile, Integer fromMasterOrgId)
        throws Exception {
        if (GenericsUtils.isNullOrEmpty(txVisitor)) {
            return null;
        }

        Map<String, String> params = Maps.newHashMap();
        params.put("resource", BizConf.HAG_RESOURSE_TIANXIAO_TRIAL_ACCOUNT);
        String url = PropertiesReader.getValue("hag", "hag.http.url.downloadList");
        String response = HttpClientUtils.doPost(url, params);
        HagDownload hagDto = JacksonUtil.str2Obj(response, HagDownload.class);
        log.info("hagDto:{}", hagDto);
        if (hagDto == null || CollectionUtils.isEmpty(hagDto.getData())) {
            return null;
        }
        String numberStr = hagDto.getData().get(0).split("#")[0];

        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(Integer.valueOf(numberStr));
        if (orgAccount == null) {
            return null;
        }

        // 过期校验
        if (txVisitor.getStartTime() == null) {
            // 未开通时，按照过期处理
            throw new IllegalArgumentException(GenericsUtils.formatOutput("txVisitor is expired :{} ", txVisitor));
        } else if (Days.daysBetween(new DateTime(txVisitor.getStartTime().getTime()), DateTime.now())
            .isGreaterThan(Days.days(txVisitor.getRemainDay()))) {
            throw new IllegalArgumentException(GenericsUtils.formatOutput("txVisitor is expired :{} ", txVisitor));
        }
        OrgInfo orgInfo = orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
        TXLoginAccountDto txLoginAccountDto = loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
        txLoginAccountDto.setDataAccountType(BizConf.EXPERIENCE_ACCOUNT);
        List<RoleDto> roleDtos = Lists.newArrayList();
        RoleDto roleDto = new RoleDto();
        roleDto.setNickName(orgInfo.getShortName());
        roleDto.setName(mobile);
        roleDto.setMobile(mobile);
        roleDto.setType(BizConf.EXPERIENCE_ACCOUNT);
        roleDto.setId(orgAccount.getNumber());
        roleDto.setCreateTime(orgAccount.getCreateTime().getTime());
        TXAccount txAccount = txAccountService.getByOrgId(orgAccount.getId());
        if (txAccount == null) {
            throw new BussinessException(CommonErrorCode.INVALIDATE_CLIENTID, "主账号不存在或已暂停使用");
        }
        String auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), null, txAccount.getId(), null,
            txVisitor.getId(), null, AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, fromMasterOrgId);
        roleDto.setAuth_token(auth_token);
        List<PermissionDto> permissions = Lists.newArrayList();
        // 体验帐号关闭的权限
        for (ExpTxPermission tp : TxVisitorAuthenticateHandler.FORBID_PERMISSIONS) {
            PermissionDto pd = new PermissionDto();
            pd.setName(tp.getLabel());
            pd.setTag(ExpTxPermission.getCompleteValue(tp));
            pd.setType(TXPermissionHasType.LOST.getCode());
            permissions.add(pd);
        }
        // 拼所有权限
        List<TXPermission> txPermissionsInDB = txPermissionDao.getAll();
        for (TXPermission txPermission : txPermissionsInDB) {
            PermissionDto pd = new PermissionDto();
            pd.setName(txPermission.getName());
            pd.setTag(txPermission.getCode().toString());
            pd.setType(TXPermissionHasType.OWN.getCode());
            permissions.add(pd);
        }
        roleDto.setHasPermissions(permissions);
        roleDtos.add(roleDto);
        txLoginAccountDto.setHasRoles(roleDtos);

        InitPageUtils.fillInitPageInfos(txAccount, txLoginAccountDto, orgInfo.getShortName());

        return txLoginAccountDto;
    }

    /**
     * @param fromOrgId
     * @param txCascadeCredential
     * @return
     * @throws Exception
     */
    private List<TXLoginAccountDto> createCascadeAccountLoginData(Integer fromOrgId,
        TXCascadeCredential txCascadeCredential, Integer fromMasterOrgId) throws Exception {

        List<TXLoginAccountDto> loginDtos = Lists.newArrayList();

        List<TXCascadeAccount> txCascadeAccounts =
            txCascadeAccountDao.getValidAccountsByCredentialId(txCascadeCredential.getId());
        if (CollectionUtils.isEmpty(txCascadeAccounts)) {
            return Lists.newArrayList();
        }
        Map<Integer, TXLoginAccountDto> existDto = Maps.newHashMap();
        log.info("txCascadeAccounts:{}", txCascadeAccounts);
        for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
            OrgAccount orgAccount = orgAccountService.getOrgAccountById(txCascadeAccount.getOrgId());
            log.info("for orgAccount :{} , fromOrgId is:{} ", orgAccount, fromOrgId);
            // 总校区
            boolean hasTXPermission = hagService.hasPermission(orgAccount.getNumber(), BizConf.DEFAULT_TYPE,
                BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER);
            if (!hasTXPermission) {
                log.info("no hag txCascadeAccount:{}", txCascadeAccount);
                continue;
            }
            OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
            if (null == orgSubAccount || orgSubAccount.getStatus() != OrgSubAccountStatus.NORMAL.getCode().intValue()) {
                log.info("cascade:{}, can not login because the orgSubAccount is forbidden", txCascadeAccount);
                continue;
            }
            // 网校用户不允许登录
            if (null != orgSubAccount && orgSubAccount.getOnlineType() == Flag.TRUE.getInt()) {
                log.info("cascade orgSubAccount onlineType invalid:{}", orgSubAccount);
                continue;
            }
            // 这里过滤了被禁用 被删除的天校帐号
            TXAccount txAccount = txAccountService
                .getByOrgId(orgSubAccount.getPid() > 0 ? orgSubAccount.getPid() : orgSubAccount.getOrgId());
            String auth_token = null;
            // 两种情况为null，禁用了，删除了
            if (txAccount == null) {
                log.info("this cascade:{} can not find txAccount, maybe txAccount is forbidden", txCascadeAccount);
                continue;
            } else {
                // 大众版用户不让登子帐号, 有子帐号算脏数据
                if (txAccount.getVipLevel() == TXAccountType.DAZHONG.getCode()) {
                    log.info("cascade txAccount invalid111:{}", txAccount);
                    continue;
                }
                // 总校主管允许登录pc,txAccount.id 是登录pc标识
                if (orgSubAccount.getPid() == 0
                    && txCascadeAccount.getAccountType() == CascadeType.MANAGER.getValue()) {
                    auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), txCascadeAccount.getId(),
                        txAccount.getId(), fromOrgId, txCascadeAccount.getAccountVersion(),
                        AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, fromMasterOrgId);
                } else {
                    auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), txCascadeAccount.getId(), null, fromOrgId,
                        txCascadeAccount.getAccountVersion(), AbstractAuthenticateHandler.TX_APP_ENVIRONMENT,
                        fromMasterOrgId);
                }
            }
            OrgInfo orgInfo = orgInfoService.getOrgInfoByOrgId(orgAccount.getId());

            TXLoginAccountDto dto = null;
            if (existDto.containsKey(orgAccount.getId())) {
                dto = existDto.get(orgAccount.getId());
            } else {
                dto = loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
                List<RoleDto> roleDtos = com.google.common.collect.Lists.newArrayList();
                dto.setHasRoles(roleDtos);
                existDto.put(orgAccount.getId(), dto);
                loginDtos.add(dto);
            }
            dto.setDataAccountType(BizConf.NORMAL_ACCOUNT);
            RoleDto roleDto = new RoleDto();
            roleDto.setId(txCascadeAccount.getId());
            roleDto.setNickName(txCascadeCredential.getName());
            roleDto.setType(txCascadeAccount.getAccountType());
            roleDto.setAuth_token(auth_token);
            roleDto.setMobile(txCascadeCredential.getMobile());
            roleDto.setCreateTime(txCascadeAccount.getCreateTime().getTime());

            InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShowName());

            // 权限
            TxAccountPermissionsDto txAccountPermissionDto =
                txAccountPermissionService.universalGetPermissions(orgAccount.getId(), txCascadeAccount.getId());
            roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
            if (StringUtils.isNotBlank(txCascadeCredential.getAvatar())) {
                roleDto.setRoleAvatar(txCascadeCredential.getAvatar());
            } else {
                roleDto.setRoleAvatar(BizConstant.DEFAULT_CASCADE_AVATAR);
            }
            dto.getHasRoles().add(roleDto);
            InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShortName());
        }
        return loginDtos;
    }

    /**
     * @param txAccount
     * @param version
     * @return
     * @throws Exception
     */
    private TXLoginAccountDto createOrgAccountLoginData(Integer fromOrgId, OrgAccount orgAccount, TXAccount txAccount,
        boolean isMaster, Integer version, Integer fromMasterOrgId) throws Exception {
        OrgInfo orgInfo = orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
        TXLoginAccountDto dto = loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
        dto.setDataAccountType(BizConf.NORMAL_ACCOUNT);
        List<RoleDto> roleDtos = Lists.newArrayList();
        RoleDto roleDto = new RoleDto();
        roleDto.setId(orgAccount.getNumber());
        roleDto.setNickName(orgInfo.getContacts());
        roleDto.setCreateTime(orgAccount.getCreateTime().getTime());
        roleDto.setName("校长");
        roleDto.setMobile(orgAccount.getMobile());
        roleDtos.add(roleDto);
        String auth_token = null;
        if (isMaster) {
            roleDto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
            auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), null, txAccount.getId(), fromOrgId, version,
                AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, fromMasterOrgId);
        } else {
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), null, null, fromOrgId, version,
                AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, fromMasterOrgId);
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
        }
        TxAccountPermissionsDto txAccountPermissionDto =
            txAccountPermissionService.universalGetPermissions(orgAccount.getId(), null);
        roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
        roleDto.setAuth_token(auth_token);
        roleDto.setRoleAvatar(dto.getAvatar());

        InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShortName());

        dto.setHasRoles(roleDtos);
        return dto;
    }

}
