
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.www.Util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.GenericsUtils.GroupSortComparator;
import com.baijia.tianxiao.util.GenericsUtils.MulitGroupSortComparator;
import com.baijia.tianxiao.util.GenericsUtils.MulitGroupSorter;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Feb 10, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class InitPageUtils {

    private static MulitGroupSortComparator<TXLoginAccountDto> sortByOrgAndCreateTime =
        new MulitGroupSortComparator<TXLoginAccountDto>() {

            @Override
            public int compare(MulitGroupSorter<TXLoginAccountDto> o1_, MulitGroupSorter<TXLoginAccountDto> o2_) {
                TXLoginAccountDto o1 = o1_.getObj();
                TXLoginAccountDto o2 = o2_.getObj();
                int compareTo = o1.getCreateTime().compareTo(o2.getCreateTime());
                System.out.println("o1.createTime " + o1.getCreateTime() + " with o2.createTime : " + o2.getCreateTime()
                    + " result : " + compareTo);
                if (compareTo == 0) {
                    compareTo = o1.getShort_name().compareTo(o2.getShort_name());
                }
                return compareTo;
            }

            @Override
            public MulitGroupSorter<TXLoginAccountDto> getPid(TXLoginAccountDto obj) {
                return new MulitGroupSorter<TXLoginAccountDto>(obj) {
                    @Override
                    public Object getPid() {
                        return this.getObj().getUser_number();
                    }
                };
            }
        };

    private static GroupSortComparator<Integer, TXLoginAccountDto> sortByType =
        new GroupSortComparator<Integer, TXLoginAccountDto>() {
            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }

            @Override
            public Integer getPid(TXLoginAccountDto obj) {
                return obj.getType();
            }
        };

    @SuppressWarnings("rawtypes")
    private static List<Comparator> comparatorList = Arrays.<Comparator> asList(sortByOrgAndCreateTime, sortByType);

    public static void fillInitPageInfos(TXAccount txAccount, TXLoginAccountDto dto, String orgName) {
        log.info("txAccount is :{} ", txAccount);
        String initOrgName = "";
        String orgLogo = "";
        String orgSlogan = "";
        Integer infoFillStatus = 0;
        if (txAccount != null) {
            initOrgName = txAccount.getInitOrgName();
            initOrgName = GenericsUtils.isNullOrEmpty(initOrgName) ? orgName : initOrgName;
            orgSlogan = txAccount.getOrgSlogan();
            orgLogo = txAccount.getOrgLogo();
            Integer infoFillStatus_ = txAccount.getInfoFillStatus();
            if (infoFillStatus_.intValue() != 0) {
                infoFillStatus = 1;
            }
        }
        dto.setInfoFillStatus(infoFillStatus);
        dto.setInitOrgName(initOrgName);
        dto.setOrgSlogan(orgSlogan);
        dto.setOrgLogo(orgLogo);
    }

    /**
     * 获取机构的城市信息
     * 
     * @param areaId
     * @return
     */
    public static String createCity(Long areaId) {
        Map<String, String> areaMap = AreaUtils.getAreaNameByCode(areaId);
        log.info("with areaId:{} and areaMap is :{} ", areaId, areaMap);
        if (GenericsUtils.notNullAndEmpty(areaMap)) {
            return areaMap.get("city");
        }
        return "";
    }

    /**
     * @param newLoginDtos
     */
    @SuppressWarnings("rawtypes")
    public static List<TXLoginAccountDto> sortResult(Collection<TXLoginAccountDto> newLoginDtos) {
        List<TXLoginAccountDto> groupSort = GenericsUtils.<TXLoginAccountDto> groupSort(
            Lists.<Object> newArrayList(newLoginDtos), Lists.<Comparator> newArrayList(comparatorList));
        return groupSort;
    }

    public static void main(String[] args) {
        List<TXLoginAccountDto> list = Lists.newArrayList();
        TXLoginAccountDto tlad = new TXLoginAccountDto();
        tlad.setUser_number(331781449);
        tlad.setCreateTime(1486724262000L);
        tlad.setShort_name("鹤啦啦啦啦啦啦啦啦啦啦啦啦啦啦啦啦啦啦啦");
        tlad.setType(1);
        list.add(tlad);

        TXLoginAccountDto tlad2 = new TXLoginAccountDto();
        tlad2.setUser_number(496708249);
        tlad2.setCreateTime(1476772815000L);
        tlad2.setShort_name("新校区设置");
        tlad2.setType(3);
        list.add(tlad2);

        TXLoginAccountDto tlad4 = new TXLoginAccountDto();
        tlad4.setUser_number(331781449);
        tlad4.setCreateTime(1486724262000L);
        tlad4.setShort_name("鹤啦啦啦啦啦啦啦啦啦啦啦啦啦啦啦啦啦啦啦");
        tlad4.setType(4);
        list.add(tlad4);

        TXLoginAccountDto tlad3 = new TXLoginAccountDto();
        tlad3.setUser_number(331778969);
        tlad3.setCreateTime(1486724316000L);
        tlad3.setShort_name("CRM机构");
        tlad3.setType(3);
        list.add(tlad3);

        TXLoginAccountDto tlad5 = new TXLoginAccountDto();
        tlad5.setUser_number(331799449);
        tlad5.setCreateTime(1486724342000L);
        tlad5.setShort_name("北京同学体验校区");
        tlad5.setType(4);
        list.add(tlad5);

        // Collections.sort(list, new Comparator<TXLoginAccountDto>() {
        // @Override
        // public int compare(TXLoginAccountDto o1, TXLoginAccountDto o2) {
        // int compareTo = o1.getCreateTime().compareTo(o2.getCreateTime());
        // System.out.println("o1.createTime " + o1.getCreateTime() + " with o2.createTime : " + o2.getCreateTime()
        // + " result : " + compareTo);
        // if (compareTo == 0) {
        // compareTo = o1.getShort_name().compareTo(o2.getShort_name());
        // }
        // return compareTo;
        // }
        // });
        // System.out.println("list are :{} " + list);

        // 测试不同机构根据时间/机构名称先后排序,相同机构根据类型排序
        List<TXLoginAccountDto> sortResult = sortResult(list);

        for (TXLoginAccountDto tlad_ : sortResult) {
            System.out.println("userNumber:" + tlad_.getUser_number() + " -- createTime:" + tlad_.getCreateTime()
                + " -- shortName:" + tlad_.getShort_name() + " --type:" + tlad_.getType());
        }

    }

}
