/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www.authentication.handler;

import com.baijia.tianxiao.biz.www.LoginAccountDtoHelper;
import com.baijia.tianxiao.biz.www.Util.PermissionTransformUtil;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.Credential;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.pcAuthority.dao.TXPermissionDao;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.memcached.MemcachedUtil;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TxCascadeAccountAuthenticateHandler
extends AbstractAuthenticateHandler {
    private static final Logger log = LoggerFactory.getLogger(TxCascadeAccountAuthenticateHandler.class);
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private LoginAccountDtoHelper loginAccountDtoHelper;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private TXPermissionDao txPermissionDao;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private HagService hagService;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;

    @Override
    protected boolean doAuthentication(Credential credential, Map<String, Object> options) throws BussinessException {
        TXCascadeCredential txCascadeCredential;
        block10: {
            block11: {
                txCascadeCredential = this.txCascadeCredentialDao.getByMobile(credential.getMobile());
                if (txCascadeCredential == null) {
                    return false;
                }
                Boolean isTemp = false;
                try {
                    String tempPwd = (String)MemcachedUtil.get((String)("uniq_temp_tx_password_" + credential.getMobile()));
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tempPwd}) && tempPwd.equals(credential.getPassword())) {
                        MemcachedUtil.delete((String)("uniq_temp_tx_password_" + credential.getMobile()));
                        isTemp = true;
                    }
                }
                catch (InterruptedException | TimeoutException | MemcachedException e) {
                    log.error("get temp pwd error!mobile:{}", (Object)credential.getMobile(), (Object)e);
                }
                OrgAccount orgAccount = null;
                if (options.get("orgAccount") != null) {
                    orgAccount = (OrgAccount)options.get("orgAccount");
                }
                try {
                    if (isTemp.booleanValue()) break block10;
                    if (orgAccount == null) break block11;
                    if (!PasswordUtil.validatePassword((String)credential.getPassword(), (String)orgAccount.getPassword())) {
                        return false;
                    }
                }
                catch (Exception e) {
                    log.info("login pwd:{},hash:{},error!:{}", new Object[]{credential.getPassword(), txCascadeCredential.getPassword(), e});
                    return false;
                }
            }
            if (!PasswordUtil.validatePassword((String)credential.getPassword(), (String)txCascadeCredential.getPassword())) {
                return false;
            }
        }
        options.put("txCascadeCredential", txCascadeCredential);
        return true;
    }

    @Override
    protected boolean postAuthenticate(Credential credential, boolean authenticated, List<TXLoginAccountDto> loginDtos, Map<String, Object> options) throws BussinessException, Exception {
        TXCascadeCredential txCascadeCredential = (TXCascadeCredential)options.get("txCascadeCredential");
        List txCascadeAccounts = this.txCascadeAccountDao.getValidAccountsByCredentialId(txCascadeCredential.getId());
        if (CollectionUtils.isEmpty((Collection)txCascadeAccounts)) {
            return false;
        }
        HashMap existDto = Maps.newHashMap();
        log.info("txCascadeAccounts:{}", (Object)txCascadeAccounts);
        for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
            OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(txCascadeAccount.getOrgId());
            boolean hasTXPermission = this.hagService.hasPermission((Object)orgAccount.getNumber(), 0, "jigou_tianxiao_orgNumber", new Object[0]);
            if (!hasTXPermission) {
                log.info("no hag txCascadeAccount:{}", (Object)txCascadeAccount);
                continue;
            }
            TXAccount txAccount = this.txAccountService.getByOrgId(orgAccount.getId());
            String auth_token = null;
            if (txAccount == null) {
                auth_token = EncryptUtils.txStrEncode((Integer)orgAccount.getId(), (Integer)txCascadeAccount.getId(), null, (Integer)txCascadeAccount.getAccountVersion(), (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT);
                OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId());
                txAccount = this.txAccountService.getByOrgId(orgSubAccount.getPid());
                if (txAccount == null || txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode().intValue()) {
                    log.info("txAccount invalid:{}", (Object)txAccount);
                    continue;
                }
            } else {
                if (txAccount.getVipLevel() == TXAccountType.DAZHONG.getCode()) {
                    log.info("txAccount invalid111:{}", (Object)txAccount);
                    continue;
                }
                auth_token = txCascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue() ? EncryptUtils.txStrEncode((Integer)orgAccount.getId(), (Integer)txCascadeAccount.getId(), (Integer)txAccount.getId(), (Integer)txCascadeAccount.getAccountVersion(), (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT) : EncryptUtils.txStrEncode((Integer)orgAccount.getId(), (Integer)txCascadeAccount.getId(), null, (Integer)txCascadeAccount.getAccountVersion(), (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT);
            }
            TXLoginAccountDto dto = null;
            if (existDto.containsKey(orgAccount.getId())) {
                dto = (TXLoginAccountDto)existDto.get(orgAccount.getId());
            } else {
                OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
                dto = this.loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
                ArrayList roleDtos = Lists.newArrayList();
                dto.setHasRoles(roleDtos);
                existDto.put(orgAccount.getId(), dto);
                loginDtos.add(dto);
            }
            dto.setDataAccountType(0);
            RoleDto roleDto = new RoleDto();
            roleDto.setId(txCascadeAccount.getId());
            roleDto.setNickName(txCascadeCredential.getName());
            roleDto.setType(txCascadeAccount.getAccountType());
            roleDto.setAuth_token(auth_token);
            roleDto.setMobile(txCascadeCredential.getMobile());
            TxAccountPermissionsDto txAccountPermissionDto = this.txAccountPermissionService.universalGetPermissions(orgAccount.getId().intValue(), txCascadeAccount.getId());
            roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
            if (StringUtils.isNotBlank((CharSequence)txCascadeCredential.getAvatar())) {
                roleDto.setRoleAvatar(txCascadeCredential.getAvatar());
            } else {
                roleDto.setRoleAvatar("http://img.gsxservice.com/21644918_xqjeiipb.png");
            }
            dto.getHasRoles().add(roleDto);
        }
        return true;
    }
}

