/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www.authentication.handler;

import com.baijia.tianxiao.biz.www.LoginAccountDtoHelper;
import com.baijia.tianxiao.biz.www.Util.PermissionTransformUtil;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.Credential;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.memcached.MemcachedUtil;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TxAccountAuthenticateHandler
extends AbstractAuthenticateHandler {
    private static final Logger log = LoggerFactory.getLogger(TxAccountAuthenticateHandler.class);
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private LoginAccountDtoHelper loginAccountDtoHelper;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private HagService hagService;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;

    @Override
    protected boolean doAuthentication(Credential credential, Map<String, Object> options) throws BussinessException {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByMobile(credential.getMobile());
        if (orgAccount == null) {
            log.info("can not find mobile");
            return false;
        }
        options.put("orgAccount", orgAccount);
        Boolean isTemp = false;
        try {
            String tempPwd = (String)MemcachedUtil.get((String)("uniq_temp_tx_password_" + credential.getMobile()));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tempPwd}) && tempPwd.equals(credential.getPassword())) {
                MemcachedUtil.delete((String)("uniq_temp_tx_password_" + credential.getMobile()));
                isTemp = true;
            }
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            log.error("get temp pwd error!mobile:{}", (Object)credential.getMobile(), (Object)e);
        }
        try {
            if (!isTemp.booleanValue() && !PasswordUtil.validatePassword((String)credential.getPassword(), (String)orgAccount.getPassword())) {
                log.info("orgaccount pwd error!");
                return false;
            }
        }
        catch (Exception e) {
            log.info("login pwd:{},hash:{},error!:{}", new Object[]{credential.getPassword(), orgAccount.getPassword(), e});
            return false;
        }
        boolean hasTXPermission = this.hagService.hasPermission((Object)orgAccount.getNumber(), 0, "jigou_tianxiao_orgNumber", new Object[0]);
        if (!hasTXPermission) {
            log.info("hag not permission");
            return false;
        }
        TXAccount txAccount = this.txAccountService.getByOrgId(orgAccount.getId());
        options.put("txAccount", txAccount);
        OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId());
        if (txAccount == null) {
            if (orgSubAccount.getStatus().intValue() != OrgSubAccountStatus.NORMAL.getCode().intValue()) {
                return false;
            }
            txAccount = this.txAccountService.getByOrgId(orgSubAccount.getPid());
            if (txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode().intValue()) {
                log.info("fenxiaoqu");
                return false;
            }
            options.put("masterFlag", Boolean.FALSE);
        } else {
            if (!this.loginAccountDtoHelper.validTXVersion(txAccount, options.get("version").toString())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5927\u4f17\u7248\u7528\u6237\u8bf7\u5347\u7ea7\u81f3\u6700\u65b0\u7248\u672c");
            }
            options.put("masterFlag", Boolean.TRUE);
        }
        options.put("orgSubAccountVersion", orgSubAccount.getAccountVersion());
        return true;
    }

    @Override
    protected boolean postAuthenticate(Credential credential, boolean authenticated, List<TXLoginAccountDto> loginDtos, Map<String, Object> options) throws BussinessException, Exception {
        OrgAccount orgAccount = (OrgAccount)options.get("orgAccount");
        TXAccount txAccount = (TXAccount)options.get("txAccount");
        OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
        TXLoginAccountDto dto = this.loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
        dto.setDataAccountType(0);
        ArrayList roleDtos = Lists.newArrayList();
        RoleDto roleDto = new RoleDto();
        roleDto.setId(orgAccount.getNumber());
        roleDto.setNickName(orgInfo.getContacts());
        roleDto.setName("\u6821\u957f");
        roleDto.setMobile(orgAccount.getMobile());
        roleDtos.add(roleDto);
        String auth_token = null;
        Boolean masterFlag = (Boolean)options.get("masterFlag");
        Integer accountVersion = (Integer)options.get("orgSubAccountVersion");
        if (masterFlag.booleanValue()) {
            roleDto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
            auth_token = EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, (Integer)txAccount.getId(), (Integer)accountVersion, (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT);
        } else {
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            auth_token = EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, null, (Integer)accountVersion, (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT);
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
        }
        TxAccountPermissionsDto txAccountPermissionDto = this.txAccountPermissionService.universalGetPermissions(orgAccount.getId().intValue(), null);
        roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
        roleDto.setAuth_token(auth_token);
        roleDto.setRoleAvatar(dto.getAvatar());
        dto.setHasRoles(roleDtos);
        loginDtos.add(dto);
        return true;
    }
}

