/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www;

import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.organization.org.service.OrgPhotoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgTxtMsgService;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoginAccountDtoHelper {
    private static final Logger log = LoggerFactory.getLogger(LoginAccountDtoHelper.class);
    public static final String NEW_IM_TOKEN = "1";
    public static final String OLD_IM_TOKEN = "2";
    @Autowired
    private OrgTxtMsgService orgTxtMsgService;
    @Autowired
    private OrgPhotoService orgPhotoService;

    public TXLoginAccountDto buildLoginData(OrgAccount account, OrgInfo orgInfo) throws Exception {
        TXLoginAccountDto data = new TXLoginAccountDto();
        data.setShort_name(orgInfo.getShortName());
        data.setUser_id(account.getId());
        data.setUser_number(account.getNumber());
        data.setAudit_status(orgInfo.getAuditStatus());
        data.setHome_page(String.valueOf(PropertiesReader.getValue((String)"tianxiao", (String)"TIANXIAO_M")) + "i/" + account.getNumber());
        OrgTxtMsg hotLine = this.orgTxtMsgService.getOrgTxtByIdAndType(account.getId().intValue(), AuditColumType.PHONE.getValue());
        data.setHotline(hotLine == null ? null : hotLine.getValue());
        data.setAvatar(this.orgPhotoService.getPhotoUrlByOrgIdAndCategory(Long.valueOf(account.getId().longValue()), OrgImgType.ORG_LOGO));
        return data;
    }

    public boolean validTXVersion(TXAccount txAccount, String version) {
        if (txAccount.getVipLevel().intValue() != TXAccountType.DAZHONG.getCode().intValue()) {
            return true;
        }
        String vReq = version.replace(".", "");
        String vBase = "153";
        int index = 0;
        while (index < vBase.length()) {
            if (Integer.valueOf(String.valueOf(vBase.charAt(0))) < Integer.valueOf(String.valueOf(vReq.charAt(0))) || Integer.valueOf(String.valueOf(vBase.charAt(1))) < Integer.valueOf(String.valueOf(vReq.charAt(1))) || Integer.valueOf(String.valueOf(vBase.charAt(1))) < Integer.valueOf(String.valueOf(vReq.charAt(1)))) break;
            Integer base = Integer.valueOf(String.valueOf(vBase.charAt(index)));
            Integer req = Integer.valueOf(String.valueOf(vReq.charAt(index)));
            if (base > req) {
                return false;
            }
            ++index;
        }
        return true;
    }
}

