/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www.authentication;

import com.baijia.tianxiao.biz.www.authentication.Credential;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractAuthenticateHandler {
    protected static final String ORG_ACCOUNT_KEY = "orgAccount";
    protected static final String TX_ACCOUNT_KEY = "txAccount";
    protected static final String TX_VISITOR_KEY = "txVisitor";
    protected static final String TX_CASCADE_CREDENTIAL_KEY = "txCascadeCredential";
    protected static final String MASTER_FLAG = "masterFlag";
    protected static final String TX_ACCOUNT_VERSION = "orgSubAccountVersion";
    protected static final String TX_APP_ENVIRONMENT = PropertiesReader.getValue((String)"rest", (String)"webapp.deploy.environment");

    protected boolean preAuthenticate(Credential credential, Map<String, Object> options) throws BussinessException {
        if (credential == null || StringUtils.isBlank((CharSequence)credential.getMobile()) || StringUtils.isBlank((CharSequence)credential.getPassword())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7528\u6237\u540d\u548c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return true;
    }

    protected boolean postAuthenticate(Credential credential, boolean authenticated, List<TXLoginAccountDto> loginDtos, Map<String, Object> options) throws BussinessException, Exception {
        return authenticated;
    }

    public final boolean authenticate(Credential credential, List<TXLoginAccountDto> loginDtos, Map<String, Object> options) throws BussinessException, Exception {
        if (!this.preAuthenticate(credential, options)) {
            return false;
        }
        boolean authenticated = this.doAuthentication(credential, options);
        if (authenticated) {
            return this.postAuthenticate(credential, authenticated, loginDtos, options);
        }
        return false;
    }

    protected abstract boolean doAuthentication(Credential var1, Map<String, Object> var2) throws BussinessException;
}

