/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.tasks;

import com.baijia.tianxiao.biz.tasks.queryParam.CreateTeacherRequest;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.sal.common.api.OrgTeacherForSolrService;
import com.baijia.tianxiao.task.local.annotation.TaskBean;
import com.baijia.tianxiao.task.local.annotation.TaskService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@TaskService
public class TeacherInfoDocumentTaskService {
    private static final Logger log = LoggerFactory.getLogger(TeacherInfoDocumentTaskService.class);
    public static final Integer PAGE_SIZE = 100;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private OrgTeacherForSolrService orgTeacherForSolrService;

    @TaskBean(value="createTeacherInfoDocumentTask")
    public void doTask(CreateTeacherRequest request) {
        Date beginDate = DateUtil.getStartOfMonth();
        Date endDate = DateUtil.getEndOfMonth();
        log.info("with orgIds :{} and startDate:{} ,endDate:{} ,the task is create over!", new Object[]{request.getOrgIds(), beginDate, endDate});
        if (GenericsUtils.notNullAndEmpty(request.getOrgIds())) {
            for (Long orgId : request.getOrgIds()) {
                this.createTeacherInfoDocuemnts(orgId, beginDate, endDate);
            }
        } else {
            log.info("current task can not find any orgId to create teacher's document!");
        }
    }

    private void createTeacherInfoDocuemnts(Long orgId, Date beginDate, Date endDate) {
        try {
            Long lastId = null;
            List orgTeachers = this.orgTeacherDao.listByLastId(orgId, lastId, PAGE_SIZE, null, null, new String[0]);
            log.info("orgTeachers'size is :{} ", (Object)orgTeachers.size());
            while (GenericsUtils.notNullAndEmpty((Object)orgTeachers)) {
                Map orgTeacherMap = CollectorUtil.collectMap((Collection)orgTeachers, (Function)new Function<OrgTeacher, Long>(){

                    public Long apply(OrgTeacher teacher) {
                        return teacher.getUserId();
                    }
                });
                log.info("--------0---------");
                this.orgTeacherForSolrService.createOrgTeacherDocuments(orgId, orgTeacherMap.values(), beginDate, endDate, true);
                log.info("--------1---------");
                lastId = ((OrgTeacher)orgTeachers.get(orgTeachers.size() - 1)).getId();
                orgTeachers = this.orgTeacherDao.listByLastId(orgId, lastId, PAGE_SIZE, null, null, new String[0]);
            }
        }
        catch (Exception e) {
            log.error("error :{} ", (Throwable)e);
        }
        log.info("[CreateTeacherInfoDocumentTask] current task for orgId :{} is over ", (Object)orgId);
    }

    public OrgTeacherDao getOrgTeacherDao() {
        return this.orgTeacherDao;
    }

    public TeacherDao getTeacherDao() {
        return this.teacherDao;
    }

    public UserDao getUserDao() {
        return this.userDao;
    }

    public OrgTeacherForSolrService getOrgTeacherForSolrService() {
        return this.orgTeacherForSolrService;
    }

    public void setOrgTeacherDao(OrgTeacherDao orgTeacherDao) {
        this.orgTeacherDao = orgTeacherDao;
    }

    public void setTeacherDao(TeacherDao teacherDao) {
        this.teacherDao = teacherDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setOrgTeacherForSolrService(OrgTeacherForSolrService orgTeacherForSolrService) {
        this.orgTeacherForSolrService = orgTeacherForSolrService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TeacherInfoDocumentTaskService)) {
            return false;
        }
        TeacherInfoDocumentTaskService other = (TeacherInfoDocumentTaskService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OrgTeacherDao this$orgTeacherDao = this.getOrgTeacherDao();
        OrgTeacherDao other$orgTeacherDao = other.getOrgTeacherDao();
        if (this$orgTeacherDao == null ? other$orgTeacherDao != null : !this$orgTeacherDao.equals(other$orgTeacherDao)) {
            return false;
        }
        TeacherDao this$teacherDao = this.getTeacherDao();
        TeacherDao other$teacherDao = other.getTeacherDao();
        if (this$teacherDao == null ? other$teacherDao != null : !this$teacherDao.equals(other$teacherDao)) {
            return false;
        }
        UserDao this$userDao = this.getUserDao();
        UserDao other$userDao = other.getUserDao();
        if (this$userDao == null ? other$userDao != null : !this$userDao.equals(other$userDao)) {
            return false;
        }
        OrgTeacherForSolrService this$orgTeacherForSolrService = this.getOrgTeacherForSolrService();
        OrgTeacherForSolrService other$orgTeacherForSolrService = other.getOrgTeacherForSolrService();
        return !(this$orgTeacherForSolrService == null ? other$orgTeacherForSolrService != null : !this$orgTeacherForSolrService.equals(other$orgTeacherForSolrService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TeacherInfoDocumentTaskService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OrgTeacherDao $orgTeacherDao = this.getOrgTeacherDao();
        result = result * 59 + ($orgTeacherDao == null ? 43 : $orgTeacherDao.hashCode());
        TeacherDao $teacherDao = this.getTeacherDao();
        result = result * 59 + ($teacherDao == null ? 43 : $teacherDao.hashCode());
        UserDao $userDao = this.getUserDao();
        result = result * 59 + ($userDao == null ? 43 : $userDao.hashCode());
        OrgTeacherForSolrService $orgTeacherForSolrService = this.getOrgTeacherForSolrService();
        result = result * 59 + ($orgTeacherForSolrService == null ? 43 : $orgTeacherForSolrService.hashCode());
        return result;
    }

    public String toString() {
        return "TeacherInfoDocumentTaskService(orgTeacherDao=" + this.getOrgTeacherDao() + ", teacherDao=" + this.getTeacherDao() + ", userDao=" + this.getUserDao() + ", orgTeacherForSolrService=" + this.getOrgTeacherForSolrService() + ")";
    }
}

