/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpTo;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncSignupRecordService")
public class SyncSignupRecordServiceImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncSignupRecordServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private TxSignupRecordDayDao txSignupRecordDayDao;
    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;
    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgFinanceAccountService orgFinanceAccountService;
    private AtomicBoolean signupRecordFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(MsgSyncType.CW_SIGNUP_RECORD);
        try {
            if (!this.signupRecordFlag.get()) {
                log.info("sync cw signuprecord iosinfo :{}", (Object)syncInfo);
                this.signupRecordFlag.set(true);
                Thread.sleep(20000L);
                this.syncSignupRecordDay(syncInfo);
                this.signupRecordFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.signupRecordFlag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncSignupRecordDay(TxMsgSyncTimestamp syncInfo) {
        List signupInfos = this.orgSignupInfoDao.getOrgSignupListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 50, new String[0]);
        log.info("syncSignupRecordDay: result=={} success", (Object)signupInfos);
        if (CollectionUtils.isNotEmpty((Collection)signupInfos)) {
            for (OrgSignupInfo orgSignupInfo : signupInfos) {
                log.info("syncSignupRecordDay: before=={} success", (Object)orgSignupInfo);
                try {
                    Date tempSyncTime = syncInfo.getSyncTime();
                    if (orgSignupInfo.getUpdateTime().after(syncInfo.getSyncTime())) {
                        syncInfo.setSyncTime(orgSignupInfo.getUpdateTime());
                    }
                    if (orgSignupInfo.getFinanceSync() == 1 || orgSignupInfo.getPayTime() == null || orgSignupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode() || orgSignupInfo.getSplitResult().intValue() != SplitCourseResult.SUCCESS.getCode() || orgSignupInfo.getOrderType().intValue() == TransferClassOrder.NORMAL_ORDER.getCode() && orgSignupInfo.getStudentPayPrice() + orgSignupInfo.getTotalPrices() == 0L || orgSignupInfo.getOrderType().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode() && orgSignupInfo.getStudentPayPrice() + orgSignupInfo.getTotalPrices() == 0L && orgSignupInfo.getTransferRefundMoney() == 0L) continue;
                    List orgSignupCourses = this.orgSignupCourseDao.loadByPurchaseId(orgSignupInfo.getSignupPurchaseId(), new String[0]);
                    if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.NORMAL_ORDER.getCode() && CollectionUtils.isEmpty((Collection)orgSignupCourses)) {
                        syncInfo.setSyncTime(tempSyncTime);
                        break;
                    }
                    orgSignupInfo.setOrgSignupCourses(orgSignupCourses);
                    this.saveSignupRecordDay(orgSignupInfo, FinanceOpTo.INCOME.getCode());
                    if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode() && orgSignupInfo.getTransferRefundMoney() > 0L) {
                        this.saveSignupRecordDay(orgSignupInfo, FinanceOpTo.EXPEND.getCode());
                    }
                    if (orgSignupInfo.getPayType().intValue() == PayType.CASH.getCode() && orgSignupInfo.getStudentPayPrice() + orgSignupInfo.getTotalPrices() > 0L && (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.NORMAL_ORDER.getCode() || orgSignupInfo.getOrderType().intValue() == TransferClassOrder.TIMESCARD_ORDER.getCode())) {
                        this.saveFinanceInfo(orgSignupInfo);
                        this.saveFinanceRecordDay(orgSignupInfo);
                    }
                    orgSignupInfo.setFinanceSync(Integer.valueOf(1));
                    this.orgSignupInfoDao.update((Object)orgSignupInfo, new String[]{"financeSync"});
                    log.info("syncSignupRecordDay:after=={} success", (Object)orgSignupInfo);
                }
                catch (Exception e) {
                    log.warn("sync finance record fail {}", (Throwable)e);
                }
            }
        }
    }

    private void saveFinanceInfo(OrgSignupInfo orgSignupInfo) {
        int opTo = 1;
        OrgFinanceAccountRecord orgFinanceAccountRecord = this.orgFinanceAccountService.getAccountRecordInfo(orgSignupInfo.getOrgId(), orgSignupInfo.getCreateTime());
        if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.NORMAL_ORDER.getCode() && CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                OrgCourse orgCourse = this.orgCourseDao.getByCourseId(orgSignupCourse.getOrgCourseId(), new String[0]);
                TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
                txFinanceInfo.setOrgId(orgSignupInfo.getOrgId());
                txFinanceInfo.setCreateTime(orgSignupInfo.getPayTime());
                txFinanceInfo.setCurrBalance(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrBalance()));
                txFinanceInfo.setCurrFreezeMoney(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrFreezeMoney()));
                txFinanceInfo.setExpectedEarning(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrExpectedEarning()));
                txFinanceInfo.setOpMoney(Double.valueOf(orgSignupCourse.getPayPrice().doubleValue() / 100.0));
                txFinanceInfo.setOpType(FinanceOpType.BAOMING.getCode());
                txFinanceInfo.setPayType(Integer.valueOf(PayType.CASH.getCode()));
                txFinanceInfo.setPurchaseId(orgSignupInfo.getSignupPurchaseId() + "");
                txFinanceInfo.setCourseId(orgCourse.getId());
                StringBuffer opinfo = new StringBuffer();
                opinfo.append(orgCourse != null ? orgCourse.getName() : "").append(" ");
                opinfo.append("\u5b66\u751f:").append(orgSignupInfo.getStudentName()).append(" ");
                txFinanceInfo.setOpInfo(opinfo.toString());
                txFinanceInfo.setOpTo(Integer.valueOf(opTo));
                log.debug("saveFinanceInfo={}", (Object)txFinanceInfo);
                this.txFinanceInfoDao.save((Object)txFinanceInfo, new String[0]);
            }
        } else if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.TIMESCARD_ORDER.getCode()) {
            TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
            txFinanceInfo.setOrgId(orgSignupInfo.getOrgId());
            txFinanceInfo.setCreateTime(orgSignupInfo.getPayTime());
            txFinanceInfo.setCurrBalance(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrBalance()));
            txFinanceInfo.setCurrFreezeMoney(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrFreezeMoney()));
            txFinanceInfo.setExpectedEarning(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrExpectedEarning()));
            txFinanceInfo.setOpMoney(Double.valueOf(orgSignupInfo.getTotalPrices().doubleValue() / 100.0));
            txFinanceInfo.setOpType(FinanceOpType.SETTLEMENT.getCode());
            txFinanceInfo.setPayType(Integer.valueOf(PayType.CASH.getCode()));
            txFinanceInfo.setPurchaseId(orgSignupInfo.getSignupPurchaseId() + "");
            txFinanceInfo.setCourseId(Long.valueOf(0L));
            StringBuffer opinfo = new StringBuffer();
            opinfo.append(orgSignupInfo.getStudentName()).append("(").append(MaskUtil.maskMobile((String)orgSignupInfo.getMobile())).append(")").append("\u8d2d\u4e70\u5408\u540c\u6b21\u5361");
            txFinanceInfo.setOpInfo(opinfo.toString());
            txFinanceInfo.setOpTo(Integer.valueOf(opTo));
            log.debug("saveFinanceInfo={}", (Object)txFinanceInfo);
            this.txFinanceInfoDao.save((Object)txFinanceInfo, new String[0]);
        }
    }

    private void saveFinanceRecordDay(OrgSignupInfo orgSignupInfo) {
        int opType = PayType.CASH.getCode();
        int opTo = 1;
        String mdate = DateUtil.getStrByDate((Date)orgSignupInfo.getPayTime());
        TxFinanceRecordDay txFinanceRecordDay = this.txFinanceRecordDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, opType, opTo, new String[0]);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(orgSignupInfo.getOrgId());
            txFinanceRecordDay.setMdate(orgSignupInfo.getPayTime());
            txFinanceRecordDay.setOpPrice(Double.valueOf(orgSignupInfo.getTotalPrices().doubleValue() / 100.0));
            txFinanceRecordDay.setOpType(Integer.valueOf(opType));
            txFinanceRecordDay.setOpTo(Integer.valueOf(opTo));
        } else {
            txFinanceRecordDay.setOpPrice(Double.valueOf(txFinanceRecordDay.getOpPrice() + orgSignupInfo.getTotalPrices().doubleValue() / 100.0));
        }
        if (CollectionUtils.isEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
            txFinanceRecordDay.setOpCount(Integer.valueOf(txFinanceRecordDay.getOpCount() + 1));
        } else {
            txFinanceRecordDay.setOpCount(Integer.valueOf(txFinanceRecordDay.getOpCount() + (orgSignupInfo.getOrgSignupCourses() == null ? 0 : orgSignupInfo.getOrgSignupCourses().size())));
        }
        log.debug("saveFinanceRecordDay={}", (Object)txFinanceRecordDay);
        this.txFinanceRecordDayDao.saveOrUpdate((Object)txFinanceRecordDay, new String[0]);
    }

    private void saveSignupRecordDay(OrgSignupInfo orgSignupInfo, int opTo) {
        int opType = orgSignupInfo.getSourceType();
        String mdate = DateUtil.getStrByDate((Date)orgSignupInfo.getPayTime());
        double opPrice = 0.0;
        opPrice = opTo == FinanceOpTo.INCOME.getCode() ? (orgSignupInfo.getTotalPrices().doubleValue() + orgSignupInfo.getStudentPayPrice().doubleValue() + orgSignupInfo.getTransferClassMoney().doubleValue()) / 100.0 : orgSignupInfo.getTransferRefundMoney().doubleValue() / 100.0;
        TxSignupRecordDay txSignupRecordDay = this.txSignupRecordDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, opType, opTo, new String[0]);
        if (txSignupRecordDay == null) {
            txSignupRecordDay = new TxSignupRecordDay();
            txSignupRecordDay.setOrgId(orgSignupInfo.getOrgId());
            txSignupRecordDay.setMdate(orgSignupInfo.getPayTime());
            txSignupRecordDay.setOpPrice(Double.valueOf(opPrice));
            txSignupRecordDay.setOpType(Integer.valueOf(opType));
            txSignupRecordDay.setOpTo(Integer.valueOf(opTo));
        } else {
            txSignupRecordDay.setOpPrice(Double.valueOf(txSignupRecordDay.getOpPrice() + opPrice));
        }
        for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
            CoursePurchase coursePurchase = this.coursePurchaseDao.getByPurcahseIdCourse(orgSignupCourse.getSignupPurchaseId(), orgSignupCourse.getOrgCourseId());
            if (coursePurchase == null) continue;
            txSignupRecordDay.setPoundage(Double.valueOf(txSignupRecordDay.getPoundage() + coursePurchase.getPoundage()));
        }
        txSignupRecordDay.setOpCount(Integer.valueOf(txSignupRecordDay.getOpCount() + (orgSignupInfo.getOrgSignupCourses() == null ? 0 : orgSignupInfo.getOrgSignupCourses().size())));
        log.debug("saveSignupRecordDay={}", (Object)txSignupRecordDay);
        this.txSignupRecordDayDao.saveOrUpdate((Object)txSignupRecordDay, new String[0]);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

