/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.signup.service.TransferClassInfoService;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncCancelTransferClassService")
public class SyncCancelTransferClassServiceImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncCancelTransferClassServiceImpl.class);
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgSignupCourseService orgSignupCourseService;
    @Resource
    private SignupService signupService;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;
    @Resource
    private TransferClassInfoService transferClassInfoService;

    @Override
    public void sync() {
        Date last15Min = DateUtil.getDiffMinute((Date)new Date(), (int)-15);
        List signupInfos = this.orgSignupInfoDao.getNeedCannelPurchases(TransferClassOrder.TRANSFER_ORDER, last15Min, new String[0]);
        log.info("syncCancelTransferClassService: signupInfos=={} success", (Object)signupInfos);
        if (CollectionUtils.isNotEmpty((Collection)signupInfos)) {
            for (OrgSignupInfo orgSignupInfo : signupInfos) {
                this.signupService.cancelSignupInfo(orgSignupInfo.getSignupPurchaseId(), orgSignupInfo.getOrgId());
                if (orgSignupInfo.getStudentPayPrice() != null && orgSignupInfo.getStudentPayPrice() > 0L) {
                    OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgSignupInfo.getOrgId(), orgSignupInfo.getUserId(), new String[0]);
                    if (orgStudent == null) {
                        log.error("SyncCancelSignupServiceImpl  not find student =={}", (Object)orgSignupInfo);
                    }
                    String opInfo = this.orgSignupCourseService.getSignupCourseName(orgSignupInfo.getOrgId(), orgSignupInfo.getSignupPurchaseId());
                    this.txStudentFinanceAccountService.changeStudentFiannceAccount(orgSignupInfo.getOrgId(), Integer.valueOf(-1), orgStudent.getId(), orgSignupInfo.getSignupPurchaseId(), StudentFiannceOpType.PAY_CANCEL, orgSignupInfo.getStudentPayPrice(), opInfo, "");
                }
                this.transferClassInfoService.cancelTransferClassByPurchase(orgSignupInfo.getSignupPurchaseId());
            }
        }
    }
}

