/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.fee.dao.TxFeeIncomeDayDao;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.common.api.PointsMsgService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.common.constant.PointsType;
import com.baijia.tianxiao.sal.common.constant.ProducePointType;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpTo;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="syncTransferRefundService")
public class SyncTransferRefundServiceImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncTransferRefundServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private OrgFinanceAccountService orgFinanceAccountService;
    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;
    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;
    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;
    @Autowired
    private TXStudentCommentAPIService tXStudentCommentAPIService;
    @Resource
    private TxTransferClassRecordDao txTransferClassRecordDao;
    @Resource
    private TxTransferClassInfoDao txTransferClassInfoDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private PointsMsgService pointsMsgService;
    @Autowired
    private OrgCourseGroupService courseGroupService;
    @Autowired
    private TxFeeIncomeDayDao txFeeIncomeDayDao;
    @Autowired
    private OrgCourseService orgCourseService;
    private AtomicBoolean transferRefundFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(MsgSyncType.SYNC_TRANSFER_REFUND);
        try {
            if (!this.transferRefundFlag.get()) {
                log.info("sync transferRefundFlag :{}", (Object)syncInfo);
                this.transferRefundFlag.set(true);
                this.syncTransferRefundDay(syncInfo);
                this.transferRefundFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.transferRefundFlag.set(false);
        }
        log.info("save sync transferRefundFlag info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncTransferRefundDay(TxMsgSyncTimestamp syncInfo) {
        List transferClassRecords = this.txTransferClassRecordDao.getOrgTransferRefundListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save transferClassRecords:{} success", (Object)transferClassRecords.size());
        if (CollectionUtils.isNotEmpty((Collection)transferClassRecords)) {
            for (TxTransferClassRecord txTransferClassRecord : transferClassRecords) {
                try {
                    if (txTransferClassRecord.getUpdateTime().after(syncInfo.getSyncTime())) {
                        syncInfo.setSyncTime(txTransferClassRecord.getUpdateTime());
                    }
                    if (txTransferClassRecord.getSyncRefund() == 1) continue;
                    TxTransferClassInfo txTransferClassInfo = this.txTransferClassInfoDao.getByTransferNumber(txTransferClassRecord.getTransferNumber());
                    if (txTransferClassInfo == null) {
                        return;
                    }
                    if (txTransferClassRecord.getRefundType().intValue() == SignupRefundType.BY_ORG_CASH.getCode().intValue() && txTransferClassRecord.getRefundMoney().longValue() > 0L) {
                        this.saveFinanceInfo(txTransferClassRecord, txTransferClassInfo);
                        this.saveFinanceRecordDay(txTransferClassRecord, txTransferClassInfo);
                        this.pointsMsgService.pointsMessage(ProducePointType.TRANFER_REFUND, txTransferClassRecord.getId(), txTransferClassInfo.getOrgId(), txTransferClassRecord.getTransferOutUserId(), Long.valueOf(txTransferClassRecord.getRefundMoney().longValue()), Integer.valueOf(PointsType.DEDUCT.getType()));
                    }
                    if (txTransferClassRecord.getRefundType().intValue() == SignupRefundType.BY_STUDENT_ACCOUNT.getCode().intValue()) {
                        String opInfo = "\u8f6c\u73ed";
                        if (txTransferClassRecord.getRefundMoney().longValue() > 0L) {
                            this.txStudentFinanceAccountService.changeStudentFiannceAccount(txTransferClassInfo.getOrgId(), txTransferClassInfo.getCascadeId(), txTransferClassInfo.getStudentId(), txTransferClassInfo.getTransferOutClassId(), StudentFiannceOpType.TRANSFER_REFUND, Long.valueOf(txTransferClassRecord.getRefundMoney().longValue()), opInfo, txTransferClassRecord.getInPurchaseId() + "");
                        }
                        this.tXStudentCommentAPIService.saveByStudentFinanceRecord(txTransferClassInfo.getStudentId(), Long.valueOf(txTransferClassRecord.getRefundMoney().longValue()), null, opInfo, StudentFiannceOpType.TRANSFER_REFUND.getCode(), FinanceOpTo.INCOME.getCode());
                    }
                    txTransferClassRecord.setSyncRefund(Integer.valueOf(DataStatus.DELETE.getValue()));
                    this.txTransferClassRecordDao.update((Object)txTransferClassRecord, new String[]{"syncRefund"});
                }
                catch (Exception e) {
                    log.warn("sync finance record fail {}", (Throwable)e);
                }
            }
        }
    }

    private void saveFinanceInfo(TxTransferClassRecord txTransferClassRecord, TxTransferClassInfo txTransferClassInfo) {
        int opTo = 2;
        OrgFinanceAccountRecord orgFinanceAccountRecord = this.orgFinanceAccountService.getAccountRecordInfo(txTransferClassInfo.getOrgId(), txTransferClassRecord.getUpdateTime());
        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        txFinanceInfo.setOrgId(txTransferClassInfo.getOrgId());
        txFinanceInfo.setCreateTime(txTransferClassRecord.getUpdateTime());
        txFinanceInfo.setCurrBalance(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrBalance()));
        txFinanceInfo.setCurrFreezeMoney(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrFreezeMoney()));
        txFinanceInfo.setExpectedEarning(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrExpectedEarning()));
        txFinanceInfo.setOpMoney(Double.valueOf(txTransferClassRecord.getRefundMoney().doubleValue() / 100.0));
        txFinanceInfo.setOpType(FinanceOpType.DRAWBACK.getCode());
        txFinanceInfo.setPayType(Integer.valueOf(PayType.CASH.getCode()));
        txFinanceInfo.setPurchaseId(txTransferClassRecord.getOutPurchaseId() + "");
        txFinanceInfo.setCourseId(txTransferClassRecord.getTransferOutClassId());
        txFinanceInfo.setOpInfo("\u8f6c\u73ed");
        txFinanceInfo.setOpTo(Integer.valueOf(opTo));
        log.debug("saveFinanceInfo={}", (Object)txFinanceInfo);
        this.txFinanceInfoDao.save((Object)txFinanceInfo, new String[0]);
    }

    private void saveFinanceRecordDay(TxTransferClassRecord txTransferClassRecord, TxTransferClassInfo txTransferClassInfo) {
        int opType = PayType.CASH.getCode();
        int opTo = 2;
        String mdate = DateUtil.getStrByDate((Date)txTransferClassRecord.getUpdateTime());
        TxFinanceRecordDay txFinanceRecordDay = this.txFinanceRecordDayDao.getByDayType(txTransferClassInfo.getOrgId(), mdate, opType, opTo, new String[0]);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(txTransferClassInfo.getOrgId());
            txFinanceRecordDay.setMdate(txTransferClassRecord.getUpdateTime());
            txFinanceRecordDay.setOpCount(Integer.valueOf(1));
            txFinanceRecordDay.setOpPrice(Double.valueOf(txTransferClassRecord.getRefundMoney().doubleValue() / 100.0));
            txFinanceRecordDay.setOpType(Integer.valueOf(opType));
            txFinanceRecordDay.setOpTo(Integer.valueOf(opTo));
        } else {
            txFinanceRecordDay.setOpPrice(Double.valueOf(txFinanceRecordDay.getOpPrice() + txTransferClassRecord.getRefundMoney().doubleValue() / 100.0));
            txFinanceRecordDay.setOpCount(Integer.valueOf(txFinanceRecordDay.getOpCount() + 1));
        }
        log.debug("saveFinanceRecordDay={}", (Object)txFinanceRecordDay);
        this.txFinanceRecordDayDao.saveOrUpdate((Object)txFinanceRecordDay, new String[0]);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

