/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.service.impl;

import com.baijia.tianxiao.biz.dto.request.QuitClassRequest;
import com.baijia.tianxiao.biz.dto.request.TimesCardRequest;
import com.baijia.tianxiao.biz.dto.response.OrgSignupRefundDto;
import com.baijia.tianxiao.biz.service.RechargeService;
import com.baijia.tianxiao.biz.service.StudentPayService;
import com.baijia.tianxiao.biz.service.TimesCardService;
import com.baijia.tianxiao.constant.finance.PurchaseTimescardStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescard;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescardRefund;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.dto.request.TimesCardRefundRequest;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.TimesCardDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.signup.service.TxTimesCardRefundService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimesCardServiceImpl
implements TimesCardService {
    private static final Logger log = LoggerFactory.getLogger(TimesCardServiceImpl.class);
    @Autowired
    private RechargeService rechargeService;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private SignupService signupService;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private TxPurchaseTimescardDao txPurchaseTimescardDao;
    @Autowired
    private TxTimesCardRefundService txTimesCardRefundService;
    @Autowired
    private TxPurchaseTimescardRefundDao txPurchaseTimescardRefundDao;
    @Autowired
    private StudentPayService studentPayService;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;

    @Override
    public OrgSingupInfoDto timesCardPurchase(TimesCardRequest timesCardRequest) {
        log.info("Times card service params== {}", (Object)timesCardRequest);
        FillCourseInfoRequestDto signupInfo = timesCardRequest.buildSignupInfo();
        signupInfo.setTransferClassOrder(TransferClassOrder.TIMESCARD_ORDER.getCode());
        if (signupInfo.getStudentId() != null) {
            OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)signupInfo.getStudentId(), new String[0]);
            if (orgStudent != null && signupInfo.getStudentMobile().contains("*")) {
                signupInfo.setStudentMobile(orgStudent.getMobile());
            }
            if (signupInfo.getStudentMobile() == null) {
                signupInfo.setStudentMobile(orgStudent.getMobile());
            }
            signupInfo.setStudentName(orgStudent.getName());
        }
        OrgSingupInfoDto result = this.rechargeService.rechargePurchase(signupInfo);
        TxPurchaseTimescard txPurchaseTimescard = this.txPurchaseTimescardDao.getBySignupPurchase(result.getOrgId(), result.getSignupPurchaseId());
        return this.buildDetailDto(result, txPurchaseTimescard);
    }

    @Override
    public OrgSingupInfoDto detail(TimesCardRequest timesCardRequest) {
        OrgSingupInfoDto orgSingupInfoDto = this.signupService.getCourseInfo(timesCardRequest.getHeaders(), timesCardRequest.getSignupPurchaseId(), timesCardRequest.getOrgId(), timesCardRequest.getCascadeId());
        TxPurchaseTimescard txPurchaseTimescard = this.txPurchaseTimescardDao.getBySignupPurchase(orgSingupInfoDto.getOrgId(), orgSingupInfoDto.getSignupPurchaseId());
        return this.buildDetailDto(orgSingupInfoDto, txPurchaseTimescard);
    }

    private OrgSingupInfoDto buildDetailDto(OrgSingupInfoDto orgSingupInfoDto, TxPurchaseTimescard txPurchaseTimescard) {
        TxPurchaseTimescardRefund timescardRefund;
        if (txPurchaseTimescard != null) {
            orgSingupInfoDto.setTimesCardDto(this.buildDto(txPurchaseTimescard));
        }
        if ((timescardRefund = this.txPurchaseTimescardRefundDao.getBySignupPurchase(orgSingupInfoDto.getOrgId(), orgSingupInfoDto.getSignupPurchaseId())) != null) {
            // empty if block
        }
        log.debug("times card detail = {}", (Object)orgSingupInfoDto);
        return orgSingupInfoDto;
    }

    @Override
    public List<TimesCardDto> historyTimesCard(TimesCardRequest timesCardRequest) {
        List list = this.txPurchaseTimescardDao.getByStudentId(timesCardRequest.getOrgId(), timesCardRequest.getStudentId(), Arrays.asList(PurchaseTimescardStatus.SUCCESS.getCode()));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.EMPTY_LIST;
        }
        return this.buildByTimesCard(list);
    }

    @Override
    public void refund(TimesCardRefundRequest timesCardRefundRequest) {
        TxPurchaseTimescard txPurchaseTimescard = this.txPurchaseTimescardDao.getBySignupPurchase(timesCardRefundRequest.getOrgId(), timesCardRefundRequest.getSignupPurchaseId());
        if (txPurchaseTimescard != null) {
            timesCardRefundRequest.setStudentId(txPurchaseTimescard.getStudentId());
            timesCardRefundRequest.setUserId(txPurchaseTimescard.getUserId());
            long refundMoneyLong = new Double(timesCardRefundRequest.getRefundMoney() * 100.0).longValue();
            long refundFee = txPurchaseTimescard.getPayPrice() - refundMoneyLong;
            if (refundFee < 0L) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u5361\u91d1\u989d");
            }
            timesCardRefundRequest.setRefundMoneyLong(Long.valueOf(refundMoneyLong));
            timesCardRefundRequest.setRefundFee(Long.valueOf(refundFee));
            this.txTimesCardRefundService.saveTimesCardRefund(timesCardRefundRequest);
            this.txPurchaseTimescardDao.updateStatusByPurchaseId(timesCardRefundRequest.getSignupPurchaseId(), PurchaseTimescardStatus.REFUND.getCode());
        }
    }

    @Override
    public OrgSignupRefundDto refundDetail(Long orgId, QuitClassRequest quitClassRequest) {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.getByPurchaseId(orgId, quitClassRequest.getSignupPurchaseId());
        if (orgSignupInfo != null) {
            if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.TIMESCARD_ORDER.getCode()) {
                return this.buildRefundDetail(orgId, quitClassRequest);
            }
            return this.studentPayService.detailQuitClass((long)orgId, quitClassRequest);
        }
        return null;
    }

    private List<TimesCardDto> buildByTimesCard(List<TxPurchaseTimescard> list) {
        ArrayList result = Lists.newArrayList();
        for (TxPurchaseTimescard txPurchaseTimescard : list) {
            result.add(this.buildDto(txPurchaseTimescard));
        }
        return result;
    }

    private OrgSignupRefundDto buildRefundDetail(Long orgId, QuitClassRequest quitClassRequest) {
        TxPurchaseTimescardRefund timescardRefund = this.txPurchaseTimescardRefundDao.getBySignupPurchase(orgId, quitClassRequest.getSignupPurchaseId());
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgId);
        OrgSignupRefundDto refundDto = null;
        if (timescardRefund != null) {
            refundDto = new OrgSignupRefundDto();
            refundDto.setRefundMoney(timescardRefund.getRefundPrice().doubleValue() / 100.0);
            refundDto.setRefundType(timescardRefund.getRefundType());
            refundDto.setRefundTypeStr(SignupRefundType.getNameByCode((int)timescardRefund.getRefundType()));
            refundDto.setRefundTime(timescardRefund.getCreateTime());
            refundDto.setCascadeIdStr((String)cascadeMap.get(timescardRefund.getCascadeId().longValue()));
        }
        return refundDto;
    }

    private TimesCardDto buildDto(TxPurchaseTimescard one) {
        TimesCardDto dto = new TimesCardDto();
        dto.setCardNumber(one.getCardNumber());
        dto.setTotalTimes(one.getLessonCount());
        dto.setStartTime(one.getStartTime());
        dto.setEndTime(one.getEndTime());
        dto.setCardRemark(one.getRemark());
        dto.setCreateTime(one.getCreateTime());
        dto.setTotalPrice(Double.valueOf(one.getPayPrice().doubleValue() / 100.0));
        dto.setStatus(one.getStatus());
        return dto;
    }
}

