package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.service.TxSignupService;
import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/9/23 Time: 上午11:28 To change this template use File | Settings
 * | File Templates.
 */
@Service("syncSignupSuccessAndSyncFail")
@Slf4j
public class SyncSignupSuccessAndSyncFail implements SyncPayService {

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private TxSignupService txSignupService;

    @Override
    public void sync() {

        try {
            List<OrgSignupInfo> syncSignupInfoList = orgSignupInfoDao.getSignupSuccessAndNotSync();
            log.info("SyncSignupSuccessAndSyncFail  syncSignupInfoList=={}", syncSignupInfoList);
            if (CollectionUtils.isNotEmpty(syncSignupInfoList)) {
                for (OrgSignupInfo signupInfo : syncSignupInfoList) {
                    txSignupService.syncSuccessSignup(signupInfo);
                }
            }
        } catch (Exception e) {
            log.warn("sy signup sms fail {}", e);
        }
    }

}
