package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.finance.PurchaseTimescardStatus;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgBaseInfoDto;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardDao;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescard;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.util.SmsContentHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by wengshengli on 2017/7/20.
 */
@Service("syncValidTimesCardService")
@Slf4j
public class SyncValidTimesCardServiceImpl implements SyncPayService {

    @Autowired
    private TxPurchaseTimescardDao txPurchaseTimescardDao;

    @Autowired
    private CommonMsgService commonMsgService;

    @Autowired
    private OrgInfoDao orgInfoDao;

    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    public void sync() {
        List<TxPurchaseTimescard> list = txPurchaseTimescardDao.listValidTimesCard();
        if (list != null && list.size() > 0) {
            log.info("Sync Valid Times card service == {}", list.size());
            for (TxPurchaseTimescard txPurchaseTimescard : list) {
                // 过期订单
                int result = txPurchaseTimescardDao.updateStatusByPurchaseId(txPurchaseTimescard.getSignupPurchaseId(), PurchaseTimescardStatus.ECPIRE.getCode());
                if (result > 0) {
                    OrgBaseInfoDto orgInfo = orgInfoDao.getBaseInfo(txPurchaseTimescard.getOrgId().intValue());
                    if (orgInfo != null) {
                        OrgStudent orgStudent = orgStudentDao.getStudentByUserId(txPurchaseTimescard.getOrgId(), txPurchaseTimescard.getUserId());
                        if (orgStudent != null) {
                            String content =
                                    SmsContentHelper.createTimescardValid(txPurchaseTimescard.getEndTime().getTime(), orgInfo.getShortName());
                            commonMsgService.sendTxSms(txPurchaseTimescard.getOrgId().longValue(), txPurchaseTimescard.getOrgId().longValue(), UserRole.ORGANIZATION.getRole(), orgStudent == null ? 0 : orgStudent.getId(), UserRole.STUDENT.getRole(), TxSmsCodeType.TIMECARD_VALID, null, orgStudent.getMobile(), content);
                        }
                    }
                }
            }
        }
    }
}
