package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * 同步财务记录到按日统计
 */
@Service("syncFinanceRecordService")
@Slf4j
public class SyncFinanceRecordServiceImpl implements SyncPayService {

    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;

    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;

    @Resource
    private CoursePurchaseDao coursePurchaseDao;

    @Resource
    private OrgFinanceAccountService orgFinanceAccountService;

    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;

    private AtomicBoolean financeRecordFlag = new AtomicBoolean(false);

    @Override
    public void sync() {

        TxMsgSyncTimestamp syncInfo = getSyncInfo(MsgSyncType.CW_FINANCE_RECORD);
        try {
            if (!financeRecordFlag.get()) {
                log.info("sync cw financeRecord stat info :{}", syncInfo);
                financeRecordFlag.set(true);
                syncFinanceRecordDay(syncInfo);
                financeRecordFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            financeRecordFlag.set(false);
        }
        log.info("save sync info:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }

    private void syncFinanceRecordDay(TxMsgSyncTimestamp syncInfo) {
        //由访问数据表改为调用支付
        //List<OrgFinanceAccountRecord> accountRecords = orgFinanceAccountRecordDao.getFinanceRecordListByMinId(syncInfo.getSyncId(),syncInfo.getSyncTime(), 100);
        List<OrgFinanceAccountRecord> accountRecords = orgFinanceAccountService.getAccountRecordInfos(syncInfo.getSyncId(), 50);
        log.info("save syncFinanceRecordDay:{} success", accountRecords.size());

        if (CollectionUtils.isNotEmpty(accountRecords)) {
            for (OrgFinanceAccountRecord accountRecord : accountRecords) {
                if (accountRecord.getId().longValue() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(accountRecord.getId().longValue());
                }
                dealPayFinance(accountRecord);
            }
        }
    }

    private void dealPayFinance(OrgFinanceAccountRecord accountRecord) {
        log.info("syncFinanceRecordDay--------------------{}", accountRecord);
        try {

            accountRecord.setPreBalance(NumberUtil.get2Double(accountRecord.getPreBalance() == null ? 0 : accountRecord.getPreBalance()));
            accountRecord.setPreExpectedEarning(NumberUtil.get2Double(accountRecord.getPreExpectedEarning() == null ? 0 : accountRecord.getPreExpectedEarning()));
            accountRecord.setPreFreezeMoney(NumberUtil.get2Double(accountRecord.getPreFreezeMoney() == null ? 0 : accountRecord.getPreFreezeMoney()));

            accountRecord.setCurrBalance(NumberUtil.get2Double(accountRecord.getCurrBalance() == null ? 0 : accountRecord.getCurrBalance()));
            accountRecord.setCurrFreezeMoney(NumberUtil.get2Double(accountRecord.getCurrFreezeMoney() == null ? 0 : accountRecord.getCurrFreezeMoney()));
            accountRecord.setCurrExpectedEarning(NumberUtil.get2Double(accountRecord.getCurrExpectedEarning() == null ? 0 : accountRecord.getCurrExpectedEarning()));
            accountRecord.setOpMoney(NumberUtil.get2Double(accountRecord.getOpMoney() == null ? 0 : accountRecord.getOpMoney()));

            /**
             * 申请提现的和提现失败的不计算
             */
            double preMoney = NumberUtil.get2Double(accountRecord.getPreBalance() + accountRecord.getPreExpectedEarning() + accountRecord.getPreFreezeMoney());
            double currMoney = NumberUtil.get2Double(accountRecord.getCurrBalance() + accountRecord.getCurrExpectedEarning() + accountRecord.getCurrFreezeMoney());

            if (accountRecord.getIsShow().intValue() == 1 && preMoney != currMoney
                    && accountRecord.getOpMoney().doubleValue() > 0) {
                saveFinanceInfo(accountRecord);
                saveFinanceRecordDay(accountRecord);
            }
        } catch (Exception e) {
            log.error("sync finance record fail {},{}", e.getMessage(), accountRecord);
        }
    }

    private void saveFinanceRecordDay(OrgFinanceAccountRecord accountRecord) {
        log.info("sync finance record ");
        int payTypeCode = PayType.getCodeByPayType(accountRecord.getCurrPayType() == null ? accountRecord.getPayType() : accountRecord.getCurrPayType());
        int opTo = accountRecord.getOpDesc().equals("-") ? 2 : 1;
        String mdate = DateUtil.getStrByDate(accountRecord.getCreateTime());

        TxFinanceRecordDay txFinanceRecordDay =
                txFinanceRecordDayDao.getByDayType(accountRecord.getOrgId(), mdate, payTypeCode, opTo);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(accountRecord.getOrgId());
            txFinanceRecordDay.setMdate(accountRecord.getCreateTime());
            txFinanceRecordDay.setOpCount(1);
            txFinanceRecordDay.setOpPrice(accountRecord.getOpMoney());
            txFinanceRecordDay.setOpType(payTypeCode);
            txFinanceRecordDay.setOpTo(opTo);
        } else {
            txFinanceRecordDay.setOpPrice(txFinanceRecordDay.getOpPrice() + accountRecord.getOpMoney());
            txFinanceRecordDay.setOpCount(txFinanceRecordDay.getOpCount() + 1);
        }
        log.debug("saveFinanceRecordDay={}", txFinanceRecordDay);
        txFinanceRecordDayDao.saveOrUpdate(txFinanceRecordDay);
    }

    private void saveFinanceInfo(OrgFinanceAccountRecord accountRecord) {
        int payTypeCode = PayType.getCodeByPayType(accountRecord.getCurrPayType() == null ? accountRecord.getPayType() : accountRecord.getCurrPayType());

        int opTo = accountRecord.getOpDesc().equals("-") ? 2 : 1;

        CoursePurchase coursePurchase = null;
        if (accountRecord != null && accountRecord.getPurchaseId() != null) {
            coursePurchase = coursePurchaseDao.getByPurcahseId(accountRecord.getPurchaseId());
        }
        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        txFinanceInfo.setOrgId(accountRecord.getOrgId());
        txFinanceInfo.setCreateTime(accountRecord.getCreateTime());
        txFinanceInfo.setCurrBalance(accountRecord.getCurrBalance());
        txFinanceInfo.setCurrFreezeMoney(accountRecord.getCurrFreezeMoney());
        txFinanceInfo.setExpectedEarning(accountRecord.getCurrExpectedEarning());

        txFinanceInfo.setOpMoney(accountRecord.getOpMoney());
        txFinanceInfo.setOpType(accountRecord.getOpType());
        txFinanceInfo.setPayType(payTypeCode);
        txFinanceInfo.setPurchaseId(accountRecord.getPurchaseId() + "");
        txFinanceInfo.setOpInfo(accountRecord.getOpInfo());
        if (accountRecord.getPurchaseId() != null) {
            OrgSignupInfo orgSignupInfo = orgSignupInfoDao.getByPurchaseId(accountRecord.getOrgId(), accountRecord.getPurchaseId());
            if (orgSignupInfo != null) {
                if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.RECHARGE_ORDER.getCode()) {
                    txFinanceInfo.setOpInfo(orgSignupInfo.getStudentName() + "(" + MaskUtil.maskMobile(orgSignupInfo.getMobile()) + ")账号余额充值");
                } else if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.TIMESCARD_ORDER.getCode()) {
                    txFinanceInfo.setOpInfo(orgSignupInfo.getStudentName() + "(" + MaskUtil.maskMobile(orgSignupInfo.getMobile()) + ")购买合同次卡");
                }
            }
        }
        txFinanceInfo.setOpTo(opTo);
        if (coursePurchase != null) {
            txFinanceInfo.setCourseId(coursePurchase.getCourseId());
        }

        log.debug("saveFinanceInfo={}", txFinanceInfo);
        txFinanceInfoDao.save(txFinanceInfo);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }

}
