package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * 同步主站购买3810课程到报名系统
 */
@Service("syncCoursePurchaseService")
@Slf4j
public class SyncCoursePurchaseServiceImpl implements SyncPayService {

    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    @Resource
    private CoursePurchaseDao coursePurchaseDao;

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    private AtomicBoolean coureFlag = new AtomicBoolean(false);

    @Override
    public void sync() {

        TxMsgSyncTimestamp syncInfo = getSyncInfo(MsgSyncType.PAY_COURSE_PURCHASE);
        try {
            if (!coureFlag.get()) {
                log.info("sync pay coursePurchase stat info :{}", syncInfo);
                coureFlag.set(true);
                syncCoursePurchaseInfo(syncInfo);
                coureFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            coureFlag.set(false);
        }
        log.info("save sync info:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }

    private void syncCoursePurchaseInfo(TxMsgSyncTimestamp syncInfo) {
        List<CoursePurchase> coursePurchases = coursePurchaseDao.getCousePurchaseListByMinId(syncInfo.getSyncId(),
                syncInfo.getSyncTime(), 100, CourseType.ORG_COURSE.getCode(), 1, 1);

        log.info("save payoursePurchases:{} success", coursePurchases.size());

        if (CollectionUtils.isNotEmpty(coursePurchases)) {
            for (CoursePurchase coursePurchase : coursePurchases) {
                try {
                    saveSignUpInfo(coursePurchase);
                    saveSignUpCourse(coursePurchase);
                } catch (Exception e) {
                    log.warn("sygn course purchase fail {}", e);
                }
            }
        }
    }

    private void saveSignUpInfo(CoursePurchase coursePurchase) {
        OrgSignupInfo orgSignupInfo = orgSignupInfoDao.searchByPurchaseId(coursePurchase.getPurchaseId());
        if (orgSignupInfo == null) {
            orgSignupInfo = new OrgSignupInfo();
            orgSignupInfo.setOrgId(coursePurchase.getOrgId());
            OrgAccount orgAccount = orgAccountDao.getAccountById(coursePurchase.getOrgId().intValue());
            if (orgAccount != null) {
                orgSignupInfo.setOrgNumber(Long.valueOf(orgAccount.getNumber()));
            }
            orgSignupInfo.setStudentName(coursePurchase.getUserName());
            orgSignupInfo.setUserId(coursePurchase.getUserId());
            List<OrgStudent> orgStudents = orgStudentDao.getStudentByUserId(coursePurchase.getUserId(), null);
            if (!orgStudents.isEmpty() && orgStudents.size() > 0) {
                OrgStudent temp = orgStudents.get(orgStudents.size() - 1);
                orgSignupInfo.setMobile(temp.getMobile());
            }
            orgSignupInfo.setOperator("task同步");
            orgSignupInfo.setRemark("coursePruchase");
            orgSignupInfo.setSplitResult(-1);
            orgSignupInfo.setSignupType(SignupType.ONLINE.getCode());
            String payType = coursePurchase.getPayType();
            if (payType != null) {
                String[] payTypeStr = payType.split(":");
                if (payTypeStr != null && payTypeStr.length > 0) {
                    orgSignupInfo.setPayType(Integer.parseInt(payTypeStr[0]));
                }
            }
            Date now = new Date();
            orgSignupInfo.setCreateTime(now);
            orgSignupInfo.setUpdateTime(now);
            orgSignupInfo.setTotalPrices(Math.round(coursePurchase.getTotalPrices() * 100));
            orgSignupInfo.setPurchaseStatus(1);
            orgSignupInfo.setIsDel(DataStatus.NORMAL.getValue());
            orgSignupInfo.setTradeNo(coursePurchase.getPurchaseId());

            orgSignupInfo.setSignupPurchaseId(coursePurchase.getPurchaseId());
            orgSignupInfo.setPayPurchaseId(coursePurchase.getPurchaseId());
            orgSignupInfo.setSourceType(1);//主站班课支付完成同步的报名信息

            log.debug("save orgsignup info =={}", orgSignupInfo);
            orgSignupInfoDao.save(orgSignupInfo);
        }
    }


    private void saveSignUpCourse(CoursePurchase coursePurchase) {
        List<OrgSignupCourse> orgSignupCourses = orgSignupCourseDao.loadByPurchaseId(coursePurchase.getPurchaseId());
        if (orgSignupCourses == null || orgSignupCourses.size() == 0) {
            OrgSignupCourse orgSignupCourse = new OrgSignupCourse();
            orgSignupCourse.setOrgId(coursePurchase.getOrgId());
            orgSignupCourse.setSignupPurchaseId(coursePurchase.getPurchaseId());
            orgSignupCourse.setOrgCourseId(coursePurchase.getCourseId());
            orgSignupCourse.setOrgCourseNumber(coursePurchase.getCourseNumber());
            orgSignupCourse.setOriginPrice((int) Math.round(coursePurchase.getTotalPrices() * 100));
            orgSignupCourse.setCourseDiscount(100);
            orgSignupCourse.setPreferential(0);
            orgSignupCourse.setCount(1);
            orgSignupCourse.setPayPrice(Math.round(coursePurchase.getTotalPrices() * 100));
            orgSignupCourse.setCreateTime(new Date());
            orgSignupCourse.setUpdateTime(new Date());

            log.debug("save orgSignupCourse info =={}", orgSignupCourse);
            orgSignupCourseDao.save(orgSignupCourse);
        }
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }
}
