package com.baijia.tianxiao.biz.service.impl;

import com.baijia.tianxiao.biz.dto.request.QuitClassRequest;
import com.baijia.tianxiao.biz.dto.request.TimesCardRequest;
import com.baijia.tianxiao.biz.dto.response.OrgSignupRefundDto;
import com.baijia.tianxiao.biz.service.RechargeService;
import com.baijia.tianxiao.biz.service.StudentPayService;
import com.baijia.tianxiao.biz.service.TimesCardService;
import com.baijia.tianxiao.constant.finance.PurchaseTimescardStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescard;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescardRefund;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.dto.request.TimesCardRefundRequest;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.TimesCardDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.signup.service.TxTimesCardRefundService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Created by wengshengli on 2017/7/17.
 */
@Service
@Slf4j
public class TimesCardServiceImpl implements TimesCardService {

    @Autowired
    private RechargeService rechargeService;

    @Autowired
    private OrgStudentDao orgStudentDao;

    @Autowired
    private SignupService signupService;

    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;

    @Autowired
    private TxPurchaseTimescardDao txPurchaseTimescardDao;

    @Autowired
    private TxTimesCardRefundService txTimesCardRefundService;

    @Autowired
    private TxPurchaseTimescardRefundDao txPurchaseTimescardRefundDao;

    @Autowired
    private StudentPayService studentPayService;

    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;

    @Override
    public OrgSingupInfoDto timesCardPurchase(TimesCardRequest timesCardRequest) {
        log.info("Times card service params== {}", timesCardRequest);
        FillCourseInfoRequestDto signupInfo = timesCardRequest.buildSignupInfo();
        signupInfo.setTransferClassOrder(TransferClassOrder.TIMESCARD_ORDER.getCode());

        if (signupInfo.getStudentId() != null) {
            OrgStudent orgStudent = orgStudentDao.getById(signupInfo.getStudentId());
            if (orgStudent != null && signupInfo.getStudentMobile().contains("*")) {
                signupInfo.setStudentMobile(orgStudent.getMobile());
            }
            if (signupInfo.getStudentMobile() == null) {
                signupInfo.setStudentMobile(orgStudent.getMobile());
            }
            signupInfo.setStudentName(orgStudent.getName());
        }

        OrgSingupInfoDto result = rechargeService.rechargePurchase(signupInfo);
        TxPurchaseTimescard txPurchaseTimescard = txPurchaseTimescardDao.getBySignupPurchase(result.getOrgId(), result.getSignupPurchaseId());

        return buildDetailDto(result, txPurchaseTimescard);
    }


    @Override
    public OrgSingupInfoDto detail(TimesCardRequest timesCardRequest) {
        OrgSingupInfoDto orgSingupInfoDto = signupService.getCourseInfo(timesCardRequest.getHeaders(), timesCardRequest.getSignupPurchaseId(), timesCardRequest.getOrgId(), timesCardRequest.getCascadeId());
        TxPurchaseTimescard txPurchaseTimescard = txPurchaseTimescardDao.getBySignupPurchase(orgSingupInfoDto.getOrgId(), orgSingupInfoDto.getSignupPurchaseId());

        return buildDetailDto(orgSingupInfoDto, txPurchaseTimescard);
    }

    private OrgSingupInfoDto buildDetailDto(OrgSingupInfoDto orgSingupInfoDto, TxPurchaseTimescard txPurchaseTimescard) {

        if (txPurchaseTimescard != null) {
            orgSingupInfoDto.setTimesCardDto(buildDto(txPurchaseTimescard));
        }
        TxPurchaseTimescardRefund timescardRefund = txPurchaseTimescardRefundDao.getBySignupPurchase(orgSingupInfoDto.getOrgId(), orgSingupInfoDto.getSignupPurchaseId());
        if (timescardRefund != null) {

        }
        log.debug("times card detail = {}", orgSingupInfoDto);
        return orgSingupInfoDto;
    }

    @Override
    public List<TimesCardDto> historyTimesCard(TimesCardRequest timesCardRequest) {
        List<TxPurchaseTimescard> list = txPurchaseTimescardDao.getByStudentId(timesCardRequest.getOrgId(), timesCardRequest.getStudentId(), Arrays.asList(PurchaseTimescardStatus.SUCCESS.getCode()));
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        return buildByTimesCard(list);
    }

    @Override
    public void refund(TimesCardRefundRequest timesCardRefundRequest) {
        TxPurchaseTimescard txPurchaseTimescard = txPurchaseTimescardDao.getBySignupPurchase(timesCardRefundRequest.getOrgId(), timesCardRefundRequest.getSignupPurchaseId());
        if (txPurchaseTimescard != null) {
            timesCardRefundRequest.setStudentId(txPurchaseTimescard.getStudentId());
            timesCardRefundRequest.setUserId(txPurchaseTimescard.getUserId());
            long refundMoneyLong = new Double(timesCardRefundRequest.getRefundMoney() * 100).longValue();
            long refundFee = txPurchaseTimescard.getPayPrice() - refundMoneyLong;
            if (refundFee < 0) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "退款金额大于卡金额");
            }

            timesCardRefundRequest.setRefundMoneyLong(refundMoneyLong);
            timesCardRefundRequest.setRefundFee(refundFee);
            txTimesCardRefundService.saveTimesCardRefund(timesCardRefundRequest);

            //退卡
            txPurchaseTimescardDao.updateStatusByPurchaseId(timesCardRefundRequest.getSignupPurchaseId(), PurchaseTimescardStatus.REFUND.getCode());
        }
    }


    @Override
    public OrgSignupRefundDto refundDetail(Long orgId, QuitClassRequest quitClassRequest) {
        OrgSignupInfo orgSignupInfo = orgSignupInfoDao.getByPurchaseId(orgId, quitClassRequest.getSignupPurchaseId());
        if (orgSignupInfo != null) {
            if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.TIMESCARD_ORDER.getCode()) {
                return buildRefundDetail(orgId, quitClassRequest);
            } else {
                return studentPayService.detailQuitClass(orgId.longValue(), quitClassRequest);
            }
        }
        return null;
    }

    private List<TimesCardDto> buildByTimesCard(List<TxPurchaseTimescard> list) {
        List<TimesCardDto> result = Lists.newArrayList();
        for (TxPurchaseTimescard txPurchaseTimescard : list) {
            result.add(buildDto(txPurchaseTimescard));
        }
        return result;
    }

    private OrgSignupRefundDto buildRefundDetail(Long orgId, QuitClassRequest quitClassRequest) {
        TxPurchaseTimescardRefund timescardRefund = txPurchaseTimescardRefundDao.getBySignupPurchase(orgId, quitClassRequest.getSignupPurchaseId());
        Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIds(orgId);

        OrgSignupRefundDto refundDto = null;
        if (timescardRefund != null) {
            refundDto = new OrgSignupRefundDto();
            refundDto.setRefundMoney(timescardRefund.getRefundPrice().doubleValue() / 100);
            refundDto.setRefundType(timescardRefund.getRefundType());
            refundDto.setRefundTypeStr(SignupRefundType.getNameByCode(timescardRefund.getRefundType()));
            refundDto.setRefundTime(timescardRefund.getCreateTime());
            refundDto.setCascadeIdStr(cascadeMap.get(timescardRefund.getCascadeId().longValue()));
        }
        return refundDto;
    }

    private TimesCardDto buildDto(TxPurchaseTimescard one) {
        TimesCardDto dto = new TimesCardDto();
        dto.setCardNumber(one.getCardNumber());
        dto.setTotalTimes(one.getLessonCount());
        dto.setStartTime(one.getStartTime());
        dto.setEndTime(one.getEndTime());
        dto.setCardRemark(one.getRemark());
        dto.setCreateTime(one.getCreateTime());
        dto.setTotalPrice(one.getPayPrice().doubleValue() / 100);
        dto.setStatus(one.getStatus());

        return dto;
    }
}
