package com.baijia.tianxiao.biz.service;

import com.baijia.tianxiao.biz.dto.request.QuitClassRequest;
import com.baijia.tianxiao.biz.dto.response.*;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.List;

/**
 * Created by wengshengli on 2016/12/5.
 */
public interface StudentPayService {

    /**
     * 学生储值账号支付及取消支付
     * <p>
     * optype=3支付  optype=4取消支付
     *
     * @param signupPurchaseId
     * @param orgId
     * @throws BussinessException
     */
    OrgSignupInfo payByStudentFiannce(Long orgId, Integer cascadeId, Long signupPurchaseId, Integer opType, Double payMoney) throws BussinessException;


    /**
     * 获取学生储值账号余额及该订单已经冻结的金额
     * <p>
     * optype=3支付  optype=4取消支付
     *
     * @param signupPurchaseId
     * @param orgId
     * @throws BussinessException
     */
    StudentSignupFinanceDto getStudentFiannce(Long orgId, Long signupPurchaseId) throws BussinessException;


    /**
     * 取消报名
     *
     * @param orgId
     * @param signupPurchaseId
     */
    void cancelSignupInfo(Long orgId, Integer cascadeId, Long signupPurchaseId);


    /**
     * 获取学生储值账户列表
     *
     * @param orgId
     * @return
     */
    List<StudentFinanceAccountDto> getStudentAccoutByOrgId(Long orgId, String key, PageDto pageDto);

    /**
     * 获取学生储值账号交易记录
     *
     * @param orgId
     * @param studentId
     * @return
     */
    List<StudentFinanceRecordDto> getStudentRecordByStudentId(Long orgId, Long studentId, PageDto pageDto);


    ApplyQuitClassDto getSignupCourseByPurchase(Long orgId, Long signupPurchaseId, Long courseId);

    ApplyQuitClassDto getSignupCourseByStudent(Long orgId, Long userId, Long courseId);

    /**
     * 退订单或退班
     */
    OrgSignupRefundDto confirmQuitClass(Long orgId, QuitClassRequest quitClassRequest);

    /**
     * 根据 机构Number和班级id批量退班
     * @param orgNumber
     * @param classId
     * @return
     */
    boolean batchQuitClassByClassId(Long orgNumber, Long classId, Integer refundType);

    OrgSignupRefundDto detailQuitClass(Long orgId, QuitClassRequest quitClassRequest);


}
