package com.baijia.tianxiao.biz.dto;

import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.NonNull;

import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/9/12
 * Time: 下午8:49
 * To change this template use File | Settings | File Templates.
 */
@Data
public class SplitPurchaseDto implements Serializable {

    private static final long serialVersionUID = -8096652848321738572L;

    private Long purchase_id;

    private Long course_number;

    private Long user_id;

    private Double pay_money;

    public static class Builder {

        private Long courseNumber;

        private Double payPrice;

        private Long purchaseId;

        private Long userId;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder setCourseNumber(Long courseNumber) {
            Preconditions.checkArgument(courseNumber != null && !courseNumber.equals(0), "must have course number");
            this.courseNumber = courseNumber;
            return this;
        }

        public Builder setPayPrice(Long payPrice) {
            Preconditions.checkArgument(payPrice != null, "pay Price can not be null");
            this.payPrice = payPrice.doubleValue() / 100;
            return this;
        }

        public Builder setPurchaseId(@NonNull Long purchaseId) {
            Preconditions.checkArgument(purchaseId != null && !purchaseId.equals(0), "must have purchase id");
            this.purchaseId = purchaseId;
            return this;
        }

        public Builder setUserId(@NonNull Long userId) {
            Preconditions.checkArgument(userId != null && !userId.equals(0), "must have user id");
            this.userId = userId;
            return this;
        }

        public SplitPurchaseDto build() {
            SplitPurchaseDto splitPurchaseDto = new SplitPurchaseDto();
            splitPurchaseDto.setCourse_number(courseNumber);
            splitPurchaseDto.setPay_money(payPrice);
            splitPurchaseDto.setPurchase_id(this.purchaseId);
            splitPurchaseDto.setUser_id(userId);
            return splitPurchaseDto;
        }

        /**
         * @param payPrice2
         * @return
         */
        public Builder setPayPrice(Double payPrice) {
            Preconditions.checkArgument(payPrice != null, "pay Price can not be null");
            this.payPrice = payPrice.doubleValue();
            return this;
        }

    }
}
