/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.service.impl;

import com.baijia.tianxiao.biz.dto.response.SignupStudentDto;
import com.baijia.tianxiao.biz.service.RechargeService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.SignupStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseRechargeDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.image.AvatarUtil;
import com.baijia.tianxiao.sal.organization.constant.OrgSinupPurchaseStatus;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.signup.service.TxPurchaseRechargeService;
import com.baijia.tianxiao.sal.signup.service.TxPurchaseTimescardService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.util.DigitUppercaseUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RechargeServiceImpl
implements RechargeService {
    private static final Logger log = LoggerFactory.getLogger(RechargeServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private SignupService signupService;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private TxPurchaseRechargeDao txPurchaseRechargeDao;
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private TxPurchaseRechargeService txPurchaseRechargeService;
    @Autowired
    private TxPurchaseTimescardService txPurchaseTimescardService;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgStudentTagService orgStudentTagService;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private TxStudentFinanceAccountDao txStudentFinanceAccountDao;

    @Override
    public SignupStudentDto updateStudent(FillCourseInfoRequestDto signupInfo) {
        Long userId = this.signupService.getStudent(signupInfo);
        SignupStudentDto result = new SignupStudentDto();
        if (userId != null && userId.intValue() > 0) {
            TxStudentFinanceAccount txStudentFinanceAccount;
            OrgStorage storage;
            OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(signupInfo.getOrgId(), userId, new String[0]);
            result = SignupStudentDto.buildByStudnet(orgStudent);
            if (orgStudent != null && orgStudent.getAvatar() != null && (storage = this.orgStorageDao.getById(orgStudent.getAvatar().intValue())) != null) {
                String url = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
                result.setStudentAvatar(url);
            }
            if (result.getStudentAvatar() == null) {
                result.setStudentAvatar(AvatarUtil.getUserAvatar((long)(orgStudent == null ? 0L : orgStudent.getId())));
            }
            if (orgStudent != null && (txStudentFinanceAccount = this.txStudentFinanceAccountDao.getFinanceAccount(signupInfo.getOrgId(), orgStudent.getId())) != null) {
                result.setStudentBalance(txStudentFinanceAccount.getBalance().doubleValue() / 100.0);
            }
        }
        return result;
    }

    @Override
    public OrgSingupInfoDto rechargePurchase(FillCourseInfoRequestDto fillCourseInfoRequestDto) {
        Preconditions.checkNotNull((Object)fillCourseInfoRequestDto.getOrgId(), (Object)"orgId may not be null");
        fillCourseInfoRequestDto.setOrgNumber(this.getOrgNumber(fillCourseInfoRequestDto.getOrgId()));
        Preconditions.checkNotNull((Object)fillCourseInfoRequestDto.getOrgNumber(), (Object)"orgNumber may not be null");
        Long orgId = fillCourseInfoRequestDto.getOrgId();
        Long orgNumber = fillCourseInfoRequestDto.getOrgNumber();
        log.info("signUp--> orgId {}, signupPurchaseId {}", (Object)orgId, (Object)fillCourseInfoRequestDto.getSignupPurchaseId());
        if (fillCourseInfoRequestDto.getTxPurchaseTimescard() != null && fillCourseInfoRequestDto.getTxPurchaseTimescard().getLessonCount() != null && (fillCourseInfoRequestDto.getTxPurchaseTimescard().getLessonCount() > 10000 || fillCourseInfoRequestDto.getTxPurchaseTimescard().getLessonCount() < -1)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5408\u540c\u6b21\u6570\u8fc7\u5927");
        }
        OrgSingupInfoDto dto = null;
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.POS_CARD.getCode()) {
            if (!this.signupService.isPurchaseSucce(fillCourseInfoRequestDto.getSignupPurchaseId(), orgId, fillCourseInfoRequestDto.getCascadeId())) {
                throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_NOT_SUCCEED);
            }
            dto = this.rechargeAfterPay(fillCourseInfoRequestDto, orgId, orgNumber);
            return dto;
        }
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.FRONTED.getCode()) {
            dto = this.rechargeBeforePay(fillCourseInfoRequestDto, orgId, orgNumber);
            return dto;
        }
        throw new BussinessException((UniverseErrorCode)SignupErrorCode.UNKNOWN_PURCHASE_STATUS);
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    private OrgSingupInfoDto rechargeBeforePay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId, Long orgNumber) throws BussinessException {
        double totalPrice = fillCourseInfoRequestDto.getTotalPrice();
        if ((totalPrice = new BigDecimal(totalPrice).setScale(2, RoundingMode.HALF_UP).doubleValue()) > 100000.0 || totalPrice <= 0.0) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TOTALPRICE_ERROR, SignupErrorCode.TOTALPRICE_ERROR.getMessage());
        }
        long begin = System.currentTimeMillis();
        Long purchaseId = RestUtils.getPurchaseId((Long)orgId, (Double)totalPrice, (Collection)fillCourseInfoRequestDto.getHeaders());
        String tradeNo = RestUtils.getTradeNo((Long)orgId, (Long)purchaseId, (Double)totalPrice, (Collection)fillCourseInfoRequestDto.getHeaders());
        long end = System.currentTimeMillis();
        log.info("getPurchaseId--> {}\uff0ccost time={}", (Object)purchaseId, (Object)(end - begin));
        OrgSignupInfo orgSignupInfo = new OrgSignupInfo();
        orgSignupInfo.setStudentPayPrice(Long.valueOf(0L));
        orgSignupInfo.setStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        orgSignupInfo.setCreateTime(new Date());
        orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
        this.fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
        orgSignupInfo.setSignupPurchaseId(purchaseId);
        orgSignupInfo.setPayPurchaseId(purchaseId);
        orgSignupInfo.setTradeNo(Long.valueOf(Long.parseLong(tradeNo)));
        orgSignupInfo.setTotalPrices(Long.valueOf(NumberUtil.multiply((Number)fillCourseInfoRequestDto.getTotalPrice(), (BigDecimal)SignupService.HUNDRED, (int)0).longValue()));
        orgSignupInfo.setHeaders(fillCourseInfoRequestDto.getHeaders());
        orgSignupInfo.setSourceType(Integer.valueOf(fillCourseInfoRequestDto.getSourceType()));
        orgSignupInfo.setOrderType(Integer.valueOf(fillCourseInfoRequestDto.getTransferClassOrder()));
        orgSignupInfo.setTxPurchaseTimescard(fillCourseInfoRequestDto.getTxPurchaseTimescard());
        this.saveOrUpdateSignupInfo(orgSignupInfo, true);
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, fillCourseInfoRequestDto.getCascadeId());
        return this.buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);
    }

    private OrgSingupInfoDto rechargeAfterPay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId, Long orgNumber) throws BussinessException {
        OrgSignupInfo orgSignupInfo = null;
        if (fillCourseInfoRequestDto.getSignupPurchaseId() != null) {
            orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId(), true, new String[0]);
        }
        if (orgSignupInfo == null || orgSignupInfo.getSignupType() != 0) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASEID_ERROR);
        }
        if (orgSignupInfo != null && orgSignupInfo.getSplitResult().intValue() == SplitCourseResult.SUCCESS.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.COURCE_CHANGE);
        }
        if (orgSignupInfo.getSplitResult() >= SplitCourseResult.PENDING.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.REPEAT_SUBMIT);
        }
        this.fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
        orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
        if (orgSignupInfo.getPayType().intValue() == PayType.CASH.getCode()) {
            orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.SUCCESS.getCode()));
        } else {
            orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
        }
        orgSignupInfo.setSourceType(Integer.valueOf(fillCourseInfoRequestDto.getSourceType()));
        this.saveOrUpdateSignupInfo(orgSignupInfo, true);
        orgSignupInfo.setPurchaseStatus(Integer.valueOf(PayResult.SUCCESS.getCode()));
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, fillCourseInfoRequestDto.getCascadeId());
        return this.buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);
    }

    private void fillOrgSignupInfo(FillCourseInfoRequestDto fillCourseInfoRequestDto, OrgSignupInfo orgSignupInfo, Long orgId, Long orgNumber) throws BussinessException {
        long begin = System.currentTimeMillis();
        Long stuUserId = this.signupService.getStudent(fillCourseInfoRequestDto);
        long end = System.currentTimeMillis();
        log.debug("-->    getStudent cost{}", (Object)(end - begin));
        orgSignupInfo.setUserId(stuUserId);
        orgSignupInfo.setStudentId(fillCourseInfoRequestDto.getStudentId());
        orgSignupInfo.setOrgId(orgId);
        orgSignupInfo.setOrgNumber(orgNumber);
        orgSignupInfo.setMobile(fillCourseInfoRequestDto.getStudentMobile());
        orgSignupInfo.setStudentName(fillCourseInfoRequestDto.getStudentName());
        orgSignupInfo.setOrderType(Integer.valueOf(fillCourseInfoRequestDto.getTransferClassOrder()));
        if (orgSignupInfo.getPayType() == null) {
            orgSignupInfo.setPayType(Integer.valueOf(PayType.PAY_POS_CARD.getCode()));
        }
        orgSignupInfo.setRemark(StringUtils.isEmpty((String)fillCourseInfoRequestDto.getRemark()) ? orgSignupInfo.getRemark() : fillCourseInfoRequestDto.getRemark());
        orgSignupInfo.setRemark(orgSignupInfo.getRemark() == null ? "" : orgSignupInfo.getRemark());
        orgSignupInfo.setOperator("");
        orgSignupInfo.setUpdateTime(new Date());
        orgSignupInfo.setSignupType(Integer.valueOf(fillCourseInfoRequestDto.getSignupType()));
        if (orgSignupInfo.getCascadeId() == null || orgSignupInfo.getCascadeId() == 0) {
            orgSignupInfo.setCascadeId(Integer.valueOf(fillCourseInfoRequestDto.getCascadeId() == null ? 0 : fillCourseInfoRequestDto.getCascadeId()));
        }
    }

    private void saveOrUpdateSignupInfo(@NonNull OrgSignupInfo signupInfo, boolean saveRechargeInfo) {
        if (signupInfo == null) {
            throw new NullPointerException("signupInfo");
        }
        if (signupInfo.getSourceType() == null || signupInfo.getSourceType() == 0) {
            signupInfo.setSourceType(SignupSourceType.TX_SIANGUP.getCode());
        }
        if (signupInfo.getId() != null && signupInfo.getId() > 0L) {
            this.orgSignupInfoDao.update((Object)signupInfo, new String[0]);
        } else {
            this.orgSignupInfoDao.save((Object)signupInfo, new String[0]);
        }
        if (saveRechargeInfo) {
            try {
                if (signupInfo.getOrderType().intValue() == TransferClassOrder.RECHARGE_ORDER.getCode()) {
                    this.txPurchaseRechargeService.saveRechargeBySignupinfo(signupInfo);
                }
                if (signupInfo.getOrderType().intValue() == TransferClassOrder.TIMESCARD_ORDER.getCode()) {
                    this.txPurchaseTimescardService.saveTimesCardBySignupinfo(signupInfo);
                }
            }
            catch (Exception e) {
                log.warn("\u6570\u636e\u91cd\u590d\u3002e = {}", (Throwable)e);
            }
        }
    }

    private OrgSingupInfoDto buildOrgSignupInfoDto(OrgSignupInfo orgSignupInfo, boolean isShowMobile) {
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgSignupInfo.getOrgId());
        OrgSingupInfoDto dto = new OrgSingupInfoDto();
        if (orgSignupInfo != null) {
            dto.setTotalPrice(Double.valueOf(orgSignupInfo.getTotalPrices().doubleValue() / 100.0));
            this.fillPayType(dto, orgSignupInfo);
            dto.setStudentPayPrice(Double.valueOf(orgSignupInfo.getStudentPayPrice().doubleValue() / 100.0));
            dto.setRealTotalMoney(dto.getTotalPrice());
            dto.setOrgId(orgSignupInfo.getOrgId());
            if (dto.getSignupType().intValue() == SignupType.FRONTED.getCode()) {
                dto.setSignUpTime(orgSignupInfo.getCreateTime());
            } else {
                dto.setSignUpTime(orgSignupInfo.getUpdateTime());
            }
            if (orgSignupInfo.getPurchaseStatus().intValue() == OrgSinupPurchaseStatus.DEAL_DONE.getCode().intValue()) {
                dto.setPayTime(orgSignupInfo.getPayTime());
                String cascadeIdStr = (String)cascadeMap.get(orgSignupInfo.getCascadeId() == null ? 0L : orgSignupInfo.getCascadeId().longValue());
                dto.setCascadeIdStr(cascadeIdStr == null ? "" : cascadeIdStr);
            } else {
                dto.setCascadeIdStr("--");
            }
            log.info("orgSignupInfo is:{} ", (Object)orgSignupInfo);
            int signupStatus = 0;
            dto.setTransferClassOrder(orgSignupInfo.getOrderType().intValue());
            dto.setOrderType(orgSignupInfo.getOrderType().intValue());
            if (dto.getOrderType() != TransferClassOrder.TRANSFER_ORDER.getCode()) {
                dto.setShowTotalPrice(Double.valueOf((double)(orgSignupInfo.getTotalPrices() + orgSignupInfo.getStudentPayPrice()) / 100.0));
                dto.setChinesePrice(DigitUppercaseUtils.digitUppercase((double)dto.getShowTotalPrice()));
                dto.setPurchaseEndTime(orgSignupInfo.getCreateTime() == null ? null : DateUtil.getDiffDateTime((Date)orgSignupInfo.getCreateTime(), (int)7));
                dto.setOpType(0);
            }
            if (dto.getPayResult() == PayResult.SUCCESS.getCode()) {
                dto.setOpType(0);
            }
            log.info("signupStatus is:{} ", (Object)signupStatus);
            dto.setSignupPurchaseId(orgSignupInfo.getSignupPurchaseId());
            dto.setPayPurchaseId(orgSignupInfo.getPayPurchaseId() == 0L ? orgSignupInfo.getSignupPurchaseId() : orgSignupInfo.getPayPurchaseId());
            dto.setCreateTime(orgSignupInfo.getCreateTime());
            dto.setUpdateTime(orgSignupInfo.getUpdateTime());
            dto.setCourseInfos((List)Lists.newArrayList());
            dto.setId(orgSignupInfo.getId());
            if (orgSignupInfo.getStatus().intValue() == DeleteStatus.DELETED.getValue()) {
                dto.setStatus(Integer.valueOf(SignupStatus.CANCEL.getCode()));
                dto.setOpType(0);
            } else {
                dto.setStatus(Integer.valueOf(orgSignupInfo.getPurchaseStatus()), Integer.valueOf(orgSignupInfo.getSplitResult()));
            }
            String remark = "\u65e0";
            if (StringUtils.isNotBlank((String)orgSignupInfo.getRemark())) {
                remark = orgSignupInfo.getRemark();
            }
            if (orgSignupInfo.getTradeNo() != null && orgSignupInfo.getTradeNo() != 0L) {
                dto.setTradeNo(orgSignupInfo.getTradeNo().toString());
            } else {
                dto.setTradeNo(orgSignupInfo.getSignupPurchaseId().toString());
            }
            if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getHeaders()) && orgSignupInfo.getTotalPrices().doubleValue() > 0.0) {
                String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl((Long)orgSignupInfo.getSignupPurchaseId(), (Long)orgSignupInfo.getOrgId(), (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), (Collection)orgSignupInfo.getHeaders());
                dto.setPayUrlWinxin(payUrlWinxin);
            }
            dto.setRemark(remark);
            dto.setOperator(orgSignupInfo.getOperator());
        }
        return dto;
    }

    private void fillPayType(OrgSingupInfoDto dto, OrgSignupInfo orgSignupInfo) {
        int payType = PayType.getCodeByPayType((int)orgSignupInfo.getPayType());
        if (payType == PayType.CASH.getCode()) {
            dto.setCashPayPrice(dto.getTotalPrice());
        } else if (payType == PayType.PAY_POS_CARD.getCode()) {
            dto.setPosPayPrice(dto.getTotalPrice());
        } else {
            dto.setOnlinePayPrice(dto.getTotalPrice());
        }
        dto.setSourceType(orgSignupInfo.getSourceType().intValue() == SignupSourceType.TX_SIANGUP.getCode().intValue() ? SignupSourceType.SIGNUP.getCode() : orgSignupInfo.getSourceType());
        dto.setPayResultEnum(PayResult.getPayResultByCode((Integer)orgSignupInfo.getPurchaseStatus()));
        dto.setPayTypeEnum(PayType.getPayTypeByCode((Integer)orgSignupInfo.getPayType()));
        dto.setSignupTypeEnum(SignupType.getTypeByCode((Integer)orgSignupInfo.getSignupType()));
    }
}

