/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dto;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import lombok.NonNull;

public class SplitPurchaseDto
implements Serializable {
    private static final long serialVersionUID = -8096652848321738572L;
    private Long purchase_id;
    private Long course_number;
    private Long user_id;
    private Double pay_money;

    public Long getPurchase_id() {
        return this.purchase_id;
    }

    public Long getCourse_number() {
        return this.course_number;
    }

    public Long getUser_id() {
        return this.user_id;
    }

    public Double getPay_money() {
        return this.pay_money;
    }

    public void setPurchase_id(Long purchase_id) {
        this.purchase_id = purchase_id;
    }

    public void setCourse_number(Long course_number) {
        this.course_number = course_number;
    }

    public void setUser_id(Long user_id) {
        this.user_id = user_id;
    }

    public void setPay_money(Double pay_money) {
        this.pay_money = pay_money;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SplitPurchaseDto)) {
            return false;
        }
        SplitPurchaseDto other = (SplitPurchaseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$purchase_id = this.getPurchase_id();
        Long other$purchase_id = other.getPurchase_id();
        if (this$purchase_id == null ? other$purchase_id != null : !((Object)this$purchase_id).equals(other$purchase_id)) {
            return false;
        }
        Long this$course_number = this.getCourse_number();
        Long other$course_number = other.getCourse_number();
        if (this$course_number == null ? other$course_number != null : !((Object)this$course_number).equals(other$course_number)) {
            return false;
        }
        Long this$user_id = this.getUser_id();
        Long other$user_id = other.getUser_id();
        if (this$user_id == null ? other$user_id != null : !((Object)this$user_id).equals(other$user_id)) {
            return false;
        }
        Double this$pay_money = this.getPay_money();
        Double other$pay_money = other.getPay_money();
        return !(this$pay_money == null ? other$pay_money != null : !((Object)this$pay_money).equals(other$pay_money));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SplitPurchaseDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $purchase_id = this.getPurchase_id();
        result = result * 59 + ($purchase_id == null ? 43 : ((Object)$purchase_id).hashCode());
        Long $course_number = this.getCourse_number();
        result = result * 59 + ($course_number == null ? 43 : ((Object)$course_number).hashCode());
        Long $user_id = this.getUser_id();
        result = result * 59 + ($user_id == null ? 43 : ((Object)$user_id).hashCode());
        Double $pay_money = this.getPay_money();
        result = result * 59 + ($pay_money == null ? 43 : ((Object)$pay_money).hashCode());
        return result;
    }

    public String toString() {
        return "SplitPurchaseDto(purchase_id=" + this.getPurchase_id() + ", course_number=" + this.getCourse_number() + ", user_id=" + this.getUser_id() + ", pay_money=" + this.getPay_money() + ")";
    }

    public static class Builder {
        private Long courseNumber;
        private Double payPrice;
        private Long purchaseId;
        private Long userId;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder setCourseNumber(Long courseNumber) {
            Preconditions.checkArgument((courseNumber != null && !courseNumber.equals(0) ? 1 : 0) != 0, (Object)"must have course number");
            this.courseNumber = courseNumber;
            return this;
        }

        public Builder setPayPrice(Long payPrice) {
            Preconditions.checkArgument((payPrice != null ? 1 : 0) != 0, (Object)"pay Price can not be null");
            this.payPrice = payPrice.doubleValue() / 100.0;
            return this;
        }

        public Builder setPurchaseId(@NonNull Long purchaseId) {
            if (purchaseId == null) {
                throw new NullPointerException("purchaseId");
            }
            Preconditions.checkArgument((purchaseId != null && !purchaseId.equals(0) ? 1 : 0) != 0, (Object)"must have purchase id");
            this.purchaseId = purchaseId;
            return this;
        }

        public Builder setUserId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId");
            }
            Preconditions.checkArgument((userId != null && !userId.equals(0) ? 1 : 0) != 0, (Object)"must have user id");
            this.userId = userId;
            return this;
        }

        public SplitPurchaseDto build() {
            SplitPurchaseDto splitPurchaseDto = new SplitPurchaseDto();
            splitPurchaseDto.setCourse_number(this.courseNumber);
            splitPurchaseDto.setPay_money(this.payPrice);
            splitPurchaseDto.setPurchase_id(this.purchaseId);
            splitPurchaseDto.setUser_id(this.userId);
            return splitPurchaseDto;
        }

        public Builder setPayPrice(Double payPrice) {
            Preconditions.checkArgument((payPrice != null ? 1 : 0) != 0, (Object)"pay Price can not be null");
            this.payPrice = (double)payPrice;
            return this;
        }
    }
}

