package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpTo;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/6/30 Time: 下午4:45 To change this template use File | Settings
 * | File Templates.
 */
@Service("syncTransferRefundService")
@Slf4j
public class SyncTransferRefundServiceImpl implements SyncPayService {
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    @Resource
    private OrgFinanceAccountService orgFinanceAccountService;

    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;

    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;

    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;

    @Autowired
    private TXStudentCommentAPIService tXStudentCommentAPIService;

    @Resource
    private TxTransferClassRecordDao txTransferClassRecordDao;

    @Resource
    private TxTransferClassInfoDao txTransferClassInfoDao;

    private AtomicBoolean transferRefundFlag = new AtomicBoolean(false);

    @Override
    public void sync() {

        TxMsgSyncTimestamp syncInfo = getSyncInfo(MsgSyncType.SYNC_TRANSFER_REFUND);
        try {
            if (!transferRefundFlag.get()) {
                log.info("sync transferRefundFlag :{}", syncInfo);
                transferRefundFlag.set(true);
                syncTransferRefundDay(syncInfo);
                transferRefundFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            transferRefundFlag.set(false);
        }
        log.info("save sync transferRefundFlag info:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }

    private void syncTransferRefundDay(TxMsgSyncTimestamp syncInfo) {
        List<TxTransferClassRecord> transferClassRecords =
                txTransferClassRecordDao.getOrgTransferRefundListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100);

        log.info("save transferClassRecords:{} success", transferClassRecords.size());

        if (CollectionUtils.isNotEmpty(transferClassRecords)) {
            for (TxTransferClassRecord txTransferClassRecord : transferClassRecords) {
                try {
                    if (txTransferClassRecord.getUpdateTime().after(syncInfo.getSyncTime())) {
                        syncInfo.setSyncTime(txTransferClassRecord.getUpdateTime());
                    }

                    TxTransferClassInfo txTransferClassInfo = txTransferClassInfoDao.getByTransferNumber(txTransferClassRecord.getTransferNumber());
                    if (txTransferClassInfo == null) {
                        return;
                    }

                    /**
                     * 直接机构退现金的才同步收支
                     */
                    if ((txTransferClassRecord.getRefundType().intValue() == SignupRefundType.BY_ORG_CASH.getCode())
                            && txTransferClassRecord.getRefundMoney().longValue() > 0) {
                        saveFinanceInfo(txTransferClassRecord, txTransferClassInfo);
                        saveFinanceRecordDay(txTransferClassRecord, txTransferClassInfo);
                    }

                    /**
                     * 同步到学生储蓄账户的同步学生的记录
                     */
                    if (txTransferClassRecord.getRefundType().intValue() == SignupRefundType.BY_STUDENT_ACCOUNT.getCode()) {
                        String opInfo = "转班";
                        if (txTransferClassRecord.getRefundMoney().longValue() > 0) {
                            txStudentFinanceAccountService.changeStudentFiannceAccount(txTransferClassInfo.getOrgId(),
                                    txTransferClassInfo.getCascadeId(), txTransferClassInfo.getStudentId(), StudentFiannceOpType.TRANSFER_REFUND,
                                    txTransferClassRecord.getRefundMoney().longValue(), opInfo, txTransferClassRecord.getInPurchaseId() + "");
                        }
                        this.tXStudentCommentAPIService.saveByStudentFinanceRecord(txTransferClassInfo.getStudentId(),
                                txTransferClassRecord.getRefundMoney().longValue(), opInfo,
                                StudentFiannceOpType.TRANSFER_REFUND.getCode(), FinanceOpTo.INCOME.getCode());
                    }

                    /**
                     * 设置回状态，防止重复操作
                     */
                    txTransferClassRecord.setSyncRefund(DataStatus.DELETE.getValue());
                    txTransferClassRecordDao.update(txTransferClassRecord, "syncRefund");

                } catch (Exception e) {
                    log.warn("sync finance record fail {}", e);
                }
            }
        }
    }

    private void saveFinanceInfo(TxTransferClassRecord txTransferClassRecord, TxTransferClassInfo txTransferClassInfo) {
        int opTo = 2;// 退款


        OrgFinanceAccountRecord orgFinanceAccountRecord =
                orgFinanceAccountService.getAccountRecordInfo(txTransferClassInfo.getOrgId(), txTransferClassRecord.getUpdateTime());


        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        txFinanceInfo.setOrgId(txTransferClassInfo.getOrgId());
        txFinanceInfo.setCreateTime(txTransferClassRecord.getUpdateTime());
        txFinanceInfo.setCurrBalance(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrBalance());
        txFinanceInfo
                .setCurrFreezeMoney(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrFreezeMoney());
        txFinanceInfo.setExpectedEarning(
                orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrExpectedEarning());
        txFinanceInfo.setOpMoney(txTransferClassRecord.getRefundMoney().doubleValue() / 100);
        txFinanceInfo.setOpType(FinanceOpType.DRAWBACK.getCode());
        txFinanceInfo.setPayType(PayType.CASH.getCode());
        txFinanceInfo.setPurchaseId(txTransferClassRecord.getOutPurchaseId() + "");
        txFinanceInfo.setCourseId(txTransferClassRecord.getTransferOutClassId());

        txFinanceInfo.setOpInfo("转班");
        txFinanceInfo.setOpTo(opTo);

        log.debug("saveFinanceInfo={}", txFinanceInfo);
        txFinanceInfoDao.save(txFinanceInfo);
    }

    private void saveFinanceRecordDay(TxTransferClassRecord txTransferClassRecord, TxTransferClassInfo txTransferClassInfo) {
        int opType = PayType.CASH.getCode();
        int opTo = 2;// 退款
        String mdate = DateUtil.getStrByDate(txTransferClassRecord.getUpdateTime());


        TxFinanceRecordDay txFinanceRecordDay =
                txFinanceRecordDayDao.getByDayType(txTransferClassInfo.getOrgId(), mdate, opType, opTo);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(txTransferClassInfo.getOrgId());
            txFinanceRecordDay.setMdate(txTransferClassRecord.getUpdateTime());
            txFinanceRecordDay.setOpCount(1);
            txFinanceRecordDay.setOpPrice(txTransferClassRecord.getRefundMoney().doubleValue() / 100);
            txFinanceRecordDay.setOpType(opType);
            txFinanceRecordDay.setOpTo(opTo);
        } else {
            txFinanceRecordDay
                    .setOpPrice(txFinanceRecordDay.getOpPrice() + txTransferClassRecord.getRefundMoney().doubleValue() / 100);
            txFinanceRecordDay.setOpCount(txFinanceRecordDay.getOpCount() + 1);
        }

        log.debug("saveFinanceRecordDay={}", txFinanceRecordDay);
        txFinanceRecordDayDao.saveOrUpdate(txFinanceRecordDay);
    }


    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }

}
