package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpTo;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * 报名信息到记录表
 */
@Service("syncSignupRecordService")
@Slf4j
public class SyncSignupRecordServiceImpl implements SyncPayService {

    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private TxSignupRecordDayDao txSignupRecordDayDao;

    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;

    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private CoursePurchaseDao coursePurchaseDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgFinanceAccountService orgFinanceAccountService;

    private AtomicBoolean signupRecordFlag = new AtomicBoolean(false);

    @Override
    public void sync() {

        TxMsgSyncTimestamp syncInfo = getSyncInfo(MsgSyncType.CW_SIGNUP_RECORD);
        try {
            if (!signupRecordFlag.get()) {
                log.info("sync cw signuprecord iosinfo :{}", syncInfo);
                signupRecordFlag.set(true);
                Thread.sleep(20 * 1000);//休息20s减少同时读
                syncSignupRecordDay(syncInfo);
                signupRecordFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            signupRecordFlag.set(false);
        }
        log.info("save sync info:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }

    private void syncSignupRecordDay(TxMsgSyncTimestamp syncInfo) {
        List<OrgSignupInfo> signupInfos =
                orgSignupInfoDao.getOrgSignupListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100);

        log.info("syncSignupRecordDay: result=={} success", signupInfos);

        if (CollectionUtils.isNotEmpty(signupInfos)) {
            for (OrgSignupInfo orgSignupInfo : signupInfos) {
                log.info("syncSignupRecordDay: before=={} success", orgSignupInfo);
                try {
                    Date tempSyncTime = syncInfo.getSyncTime();
                    if (orgSignupInfo.getUpdateTime().after(syncInfo.getSyncTime())) {
                        syncInfo.setSyncTime(orgSignupInfo.getUpdateTime());
                    }
                    if (orgSignupInfo.getFinanceSync().intValue() == 1) {
                        continue;
                    }
                    if (orgSignupInfo.getPayTime() == null) {
                        continue;
                    }
                    // 没支付成的
                    if (orgSignupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode()) {
                        continue;
                    }

                    // 没报名完成的
                    if (orgSignupInfo.getSplitResult().intValue() != SplitCourseResult.SUCCESS.getCode()) {
                        continue;
                    }

                    //普通订单0元单子 不处理
                    if (orgSignupInfo.getTransferClassOrder().intValue() == TransferClassOrder.NORMAL_ORDER.getCode()
                            && orgSignupInfo.getStudentPayPrice() + orgSignupInfo.getTotalPrices() == 0) {
                        continue;
                    }

                    //转班订单不退且不补的 不处理
                    if (orgSignupInfo.getTransferClassOrder().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()
                            && orgSignupInfo.getStudentPayPrice() + orgSignupInfo.getTotalPrices() == 0
                            && orgSignupInfo.getTransferRefundMoney() == 0) {
                        continue;
                    }

                    List<OrgSignupCourse> orgSignupCourses =
                            orgSignupCourseDao.loadByPurchaseId(orgSignupInfo.getSignupPurchaseId());
                    if (CollectionUtils.isEmpty(orgSignupCourses)) {//获取不到说明主从延迟,等会处理
                        syncInfo.setSyncTime(tempSyncTime);
                        break;
                    }
                    orgSignupInfo.setOrgSignupCourses(orgSignupCourses);

                    saveSignupRecordDay(orgSignupInfo, FinanceOpTo.INCOME.getCode());
                    if (orgSignupInfo.getTransferClassOrder().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()
                            && orgSignupInfo.getTransferRefundMoney().longValue() > 0) {
                        saveSignupRecordDay(orgSignupInfo, FinanceOpTo.EXPEND.getCode());
                    }

                    if (orgSignupInfo.getPayType() == PayType.CASH.getCode()
                            && orgSignupInfo.getStudentPayPrice() + orgSignupInfo.getTotalPrices() > 0) {
                        saveFinanceInfo(orgSignupInfo);
                        saveFinanceRecordDay(orgSignupInfo);
                    }
                    orgSignupInfo.setFinanceSync(1);// 同步过了财务记录
                    orgSignupInfoDao.update(orgSignupInfo, "financeSync");
                    log.info("syncSignupRecordDay:after=={} success", orgSignupInfo);
                } catch (Exception e) {
                    log.warn("sync finance record fail {}", e);
                }
            }
        }

    }

    private void saveFinanceInfo(OrgSignupInfo orgSignupInfo) {
        int opTo = 1;// 报名
        //由访问数据表改为调用支付
        OrgFinanceAccountRecord orgFinanceAccountRecord = orgFinanceAccountService.getAccountRecordInfo(orgSignupInfo.getOrgId(), orgSignupInfo.getCreateTime());
        if (CollectionUtils.isNotEmpty(orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                OrgCourse orgCourse = orgCourseDao.getByCourseId(orgSignupCourse.getOrgCourseId());
                TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
                txFinanceInfo.setOrgId(orgSignupInfo.getOrgId());
                txFinanceInfo.setCreateTime(orgSignupInfo.getPayTime());

                txFinanceInfo
                        .setCurrBalance(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrBalance());
                txFinanceInfo.setCurrFreezeMoney(
                        orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrFreezeMoney());
                txFinanceInfo.setExpectedEarning(
                        orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrExpectedEarning());
                txFinanceInfo.setOpMoney(orgSignupCourse.getPayPrice().doubleValue() / 100);
                txFinanceInfo.setOpType(FinanceOpType.BAOMING.getCode());
                txFinanceInfo.setPayType(PayType.CASH.getCode());
                txFinanceInfo.setPurchaseId(orgSignupInfo.getSignupPurchaseId() + "");
                txFinanceInfo.setCourseId(orgCourse.getId());

                StringBuffer opinfo = new StringBuffer();
                opinfo.append(orgCourse != null ? orgCourse.getName() : "").append(" ");
                opinfo.append("学生:").append(orgSignupInfo.getStudentName()).append(" ");

                txFinanceInfo.setOpInfo(opinfo.toString());
                txFinanceInfo.setOpTo(opTo);

                log.debug("saveFinanceInfo={}", txFinanceInfo);
                txFinanceInfoDao.save(txFinanceInfo);
            }
        }
    }

    private void saveFinanceRecordDay(OrgSignupInfo orgSignupInfo) {
        int opType = PayType.CASH.getCode();
        int opTo = 1;// 报名
        String mdate = DateUtil.getStrByDate(orgSignupInfo.getPayTime());

        TxFinanceRecordDay txFinanceRecordDay =
                txFinanceRecordDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, opType, opTo);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(orgSignupInfo.getOrgId());
            txFinanceRecordDay.setMdate(orgSignupInfo.getPayTime());

            txFinanceRecordDay.setOpPrice(orgSignupInfo.getTotalPrices().doubleValue() / 100);
            txFinanceRecordDay.setOpType(opType);
            txFinanceRecordDay.setOpTo(opTo);
        } else {
            txFinanceRecordDay
                    .setOpPrice(txFinanceRecordDay.getOpPrice() + orgSignupInfo.getTotalPrices().doubleValue() / 100);
        }

        txFinanceRecordDay
                .setOpCount(txFinanceRecordDay.getOpCount() + (orgSignupInfo.getOrgSignupCourses() == null ? 0 : orgSignupInfo.getOrgSignupCourses().size()));

        log.debug("saveFinanceRecordDay={}", txFinanceRecordDay);
        txFinanceRecordDayDao.saveOrUpdate(txFinanceRecordDay);
    }

    private void saveSignupRecordDay(OrgSignupInfo orgSignupInfo, int opTo) {
        int opType = orgSignupInfo.getSourceType();
        String mdate = DateUtil.getStrByDate(orgSignupInfo.getPayTime());
        double opPrice = 0d;
        if (opTo == FinanceOpTo.INCOME.getCode()) {
            opPrice = (orgSignupInfo.getTotalPrices().doubleValue() + orgSignupInfo.getStudentPayPrice().doubleValue() + orgSignupInfo.getTransferClassMoney().doubleValue()) / 100;
        } else {
            opPrice = orgSignupInfo.getTransferRefundMoney().doubleValue() / 100;
        }

        TxSignupRecordDay txSignupRecordDay =
                txSignupRecordDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, opType, opTo);
        if (txSignupRecordDay == null) {
            txSignupRecordDay = new TxSignupRecordDay();
            txSignupRecordDay.setOrgId(orgSignupInfo.getOrgId());
            txSignupRecordDay.setMdate(orgSignupInfo.getPayTime());

            txSignupRecordDay.setOpPrice(opPrice);
            txSignupRecordDay.setOpType(opType);
            txSignupRecordDay.setOpTo(opTo);
        } else {
            txSignupRecordDay
                    .setOpPrice(txSignupRecordDay.getOpPrice() + opPrice);
        }
        for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
            CoursePurchase coursePurchase = coursePurchaseDao
                    .getByPurcahseIdCourse(orgSignupCourse.getSignupPurchaseId(), orgSignupCourse.getOrgCourseId());
            if (coursePurchase != null) {
                txSignupRecordDay.setPoundage(txSignupRecordDay.getPoundage() + coursePurchase.getPoundage());
            }
        }
        txSignupRecordDay
                .setOpCount(txSignupRecordDay.getOpCount() + (orgSignupInfo.getOrgSignupCourses() == null ? 0 : orgSignupInfo.getOrgSignupCourses().size()));

        log.debug("saveSignupRecordDay={}", txSignupRecordDay);
        txSignupRecordDayDao.saveOrUpdate(txSignupRecordDay);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }

}
