package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.signup.service.TransferClassInfoService;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 15分钟自动取消没有转班的报名记录
 */
@Service("syncCancelTransferClassService")
@Slf4j
public class SyncCancelTransferClassServiceImpl implements SyncPayService {

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private OrgSignupCourseService orgSignupCourseService;

    @Resource
    private SignupService signupService;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;

    @Resource
    private TransferClassInfoService transferClassInfoService;

    @Override
    public void sync() {

        Date last15Min = DateUtil.getDiffMinute(new Date(), -15);
        List<OrgSignupInfo> signupInfos =
                orgSignupInfoDao.getNeedCannelPurchases(TransferClassOrder.TRANSFER_ORDER, last15Min);

        log.info("syncCancelTransferClassService: signupInfos=={} success", signupInfos);

        if (CollectionUtils.isNotEmpty(signupInfos)) {
            for (OrgSignupInfo orgSignupInfo : signupInfos) {

                signupService.cancelSignupInfo(orgSignupInfo.getSignupPurchaseId(), orgSignupInfo.getOrgId());

                if (orgSignupInfo.getStudentPayPrice() != null && orgSignupInfo.getStudentPayPrice().longValue() > 0) {

                    OrgStudent orgStudent = orgStudentDao.getStudentByUserId(orgSignupInfo.getOrgId(), orgSignupInfo.getUserId());
                    if (orgStudent == null) {
                        log.error("SyncCancelSignupServiceImpl  not find student =={}", orgSignupInfo);
                    }

                    String opInfo = orgSignupCourseService.getSignupCourseName(orgSignupInfo.getOrgId(), orgSignupInfo.getSignupPurchaseId());

                    txStudentFinanceAccountService.changeStudentFiannceAccount(orgSignupInfo.getOrgId(), -1, orgStudent.getId(), StudentFiannceOpType.PAY_CANCEL, orgSignupInfo.getStudentPayPrice(), opInfo, "");
                }

                transferClassInfoService.cancelTransferClassByPurchase(orgSignupInfo.getSignupPurchaseId());

            }
        }
    }

}