package com.baijia.tianxiao.biz.service;

import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.biz.dto.request.TransferClassDetailRequest;
import com.baijia.tianxiao.biz.dto.response.TransferClassDetailResponse;
import com.baijia.tianxiao.biz.dto.response.TransferClassResponse;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.signup.dto.request.TransferClassRequest;
import com.baijia.tianxiao.sal.signup.dto.response.TransferClassListDto;

/**
 * Created by wengshengli on 2017/4/21.
 */
public interface TransferClassService {

    /**
     * 转班报名
     *
     * @param transferClassRequest
     * @return
     * @throws BussinessException
     */
    TransferClassResponse signup(TransferClassRequest transferClassRequest);

    /**
     * 转班退款
     *
     * @param orgId
     * @param inSignupPurchaseId
     * @param refundType
     */
    void refund(Long orgId, Long inSignupPurchaseId, Integer refundType);

    /**
     * 转班列表
     *
     * @param orgId
     * @param signupPurchaseId
     * @param classId
     * @return
     */
    List<TransferClassListDto> list(Long orgId, Long signupPurchaseId, Long classId);

    /**
     * 转班详情
     *
     * @param orgId
     * @param detailRequest
     * @return
     */
    TransferClassDetailResponse detail(Long orgId, TransferClassDetailRequest detailRequest);

    /**
     * 检查是否有未完成的转班
     *
     * @param orgId
     * @param classId
     * @param studentId
     * @return
     */
    Map<String, Object> check(Long orgId, Long classId, Long studentId);

}
