/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterInfoDto;
import com.baijia.tianxiao.biz.erp.service.PersonalCenterService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBaseInfoDto;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.dto.smstoken.TeacherSmsTokenDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.organization.dto.OrgSelectionDto;
import com.baijia.tianxiao.sal.wechat.api.FreeVersionService;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
@Slf4j
@Service
public class PersonalCenterServiceImpl implements PersonalCenterService{

	@Autowired
	private FreeVersionService freeVersionService;
	@Autowired
	private OrgAccountDao orgAccountDao;
	@Autowired
	private OrgWechatOpenIdRecordDao orgWechatOpenIdRecordDao;
	@Autowired
	private OrgInfoDao orgInfoDao;
	@Autowired 
	private AuthorizationInfoDao authorizationInfoDao;
	
	@Override
	public void fillStudentCenterInfoDto(StudentCenterInfoDto dto, String sms_token) throws Exception {
		if(dto==null || StringUtils.isBlank(sms_token)){
			log.error("wrong param dto:{},wechatAppId:{}",dto, sms_token);
			return;
		}
		StudentSmsTokenDto token = StudentSmsTokenDto.fromTokenStr(sms_token);
		Long orgId = token.getOrgId();
		String wechatAppId = token.getWechatAppId();
		String openId = token.getOpenId();

		OrgAccount orgAccount = orgAccountDao.getAccountById(orgId.intValue());
		String websiteFmt = "%si/%s";
		websiteFmt = String.format(websiteFmt, WechatProperties.getWebMTianXiaoUrlPrefix(), orgAccount.getNumber());
		
		dto.setWebsite(websiteFmt);
		dto.setOrgId(orgId);
		
		if(wechatAppId!=null && freeVersionService.isFreeAccount(wechatAppId.toString())){
			dto.setFromFV(Flag.TRUE.getInt());
			dto.setImsite( WechatWebAuthLinkBuilder.imSite(WebAuthScope.BASE, wechatAppId.toString(), sms_token));
			
			List<OrgWechatOpenIdRecord> records = orgWechatOpenIdRecordDao.listBy(wechatAppId, openId, WechatOpenIdEntityType.STUDENT);
			
			if(CollectionUtils.isNotEmpty(records)){
				List<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
				OrgSelectionDto orgSelectionDto = null;
				Map<Long,Integer> counterMap = new HashMap<Long,Integer>();
				
				for(OrgWechatOpenIdRecord record:records){
					if( counterMap.get(record.getOrgId().longValue()) != null){
						continue;
					}else{
						counterMap.put(record.getOrgId().longValue(), Flag.TRUE.getInt());
						if(authorizationInfoDao.getByOrgId(record.getOrgId().intValue())!=null){
							continue;
						}
						
					}
					orgSelectionDto = new OrgSelectionDto();
					OrgBaseInfoDto orgInfo = orgInfoDao.getBaseInfo(record.getOrgId().intValue());
					orgSelectionDto.setShortName(orgInfo.getShortName());
					orgSelectionDto.setOrgId(orgInfo.getOrgId().longValue());
					orgSelectionDto.setUrl( WechatWebAuthLinkBuilder.studentCenter(WebAuthScope.BASE, record.getAuthorizerAppId(), record.getOrgId()) );
					list.add(orgSelectionDto);
				}
				dto.setOrgList(list);
			}
		}
		
	}
	
	
	
	@Override
	public void fillTeacherCenterInfoDto(TeacherResponseDto dto, String sms_token) throws Exception {
		if(dto==null || StringUtils.isBlank(sms_token)){
			log.error("wrong param dto:{},wechatAppId:{}",dto, sms_token);
			return;
		}
		TeacherSmsTokenDto token = TeacherSmsTokenDto.fromTokenStr(sms_token);
		Long orgId = token.getOrgId();
		String wechatAppId = token.getWechatAppId();
		String openId = token.getOpenId();
		

		OrgAccount orgAccount = orgAccountDao.getAccountById(orgId.intValue());
		String websiteFmt = "%si/%s";
		websiteFmt = String.format(websiteFmt,WechatProperties.getWebMTianXiaoUrlPrefix(), orgAccount.getNumber());
		
		dto.setWebsite(websiteFmt);
		dto.setOrgId(orgId);
		
		
		if(wechatAppId!=null && freeVersionService.isFreeAccount(wechatAppId.toString())){
			dto.setFromFV(Flag.TRUE.getInt());
			//dto.setImsite( WechatWebAuthLinkBuilder.imSite(WebAuthScope.BASE, wechatAppId.toString(), sms_token));
			
			List<OrgWechatOpenIdRecord> records = orgWechatOpenIdRecordDao.listBy(wechatAppId, openId, WechatOpenIdEntityType.TEACHER);
			if(CollectionUtils.isNotEmpty(records)){
				List<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
				OrgSelectionDto orgSelectionDto = null;
				Map<Long,Integer> counterMap = new HashMap<Long,Integer>();
				
				for(OrgWechatOpenIdRecord record:records){
					if( counterMap.get(record.getOrgId().longValue()) != null){
						continue;
					}else{
						counterMap.put(record.getOrgId().longValue(), Flag.TRUE.getInt());
						if(authorizationInfoDao.getByOrgId(record.getOrgId().intValue())!=null){
							continue;
						}
					}
					
					orgSelectionDto = new OrgSelectionDto();
					OrgBaseInfoDto orgInfo = orgInfoDao.getBaseInfo(record.getOrgId().intValue());
					orgSelectionDto.setShortName(orgInfo.getShortName());
					orgSelectionDto.setOrgId(orgInfo.getOrgId().longValue());
					orgSelectionDto.setUrl( WechatWebAuthLinkBuilder.teacherCenter(WebAuthScope.BASE, record.getAuthorizerAppId(), record.getOrgId()) );
					list.add(orgSelectionDto);
				}
				dto.setOrgList(list);
			}
		}	
	}

}
