
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.CourseSigninRecordDto;
import com.baijia.tianxiao.biz.erp.dto.CourseSigninRecordDto.StudentSigninRecord;
import com.baijia.tianxiao.biz.erp.dto.CourseSigninStsDto;
import com.baijia.tianxiao.biz.erp.dto.CourseSigninStsDto.StudentSigninSts;
import com.baijia.tianxiao.biz.erp.dto.request.FastSignInLesssonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.FastSignInViewCourseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.StudentSigninRecordDto;
import com.baijia.tianxiao.biz.erp.dto.response.StudentSigninRecordDto.CourseSigninResult;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.service.ErpSignInService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.course.po.OrgCoursePhoto;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title ErpSignInServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年7月23日
 * @version 1.0
 */
@Service("erpSignInService")
@Slf4j
public class ErpSignInServiceImpl implements ErpSignInService {
    @Resource
    private OrgAccountDao orgAccountDao ;

    @Resource 
    private TXCascadeAccountDao txCascadeAccountDao;

    @Resource
    private OrgCourseListService orgCourseListService;
    
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
  
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    
    @Resource
    private StorageDao storageDao;
    
    @Resource
    private OrgStudentDao orgStudentDao;
    
    @Resource
    private OrgCourseDao orgCourseDao;
    
    @Resource
    private CourseLessonService courseLessonService;
    
    @Resource
    private OrgLessonSignService orgLessonSignService;
    
    @Resource
    private CourseStudentService courseStudentService;
    
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    
    @Resource
    private TeacherDao teacherDao;
    
    @Resource
    private OrgCourseConsumeRuleService orgCourseConsumeRuleService;
    
    @Override
    public FastSignInViewCourseDto getSignInCourseInfo(Long orgId, Long courseId) {
        OrgCourse course = this.orgCourseDao.getById(courseId);
        if(course != null){
            List<OrgCourse> list = new ArrayList<OrgCourse>();
            list.add(course);
            List<FastSignInViewCourseDto> dtoList = getSignInCourseInfoList(orgId,list);
            if(dtoList.size()>0){
                return dtoList.get(0);
            }
        }
        throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程id无效");

    }


    private List<OrgLessonSign> queryEfectLessonSignBatch(List<Long> courseIds){
        
        List<OrgLessonSign> list = orgLessonSignDao.getCourseLessonSignIn(courseIds);
        
        return list;
        
    }
    
    private Map<Long,Integer> findCourseLessonSignInCountMap(List<OrgLessonSign> list){
        Map<Long,Integer> map = Maps.newHashMap();
        Set<Long> lessonSet = new HashSet<Long>();
        for(OrgLessonSign orgLessonSign:list){
            if(orgLessonSign.getStatus() !=null &&orgLessonSign.getStatus()>0){
                Long courseId = orgLessonSign.getCourseId();
                Long lessonId = orgLessonSign.getLessonId();
                if(!lessonSet.contains(lessonId)){
                	lessonSet.add(lessonId);
                    Integer count = map.get(courseId);
                    if(count == null){
                        count = new Integer(0);
                        map.put(courseId, count);
                    }
                    count++;
                    map.put(courseId, count);
                }
            }
        }
        return map;
    }
    
    private Map<Long,Integer> findLessonSignInCountMap(List<OrgLessonSign> list){
        Map<Long,Integer> map = Maps.newHashMap();
        for(OrgLessonSign orgLessonSign:list){
            if(orgLessonSign.getStatus() !=null &&orgLessonSign.getStatus()>0){
                Long lessonId = orgLessonSign.getLessonId();
                Integer count = map.get(lessonId);
                if(count == null){
                    count = new Integer(0);
                    map.put(lessonId, count);
                }
                count++;
                map.put(lessonId, count);
            }
        }
        return map;
    }
    
    @Override
    public List<FastSignInViewCourseDto> getSignInCourseInfoList(Long orgId,List<OrgCourse> orgCourseList) {
       
        List<FastSignInViewCourseDto> dtoList = Lists.newArrayList();
        Set<Long> courseIdSet = Sets.newHashSet();
        for(OrgCourse couse:orgCourseList){
            courseIdSet.add(couse.getId());
        }
        List<Long> courseIds = new ArrayList<Long>(courseIdSet);
        Map<Integer, String> coverMap = orgCourseListService.getCoverMap(orgCourseList);
        Map<Long,OrgCoursePhoto> coursePhotoMap = orgCourseListService.getPhoteMap(courseIds);
        Map<Long, Integer> studentCountMap = courseStudentService.getCourseStudentCntMap(orgId,courseIds,false);
        List<OrgLessonSign> signList = queryEfectLessonSignBatch(courseIds);
        Map<Long,Integer> courseLessonSignInCount = findCourseLessonSignInCountMap(signList);
        
        for(OrgCourse course:orgCourseList){
            
            FastSignInViewCourseDto dto = new FastSignInViewCourseDto();
            
            dto.setOrgCourseId(course.getId());
            dto.setCourseName(course.getName());
            dto.setCourseCount(course.getFreq());
            dto.setMaxStudent(course.getMaxStudent());
            dto.setStudentCount(studentCountMap.get(course.getId()));
            Integer signCount = courseLessonSignInCount.get(course.getId());
            dto.setSignCount(signCount);
            dto.setCoverUrl(coverMap.get(course.getCover()));
            OrgCoursePhoto coursePhoto = coursePhotoMap.get(course.getId());
            if(coursePhoto!=null && StringUtils.isNotBlank(coursePhoto.getCutUrl())){
                dto.setCoverUrl(coursePhoto.getCutUrl());
            }
            dtoList.add(dto);
        }
        return dtoList;
            
    }
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<Long> batchCreateLessonsAndSignIn(FastSignInLesssonsRequestDto dto){
        List<Long> lessonIds  = courseLessonService.addClassLessonsBatchForFastSignIn(dto.getOrgId(),dto.getCourseId(),dto.getLessonTimes(),dto.getStudentSignStatusMap().keySet());
        if(lessonIds!=null &&lessonIds.size()==dto.getLessonTimes()){
            orgLessonSignService.orgStudentLessonBatchFastSign(dto.getOrgId(), dto.getCourseId(), lessonIds, dto.getStudentSignStatusMap());
        }else{
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "新建课节数目不匹配");
        }
        
        return lessonIds;
    }
    
   
    
   
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<LessonResponseDto> getCourseLessonSignInRecord(Long orgId,Long courseId){
        OrgCourse course = this.orgCourseDao.getById(courseId);
        if(course == null){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程id无效");
        }
      /*  if(course.getOrgNumber().longValue() != orgId){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程id无效");
        }*/
        
        List<Long> courseIds = new ArrayList<Long>();
        courseIds.add(courseId);
        List<OrgClassLesson>  lessonList = orgClassLessonDao.queryLessons(orgId, courseIds, null, null, null, null, null);
        
        //获取课节基本信息
        List<LessonResponseDto>  lessonResponList = courseLessonService.buildLessonBaseInfoList(orgId,courseId,lessonList);
        
        //获取课节签到信息
        List<OrgLessonSign> signList = queryEfectLessonSignBatch(courseIds);
        Map<Long,Integer> courseLessonSignInCount = findLessonSignInCountMap(signList);
        List<Long> lessonIds = Lists.newArrayList();
        for(OrgClassLesson lesson:lessonList){
            lessonIds.add(lesson.getId());
        }
        //获取课节学生数
        Map<Long, Integer> studentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
        
        
        for(LessonResponseDto dto:lessonResponList){
            Long lessonId = dto.getLessonId();
            Integer signCount = courseLessonSignInCount.get(lessonId);
            Integer studentCount = studentCountMap.get(lessonId);
            dto.setSignCount(signCount!=null?signCount:0);
            dto.setStudentCount(studentCount !=null?studentCount:0);
        }
        return lessonResponList;
        
    }
    
    /**
     * 获取课程封面urlmap
     *
     * @param courses
     */
    private Map<Integer, String> getCoverMap(List<OrgCourse> courses) {
        Collection<Integer> coverList = CollectorUtil.collect(courses, new Function<OrgCourse, Integer>() {
            @Override
            public Integer apply(OrgCourse arg0) {
                return arg0.getCover();
            }
        });
        List<Storage> storages = this.storageDao.getByIds(coverList);
        return CollectorUtil.collectMap(storages, new Function<Storage, Integer>() {
            @Override
            public Integer apply(Storage arg0) {
                return arg0.getId().intValue();
            }
        }, new Function<Storage, String>() {
            @Override
            public String apply(Storage arg0) {
                if (StringUtils.isNotBlank(arg0.getAttach_url())) {
                    return arg0.getAttach_url();
                }
                return StorageUtil.constructUrl(arg0.getFid(), arg0.getMimetype(), arg0.getSn());
            }
        });
    }
    
    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? number.longValue() : null;
    }
	
    /**
     * 课程搜素
     *
     * @param courses
     */
	public List<FastSignInViewCourseDto> getCourseInfo(Long orgId, String searchName, Integer limit) {
		log.info("searchName = {}", searchName);
        Preconditions.checkArgument(searchName != null && ! searchName.isEmpty(), "orgId invalid!");   
        Long orgNumber = getOrgNumber(orgId);      
        List<Long> courseIds = null;
        // 登录帐号为子帐号，并且是员工帐号，并且排课权限打开时，只能查看自己作为班主任的课节
        // 涉及到分页，这里取courseIds时，按照时间倒序，测试时需要关注数据是否取全
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", courseIds);
                List<Long> tempIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId());
                log.debug("user cascadeId={},courseIds={}",TianxiaoMContext.getTXCascadeId(),tempIds);
                
                log.debug("after set courseIds:{}", courseIds);
                if(CollectionUtils.isEmpty(tempIds)){
                    return Collections.EMPTY_LIST;
                }else{
                    courseIds = tempIds;
                }
            }
        } 
        
        List<OrgCourse> orgCourseList = orgCourseDao.getCourseByOrgNumberAndCourseName(orgNumber, searchName, null, courseIds, limit);
        
        List<FastSignInViewCourseDto> fastSignViewCourseDtoList = getSignInCourseInfoList(orgId,orgCourseList);
        
        
        return fastSignViewCourseDtoList;
	}
	
    /**
     * 学员姓名搜索
     *
     * @param courses
     */
	public List<FastSignInViewCourseDto> getStudentInfo(Long orgId, String searchName, Integer limit) {
		Long orgNumber = getOrgNumber(orgId);
        //包含该学员的班级
 //       List<OrgStudent> orgStudents = orgStudentDao.getStudents(orgId, searchName, null, null, null);
		List<OrgStudent> orgStudents = orgStudentDao.getStudentByOrgIdAndCourseName(orgId, searchName);
        Set<Long> orgStudentCoursesIds = Sets.newHashSet();
        
        //每一个学生的排课情况
        Set<Long> userIds = Sets.newHashSet();
        for(OrgStudent orgStudent: orgStudents) {
        	userIds.add(orgStudent.getUserId());
        }
        List<OrgStudentCourse> orgStudentCourses = null;
        if(userIds.size() > 0) {
        	orgStudentCourses = orgStudentCourseDao.getOrgStudentCourseByUserIds(orgId, userIds);
        	userIds.removeAll(userIds);
            for (int j = 0; j < orgStudentCourses.size(); j++) {
            	
            	userIds.add(orgStudentCourses.get(j).getUserId());//对于没有排课的不进行搜索
            	orgStudentCoursesIds.add(orgStudentCourses.get(j).getCourseId());
    		} 
        }  
        
        List<Long> courseIds = null;
        // 登录帐号为子帐号，并且是员工帐号，并且排课权限打开时，只能查看自己作为班主任的课节
        // 涉及到分页，这里取courseIds时，按照时间倒序，测试时需要关注数据是否取全
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", courseIds);
                List<Long> tempIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId());
                log.debug("user cascadeId={},courseIds={}",TianxiaoMContext.getTXCascadeId(),tempIds);
                if(CollectionUtils.isEmpty(tempIds)){
                    return Collections.EMPTY_LIST;
                }else{
                    courseIds = tempIds;
                }
                
            }
            
            
        } 
        if(courseIds!=null){
            orgStudentCoursesIds.retainAll(courseIds);
        }
       
        
        //学生姓名
        Map<Long, List<Long>> courseStudentUserIdMap = orgStudentCourseDao.getStudentIdMapBycourseIdsNoStatus(orgStudentCoursesIds, orgId);
        List<Long> orgIds = Lists.newArrayList();
        orgIds.add(orgId);
        
        List<OrgStudent> orgStudentsList = orgStudentDao.getStudentsByUserIdsAndOrgIds(orgIds, userIds);
        Map<Long, String> orgStudentsMap = Maps.newHashMap();
        Map<Long, List<String>> courseStudentNameMap = Maps.newHashMap();
        for(OrgStudent stu:orgStudentsList){
        	orgStudentsMap.put(stu.getUserId(), stu.getName());
        }
        for(Long courseId:orgStudentCoursesIds) {
        	List<Long> courseUserIds = courseStudentUserIdMap.get(courseId);
        	List<Long> tempUserIds = new ArrayList<Long>(courseUserIds);
        	tempUserIds.retainAll(userIds);
        	
        	List<String> studentNameList = Lists.newArrayList();
        	for(Long userId:tempUserIds){
        		String name = orgStudentsMap.get(userId);
        		if(StringUtils.isNotBlank(name)){
        			studentNameList.add(name);
        		}	
        	}
        	courseStudentNameMap.put(courseId, studentNameList);
        	
		}
		
        //每个学生的所有课程
        List<OrgCourse> orgCourseList = Lists.newArrayList();
        if (orgStudentCoursesIds.size() > 0) {
        	orgCourseList = orgCourseDao.getCourseByOrgNumberAndCourseName(orgNumber, null, null, orgStudentCoursesIds, limit);
		}
        List<FastSignInViewCourseDto> fastSignViewCourseDtoList = getSignInCourseInfoList(orgId,orgCourseList);
        
        for(FastSignInViewCourseDto dto:fastSignViewCourseDtoList){
            Long courseId = dto.getOrgCourseId();
            List<String> studentNameList =courseStudentNameMap.get(courseId);
            dto.setStudentNames(studentNameList);
        }
        return fastSignViewCourseDtoList;
	}
	
	public CourseSigninStsDto queryCourseStudentSignInInfoDto(Long orgId,Long courseId){
	    OrgCourse course = this.orgCourseDao.getById(courseId);
        if(course == null){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程id无效");
        }
     
        List<Long> courseIds = new ArrayList<Long>();
        courseIds.add(courseId);
        List<OrgClassLesson>  lessonList = orgClassLessonDao.queryLessons(orgId, courseIds, null, null, null, null, null);
        
        //获取课节基本信息
        List<LessonResponseDto>  lessonResponList = courseLessonService.buildLessonBaseInfoList(orgId,courseId,lessonList);
        
        List<Long> userIds = orgStudentCourseDao.getStudents(orgId, courseId);
        
        Map<Long, OrgStudent> studentMap = orgStudentDao.getStudentMap(userIds, orgId);
        //获取课节签到信息
        List<OrgLessonSign> signList = queryEfectLessonSignBatch(courseIds);
        
        CourseSigninStsDto dto = new CourseSigninStsDto();
        dto.setCourseId(courseId);
        dto.setPlanNum(course.getFreq());
        dto.setCourseName(course.getName());
        dto.setLessonCourseList(lessonResponList);
        dto.setLessonNum(lessonResponList.size());
        List<StudentSigninSts> studentSigninStsList = new ArrayList<StudentSigninSts>();
        dto.setStudentSigninStsList(studentSigninStsList);
        
        Map<Long,StudentSigninSts> studentSigninCountMap = new HashMap<Long,StudentSigninSts>();
       
        Map<String,Integer> studentSignStatusMap = new HashMap<String,Integer>();
        dto.setSignInStatusMap(studentSignStatusMap);
        for(OrgLessonSign lessonSign:signList){
            studentSignStatusMap.put(lessonSign.getLessonId()+"|"+lessonSign.getUserId(), lessonSign.getStatus());
            Long userId = lessonSign.getUserId();
            StudentSigninSts sts = studentSigninCountMap.get(userId);
            if(sts == null){
                sts = new StudentSigninSts();
                sts.setUserId(userId);
                
                studentSigninCountMap.put(userId,sts);
            }
            
            if(lessonSign.getStatus()==1){
                sts.setSignedCount(sts.getSignedCount()+1);
                sts.setSignCount(sts.getSignCount()+1);
            }else if(lessonSign.getStatus()==2){
                sts.setLeaveCount(sts.getLeaveCount()+1);
                sts.setSignCount(sts.getSignCount()+1);
            }else if(lessonSign.getStatus()==3){
                sts.setAbsentCount(sts.getAbsentCount()+1);
                sts.setSignCount(sts.getSignCount()+1);
            }
        }
        
        for(OrgStudent orgStudent:studentMap.values()){
            Long userId = orgStudent.getUserId();
            StudentSigninSts sts =studentSigninCountMap.get(userId);
            if(sts!=null){
                sts.setStudentName(orgStudent.getName());
            }else{
                sts = new StudentSigninSts();
                sts.setUserId(userId);
                sts.setStudentName(orgStudent.getName());
            }
            studentSigninStsList.add(sts);
        }
        
        return dto;
        
	}
	
	public CourseSigninRecordDto queryCourseStudentSignInDetailsDto(Long orgId,Long courseId) {
	    OrgCourse course = this.orgCourseDao.getById(courseId);
        if(course == null){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程id无效");
        }
     
        List<Long> courseIds = new ArrayList<Long>();
        courseIds.add(courseId);
        List<OrgClassLesson>  lessonList = orgClassLessonDao.queryLessons(orgId, courseIds, null, null, null, null, null);
        
        //获取课节基本信息
        List<LessonResponseDto>  lessonResponList = courseLessonService.buildLessonBaseInfoList(orgId,courseId,lessonList);
        
        List<Long> lessonIds = new ArrayList<Long>();
        for(LessonResponseDto lesson:lessonResponList){
            lessonIds.add(lesson.getLessonId());
        }
        
        List<Long> userIds = orgStudentCourseDao.getStudents(orgId, courseId);
        
        Map<Long, OrgStudent> studentMap = orgStudentDao.getStudentMap(userIds, orgId);
        //获取课节签到信息
        List<OrgLessonSign> signList = queryEfectLessonSignBatch(courseIds);
        
        CourseSigninRecordDto dto = new CourseSigninRecordDto();
        dto.setCourseId(courseId);
        dto.setCourseName(course.getName());
        dto.setPlanNum(course.getFreq());
        dto.setLessonCourseList(lessonResponList);
        dto.setLessonNum(lessonResponList.size());
        List<StudentSigninRecord> studentSigninRecordList = new ArrayList<StudentSigninRecord>();
        dto.setStudentSigninRecordList(studentSigninRecordList);
        
        Map<Long,StudentSigninRecord> studentSigninCountMap = new HashMap<Long,StudentSigninRecord>();
        
        Map<String,Integer> studentSignStatusMap = new HashMap<String,Integer>();
        dto.setSignInStatusMap(studentSignStatusMap);
        Set<String> studentLessonSet = Sets.newHashSet();
        dto.setStudentLessonSet(studentLessonSet);

        Map<Long, List<Long>> userIdsLessonMap= orgStudentLessonDao.getLessonIdsOfStudents(orgId, userIds, lessonIds);
        for (Long userId : userIdsLessonMap.keySet()) {
            List<Long> lessons = userIdsLessonMap.get(userId);
            for (Long lessonId : lessons) {
                studentLessonSet.add((String.valueOf(lessonId+"|"+userId)));
            }
        }
        
        for(OrgLessonSign lessonSign:signList){
            studentSignStatusMap.put(lessonSign.getLessonId()+"|"+lessonSign.getUserId(), lessonSign.getStatus());
            Long userId = lessonSign.getUserId();
            StudentSigninRecord sts = studentSigninCountMap.get(userId);
            if(sts == null){
                sts = new StudentSigninRecord();
                sts.setUserId(userId);
                
                studentSigninCountMap.put(userId,sts);
            }
            
            if(lessonSign.getStatus()==1){
                sts.setSignedCount(sts.getSignedCount()+1);
                sts.setSignCount(sts.getSignCount()+1);
            }else if(lessonSign.getStatus()==2){
                sts.setLeaveCount(sts.getLeaveCount()+1);
                sts.setSignCount(sts.getSignCount()+1);
            }else if(lessonSign.getStatus()==3){
                sts.setAbsentCount(sts.getAbsentCount()+1);
                sts.setSignCount(sts.getSignCount()+1);
            }
            //sts.setArrangeCount(userIdsLessonMap.get(userId).size());
        }

        
        for(OrgStudent orgStudent:studentMap.values()){
            Long userId = orgStudent.getUserId();
            StudentSigninRecord ssr =studentSigninCountMap.get(userId);
            if(ssr!=null){
                ssr.setStudentName(orgStudent.getName());
            }else{
                ssr = new StudentSigninRecord();
                ssr.setUserId(userId);
                ssr.setStudentName(orgStudent.getName());
            }
            studentSigninRecordList.add(ssr);
        }
   
        return dto;
	}
	
    private Map<Long, List<OrgLessonSign>> getUserIdLessonSignMap(List<OrgLessonSign> signList) {
        return CollectorUtil.group(signList, new Function<OrgLessonSign, Long>() {
            @Override
            public Long apply(OrgLessonSign arg0) {
                return arg0.getUserId();
            }
        }, new Function<OrgLessonSign, OrgLessonSign>() {
            @Override
            public OrgLessonSign apply(OrgLessonSign arg0) {
                return arg0;
            }
        });
    }
    
    private Map<Long, Integer> toLessonSignMap(List<OrgLessonSign> signList) {
        Map<Long, Integer> lessonSignMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(signList)) {
            return Collections.emptyMap();
        }
        for (OrgLessonSign sign : signList) {
            lessonSignMap.put(sign.getLessonId(), sign.getStatus());
        }
        return lessonSignMap;
    }
	
	public StudentSigninRecordDto queryStudentSignInDetailsDto(Long orgId,Long studentId) {
	    OrgStudent student = this.orgStudentDao.getStudentByUserId(orgId, studentId)  ;
	    if(student == null){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "学生id无效");
        }
        StudentSigninRecordDto dto = new StudentSigninRecordDto();
        dto.setStudentId(studentId);
        dto.setStudentName(student.getName());        
        Long userId = student.getUserId();
        List<Long> userIds  = Lists.newArrayList();
        userIds.add(userId);
        List<OrgStudentCourse> orgStudentCourses = orgStudentCourseDao.getStudentListByStudentId(studentId);

        List<Long> courseIds = new ArrayList<Long>();
        for (OrgStudentCourse orgStudentCourse : orgStudentCourses) {
        	courseIds.add(orgStudentCourse.getCourseId());
		}
        Map<Long,OrgCourse> courseIdNameMap = orgCourseDao.getOrgCourseMap(courseIds);
        List<OrgClassLesson>  lessonList = orgClassLessonDao.queryLessons(orgId, courseIds, null, null, null, null, null);
        
        //1.获取课节基本信息
        Map<Long, List<LessonResponseDto>> lessonCourseListMap = new HashMap<Long, List<LessonResponseDto>>();
        
        //List<LessonResponseDto>  lessonResponList = courseLessonService.buildLessonBaseInfoList(orgId,null,lessonList);
        List<Long> lessonIds = new ArrayList<Long>();
        for(OrgClassLesson lesson:lessonList){
            Long lessonId = lesson.getId();
            lessonIds.add(lessonId);
            Long courseId = lesson.getCourseId();
            List<LessonResponseDto>  courseLessonList = lessonCourseListMap.get(courseId);
            if(courseLessonList == null){
                courseLessonList = Lists.newArrayList();
                lessonCourseListMap.put(courseId, courseLessonList);
            }
            LessonResponseDto lessonDto = new LessonResponseDto();
            lessonDto.setCourseId(lesson.getCourseId());
            lessonDto.setLessonId(lesson.getId());
            lessonDto.setIndex(lesson.getNumber());
            lessonDto.setLessonStartTime(lesson.getStartTime());
            lessonDto.setLessonEndTime(lesson.getEndTime());
            courseLessonList.add(lessonDto);
        }
        
        
        
        
        //2获取课节签到信息
        List<OrgLessonSign> lessonSignList = orgLessonSignDao.getStudentSign(orgId, userId,
            UserRole.STUDENT.getRole(), lessonIds, "lessonId","userId","updateTime", "status");
        Map<String,OrgLessonSign> studentSignStatusMap = new HashMap<String,OrgLessonSign>();
        for(OrgLessonSign lessonSign:lessonSignList){
            studentSignStatusMap.put(lessonSign.getLessonId()+"|"+lessonSign.getUserId(), lessonSign);
            
        }
        dto.setSignInStatusMap(studentSignStatusMap);
        
        //获取学生排课信息
        Set<String> studentLessonSet = Sets.newHashSet();
        dto.setStudentLessonSet(studentLessonSet);
        Map<Long, List<Long>> userIdsLessonMap= orgStudentLessonDao.getLessonIdsOfStudents(orgId, userIds, lessonIds);
        for (Long tempuserId : userIdsLessonMap.keySet()) {
            List<Long> lessons = userIdsLessonMap.get(tempuserId);
            for (Long lessonId : lessons) {
                String tempKey = String.valueOf(lessonId+"|"+tempuserId);
                studentLessonSet.add(tempKey);
                
            }
        }
        List<CourseSigninResult> courseSigninResultList = Lists.newArrayList();
        dto.setCourseSigninResultList(courseSigninResultList);
        Date now = new Date();
        Map<Long, List<LessonResponseDto>> lessonCourseListMapNew = new HashMap<Long, List<LessonResponseDto>>();
        dto.setLessonCourseListMap(lessonCourseListMapNew);
        
        for(Long courseId:lessonCourseListMap.keySet()){
            List<LessonResponseDto> tempLessonDtoList = new ArrayList<LessonResponseDto>();
            lessonCourseListMapNew.put(courseId, tempLessonDtoList);
            
            OrgCourseConsumeRule rule = orgCourseConsumeRuleService.getRuleByCourseId(orgId, courseId);
            
            CourseSigninResult signinResult = new CourseSigninResult();
            courseSigninResultList.add(signinResult);
            OrgCourse course = courseIdNameMap.get(courseId);
            signinResult.setCourseId(courseId);
            signinResult.setCourseName(course.getName());
            signinResult.setPlanCount(course.getFreq());
            signinResult.setCourseConsumeRuleStr(rule.getRuleDesc());
            signinResult.setCourseConsumeRuleValue(rule.getRuleValue());
            boolean timeEndConsume = false;
            if(signinResult.getCourseConsumeRuleValue()==null||signinResult.getCourseConsumeRuleValue()==0){
                timeEndConsume = true;
            }
            int arrangeCount = 0;
            int signedCount = 0;
            int leaveCount = 0;
            int absentCount = 0;
            int endCount = 0;
            for(LessonResponseDto lesson:lessonCourseListMap.get(courseId)){
            	tempLessonDtoList.add(lesson);
                String tempKey = String.valueOf(lesson.getLessonId()+"|"+userId);
                
                if(studentLessonSet.contains(tempKey)){
                    
                    arrangeCount++;
                    OrgLessonSign tempSigninStatus = studentSignStatusMap.get(tempKey);
                    if(tempSigninStatus!=null){
                        if(tempSigninStatus.getStatus() == SignStatus.SIGNED.getCode()){
                            signedCount++;
                        }else if(tempSigninStatus.getStatus() == SignStatus.LEAVE.getCode()){
                            leaveCount++;
                        }else if(tempSigninStatus.getStatus() == SignStatus.ABSENT.getCode()){
                            absentCount++;
                        }
                        lesson.setSignTime(tempSigninStatus.getUpdateTime());
                    }
                    if(timeEndConsume){
                        if(lesson.getLessonStartTime().before(now)){
                            endCount++;
                        }
                    }else if(tempSigninStatus!=null){
                        boolean consumed = CourseConsumeRuleEnum.signStatusCodeIsConsume(signinResult.getCourseConsumeRuleValue(), tempSigninStatus.getStatus());
                        if(consumed){
                            endCount++;
                        }
                    }
                }
                
                
                
            }
            signinResult.setSignedCount(signedCount);
            signinResult.setLeaveCount(leaveCount);
            signinResult.setAbsentCount(absentCount);
            signinResult.setArrangeCount(arrangeCount);
            signinResult.setEndCount(endCount);
           

        }
       
   
        return dto;
	}

}