
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.request.UserSmsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.CourseSmsListDto;
import com.baijia.tianxiao.biz.erp.dto.response.UserSmsResponseDto;
import com.baijia.tianxiao.biz.erp.service.ErpCourseSmsService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseSms;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.constant.ViewStatus;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.StudentResponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.collection.CollectorUtil;

import com.google.common.base.Function;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title ErpCourseSmsServiceImpl
 * @desc TODO
 * @author bjhl
 * @date 2015年12月25日
 * @version 1.0
 */
@Slf4j
@Service
public class ErpCourseSmsServiceImpl implements ErpCourseSmsService {

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;

    @Resource
    private OrgCourseListService orgCourseListService;

    @Resource
    private CourseTeacherService courseTeacherService;

    @Resource
    private CourseStudentService courseStudentService;

    @Resource
    private OrgStudentDao orgStudentDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? number.longValue() : null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<CourseSmsListDto> getCourseList(Long orgId, Date startTime, Date endTime, String searchKey,
        PageDto pageDto) {
        Long orgNumber = getOrgNumber(orgId);
        List<Long> courseIds = null;
        // 登录帐号为子帐号，并且是员工帐号，并且排课权限打开时，只能查看自己作为班主任的课节
        // 涉及到分页，这里取courseIds时，按照时间倒序，测试时需要关注数据是否取全
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", courseIds);
                courseIds = Lists.newArrayList();
                List<Long> tempIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId());
                courseIds.addAll(tempIds);
            }
        }

        List<OrgCourse> courses =
            this.orgCourseDao.getCourseList(orgNumber, courseIds, searchKey, null, startTime, endTime, pageDto);
        log.debug("*********courses:{}",courses);
        List<CourseListReponseDto> courseListReponseDtos =
            this.orgCourseListService.getCourseList(courses, orgId, true, true, true, true, false, false, true);
        log.debug("********courseListReponseDtos:{}",courseListReponseDtos);
        List<CourseSmsListDto> responseDtos = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : courseListReponseDtos) {
            CourseSmsListDto dto = new CourseSmsListDto();
            buildCourseSmsListDto(courseListReponseDto, dto);
            responseDtos.add(dto);
        }
        return responseDtos;
    }

    private void buildCourseSmsListDto(CourseListReponseDto courseListReponseDto, CourseSmsListDto dto) {
        dto.setColor(courseListReponseDto.getColor());
        dto.setCourseName(courseListReponseDto.getCourseName());
        dto.setCourseUrl(courseListReponseDto.getCourseUrl());
        dto.setEndTime(courseListReponseDto.getEndTime());
        dto.setLessonCount(courseListReponseDto.getLessonCount());
        dto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        dto.setOrgCourseNumber(courseListReponseDto.getOrgCourseNumber());
        dto.setSmsStudent(courseListReponseDto.getSmsStudent());
        dto.setSmsTeacher(courseListReponseDto.getSmsTeacher());
        dto.setViewStudent(courseListReponseDto.getViewStudent());
        dto.setViewTeacher(courseListReponseDto.getViewTeacher());
        dto.setStartTime(courseListReponseDto.getStartTime());
    }

    @Override
    @Transactional(readOnly = true)
    public List<UserSmsResponseDto> getCourseSmsViewList(Long orgId, UserSmsRequestDto dto) {
        log.info("get course Sms user list , orgId={}, param={}", orgId, dto);
        Long orgNumber = getOrgNumber(orgId);
        OrgCourse course = this.orgCourseDao.getByCourseId(dto.getCourseId());
        List<UserSmsResponseDto> responseDto = Lists.newArrayList();
        if (course == null || course.getOrgNumber().longValue() != orgNumber) {
            throw new BussinessException(CourseErrorCode.COURSE_NOT_EXIST);
        }
        List<OrgCourseSms> courseSmsList =
            this.orgCourseSmsDao.getOrgCourseSmsList(orgId, dto.getCourseId(), dto.getUserRole());
        Map<Long, OrgCourseSms> smsMap = CollectorUtil.collectMap(courseSmsList, new Function<OrgCourseSms, Long>() {
            @Override
            public Long apply(OrgCourseSms arg0) {
                return arg0.getUserId();
            }
        });
        if (dto.getUserRole() == UserRole.STUDENT.getRole()) {
            List<StudentResponseDto> students = courseStudentService.getOrgCourseStudentList(orgId, dto.getCourseId());
            Collection<Long> studentIds = CollectorUtil.collect(students, new Function<StudentResponseDto, Long>() {
                @Override
                public Long apply(StudentResponseDto arg0) {
                    return arg0.getStudentId();
                }
            });
            Map<Long, Long> studentIdMap = this.orgStudentDao.getStudentIdUserIdMap(studentIds);
            for (StudentResponseDto student : students) {
                UserSmsResponseDto userSmsDto = new UserSmsResponseDto();
                buildStudentSmsReponse(student, userSmsDto, smsMap, studentIdMap);
                responseDto.add(userSmsDto);
            }
        } else {
            List<TeacherResponseDto> teachers = courseTeacherService.listCourseTeacher(orgId, dto.getCourseId());
            for (TeacherResponseDto teacher : teachers) {
                UserSmsResponseDto userSmsDto = new UserSmsResponseDto();
                buildTeacherSmsResponse(teacher, userSmsDto, smsMap);
                responseDto.add(userSmsDto);
            }
        }
        return responseDto;
    }

    private void buildTeacherSmsResponse(TeacherResponseDto teacher, UserSmsResponseDto dto,
        Map<Long, OrgCourseSms> smsMap) {
        dto.setUserId(teacher.getTeacherId());
        dto.setName(teacher.getTeacherName());
        dto.setAvatar(teacher.getAvatar());
        if (StringUtils.isBlank(teacher.getMobile())) {
            dto.setHasMobile(0);
        }
        OrgCourseSms sms = smsMap.get(teacher.getTeacherId());
        if (sms != null) {
            dto.setSend(sms.getSend());
            dto.setViewStatus(sms.getViewStatus());
        } else {
            dto.setSend(0);
            dto.setViewStatus(ViewStatus.NOT_VIEW.getCode());
        }
    }

    private void buildStudentSmsReponse(StudentResponseDto student, UserSmsResponseDto dto,
        Map<Long, OrgCourseSms> smsMap, Map<Long, Long> studentIdMap) {
        dto.setUserId(student.getStudentId());
        dto.setName(student.getName());
        dto.setAvatar(student.getAvatarUrl());
        Long userId = studentIdMap.get(student.getStudentId());
        OrgCourseSms sms = smsMap.get(userId);
        if (sms != null) {
            dto.setSend(sms.getSend());
            dto.setViewStatus(sms.getViewStatus());
        } else {
            dto.setSend(0);
            dto.setViewStatus(ViewStatus.NOT_VIEW.getCode());
        }
    }
}
