package com.baijia.tianxiao.biz.erp.dto.response.studentCenter;

import java.util.List;

import lombok.Data;

import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.google.common.collect.Lists;

@Data
public class StudentCenterCourseListDto {
    private String orgName;
    private String logo;
    private String page_str;
    // private String orgUrl;
    private List<OrgCourseDto> list = Lists.newArrayList();

    public void addCourseListReponseDto(CourseListReponseDto dto) {
        OrgCourseDto orgCourseDto = new OrgCourseDto();
        orgCourseDto.setCourseName(dto.getCourseName());
        orgCourseDto.setOrgCourseId(dto.getOrgCourseId());
        orgCourseDto.setCourseUrl(dto.getCoverUrl());
        orgCourseDto.setOrgCourseNumber(dto.getOrgCourseNumber());
        orgCourseDto.setLessonCount(dto.getLessonCount() == null ? 0 : dto.getLessonCount());
        orgCourseDto.setStatus(dto.getStatus());
        list.add(orgCourseDto);
    }

    @Data
    public static class OrgCourseDto {
        private Long orgCourseId;
        private Long orgCourseNumber;
        private String courseUrl;
        private String courseName;
        private Integer lessonCount = 0;
        private Integer status;

    }
}
