
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.constant;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;

/**
 * @title RepeatUnit
 * @desc TODO
 * @author cxm
 * @date 2015年12月28日
 * @version 1.0
 */
public enum RepeatUnit {

    NONE(-1) {

        @Override
        protected int getCalendarType() {
            throw new UnsupportedOperationException("NONE REPEAT.");
        }

    },

    Day(0) {
        @Override
        public int getCalendarType() {
            return Calendar.DAY_OF_MONTH;
        }
    },

    Week(1) {
        @Override
        public int getCalendarType() {
            return Calendar.DAY_OF_MONTH;
        }

        @Override
        protected int getLength(int repeatRange) {
            return repeatRange * 7;
        }
    },

    Month(2) {
        @Override
        public int getCalendarType() {
            return Calendar.MONTH;
        }
    },

    Quarter(3) {
        @Override
        public int getCalendarType() {
            return Calendar.MONTH;
        }

        @Override
        protected int getLength(int repeatRange) {
            return repeatRange * 3;
        }
    },

    Year(4) {
        @Override
        public int getCalendarType() {
            return Calendar.YEAR;
        }
    },

    ;

    private static Map<Integer, RepeatUnit> map;

    private int code;

    private RepeatUnit(int code) {
        this.code = code;
    }

    static {
        map = new HashMap<>();
        for (RepeatUnit unit : RepeatUnit.values()) {
            map.put(unit.code, unit);
        }
    }

    public int getCode() {
        return this.code;
    }

    protected abstract int getCalendarType();

    protected int getLength(int repeatRange) {
        return repeatRange;
    }

    public List<Calendar> getAvaliableDays(Date startDay, Date endDay, Integer repeatRange) {
        if (repeatRange == null || repeatRange <= 0) {
            repeatRange = 1;
        }
        Preconditions.checkArgument(startDay != null, "开始日期错误");
        Preconditions.checkArgument(endDay != null, "结束日期错误");
        Preconditions.checkArgument(repeatRange > 0, "重复范围必须大于0");

        if (endDay.before(startDay)) {
            throw new IllegalArgumentException("结束日期不能大于开始时间");
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDay);

        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDay);
        List<Calendar> resultCals = Lists.newArrayList();
        while (startCal.before(endCal)) {
            resultCals.add((Calendar) (startCal.clone()));
            startCal.add(getCalendarType(), getLength(repeatRange));
        }
        return resultCals;
    }

    public List<Calendar> getAvaliableDays(Date startDay, Integer repeatCount, Integer repeatRange) {
        if (repeatCount == null || repeatCount <= 0) {
            repeatCount = 1;
        }
        if (repeatRange == null || repeatRange <= 0) {
            repeatRange = 1;
        }
        Preconditions.checkArgument(startDay != null, "开始日期错误");
        Preconditions.checkArgument(repeatCount > 0 && repeatCount < 100, "重复次数范围必须在1-99");
        Preconditions.checkArgument(repeatRange > 0, "重复范围必须大于0");

        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDay);
        List<Calendar> resultCals = Lists.newArrayList();
        if (this.code < 0) {
            resultCals.add(startCal);
            return resultCals;
        }

        while (repeatCount > 0) {
            resultCals.add((Calendar) (startCal.clone()));
            startCal.add(getCalendarType(), getLength(repeatRange));
            repeatCount--;
        }
        return resultCals;
    }

    public static RepeatUnit getByCode(Integer code) {
        return map.get(code);
    }

}
