/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.util;

import com.baijia.tianxiao.biz.erp.dto.CourseSigninRecordDto;
import com.baijia.tianxiao.biz.erp.dto.CourseSigninStsDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonTimeTableResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.StudentSigninRecordDto;
import com.baijia.tianxiao.biz.erp.util.EmojiFilter;
import com.baijia.tianxiao.biz.erp.util.ExcelConfig;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.util.ExcelUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class _4ClassSigninRecordStatistics
extends ExcelUtils
implements ExcelConfig {
    private static final Logger log = LoggerFactory.getLogger(_4ClassSigninRecordStatistics.class);
    public static final String BILL_BY_SIGNED = "IF(F%d>0,B%d*F%d,0)";
    public static final String BILL_BY_SIGNED_LEAVE = "IF(F%d>0,(B%d+C%d)*F%d,0)";
    public static final String BILL_BY_SIGNED_ABSENT = "IF(F%d>0,(B%d+D%d)*F%d,0)";
    public static final String BILL_BY_SIGNED_LEAVE_ABSENT = "IF(F%d>0,(B%d+C%d+D%d)*F%d,0)";

    public static XSSFWorkbook excel(CourseSigninStsDto dto, String orgName, Date downloadTime) {
        InputStream in = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream("excel-template/class_signindetail_statistics.xlsx");
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFDrawing patriarch = sheet.createDrawingPatriarch();
            int lessonNum = dto.getLessonNum();
            int planNum = dto.getPlanNum();
            _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)2, (int)1, null, (String)EmojiFilter.filterEmoji(dto.getCourseName()));
            _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)3, (int)1, null, (String)(lessonNum + "/" + planNum));
            _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)4, (int)1, null, (String)sdf.format(downloadTime));
            int titleRowNo = 8;
            int titleStartCellNo = 1;
            int titleEndCellNo = 5;
            Map titleFormatMap = _4ClassSigninRecordStatistics.getCellInfoMap((XSSFSheet)sheet, (int)titleRowNo, (int)titleStartCellNo, (int)titleStartCellNo);
            XSSFCellStyle titleCellStyle = sheet.getRow(titleRowNo).getCell(titleStartCellNo).getCellStyle();
            titleCellStyle.setWrapText(true);
            int titleDemoCellWidth = sheet.getColumnWidth(titleEndCellNo);
            SimpleDateFormat datesdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timesdf = new SimpleDateFormat("HH:mm");
            int i = 1;
            for (LessonResponseDto lesson : dto.getLessonCourseList()) {
                int num = lesson.getIndex();
                _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)titleRowNo, (int)(titleEndCellNo - 1 + i), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)titleEndCellNo, (XSSFCellStyle)titleCellStyle, (Map)titleFormatMap), (String)String.format("\u7b2c%d\u8282\n%s  %s - %s\n%s\n%s", num, datesdf.format(lesson.getLessonStartTime()), timesdf.format(lesson.getLessonStartTime()), timesdf.format(lesson.getLessonEndTime()), StringUtils.isNotBlank((String)lesson.getRoomName()) ? lesson.getRoomName() : "\u65e0\u6559\u5ba4", StringUtils.isNotBlank((String)lesson.getTeacherName()) ? lesson.getTeacherName() : "\u65e0\u8001\u5e08"));
                sheet.setColumnWidth(titleEndCellNo - 1 + i, titleDemoCellWidth);
                ++i;
            }
            int demoRowNo = 9;
            int demoCellStartNo = 0;
            int demoCellEndNo = 2;
            Map demoFormatMap = _4ClassSigninRecordStatistics.getCellInfoMap((XSSFSheet)sheet, (int)demoRowNo, (int)demoCellStartNo, (int)demoCellEndNo);
            short demoRowHeight = sheet.getRow(demoRowNo).getHeight();
            List<CourseSigninStsDto.StudentSigninSts> stuSigninStsList = dto.getStudentSigninStsList();
            if (stuSigninStsList != null && !stuSigninStsList.isEmpty()) {
                int rowNo = demoRowNo;
                XSSFCellStyle cellStyle = sheet.getRow(rowNo).getCell(1).getCellStyle();
                cellStyle.setWrapText(true);
                _4ClassSigninRecordStatistics.fillCellStyleWithFullBorder((XSSFCellStyle)cellStyle, (short)1, (short)IndexedColors.BLACK.getIndex());
                for (CourseSigninStsDto.StudentSigninSts stuSigninSts : stuSigninStsList) {
                    XSSFRow row = sheet.getRow(rowNo);
                    if (sheet.getRow(rowNo) == null) {
                        row = sheet.createRow(rowNo);
                    }
                    row.setHeight(demoRowHeight);
                    int cellNo = demoCellStartNo - 1;
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)EmojiFilter.filterEmoji(stuSigninSts.getStudentName()));
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)stuSigninSts.getSignCount());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)stuSigninSts.getSignedCount());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)stuSigninSts.getLeaveCount());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)stuSigninSts.getAbsentCount());
                    Long userId = stuSigninSts.getUserId();
                    for (LessonResponseDto lesson : dto.getLessonCourseList()) {
                        Long lessonId = lesson.getLessonId();
                        ++cellNo;
                        String studentSignKey = lessonId + "|" + userId;
                        Integer signStatusCode = dto.getSignInStatusMap().get(studentSignKey);
                        if (signStatusCode == null) {
                            signStatusCode = 0;
                        }
                        SignStatus signInStatus = SignStatus.getSignStatusByCode((Integer)signStatusCode);
                        String signStatusName = "\u65e0\u7b7e\u5230\u8bb0\u5f55";
                        if (signInStatus != null && signInStatus != SignStatus.UNSIGN) {
                            signStatusName = signInStatus.getMessage();
                        }
                        _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)demoCellEndNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)signStatusName);
                    }
                    ++rowNo;
                }
            }
            workbook.setSheetName(0, String.format("%s\u5168\u90e8\u7b7e\u5230\u8bb0\u5f55", dto.getCourseName()));
            return workbook;
        }
        catch (Exception e) {
            log.error("course signIn record export error ", (Throwable)e);
            return null;
        }
    }

    public static XSSFWorkbook excel(LessonTimeTableResponseDto dto, String orgName, Date downloadTime) {
        InputStream in = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream("excel-template/lesson_signinrecord_statistics.xlsx");
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(0);
            SimpleDateFormat datesdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timesdf = new SimpleDateFormat("HH:mm");
            String courseName = dto.getCourseName();
            XSSFCellStyle titleCellStyle = sheet.getRow(0).getCell(0).getCellStyle();
            titleCellStyle.setWrapText(true);
            _4ClassSigninRecordStatistics.fillCellStyleWithFullBorder((XSSFCellStyle)titleCellStyle, (short)1, (short)IndexedColors.BLACK.getIndex());
            _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)0, (int)0, (CellStyle)titleCellStyle, (String)String.format("%s\u8bfe\u7a0b\u7b7e\u5230\u8bb0\u5f55\n\u7b7e\u5230\u8bfe\u6b21:%s\n%s %s~%s\n%s\n%s", courseName, dto.getIndex(), datesdf.format(dto.getStartTime()), timesdf.format(dto.getStartTime()), timesdf.format(dto.getEndTime()), StringUtils.isNotBlank((String)dto.getRoomName()) ? dto.getRoomName() : "\u65e0\u6559\u5ba4", StringUtils.isNotBlank((String)dto.getTeacherName()) ? dto.getTeacherName() : "\u65e0\u8001\u5e08"));
            int rowNo = 3;
            XSSFCellStyle cellStyle = sheet.getRow(rowNo).getCell(0).getCellStyle();
            cellStyle.setWrapText(true);
            Map demoFormatMap = _4ClassSigninRecordStatistics.getCellInfoMap((XSSFSheet)sheet, (int)3, (int)0, (int)2);
            for (OrgStudentsChooseListDto student : dto.getStudents()) {
                String signStatusName = "\u65e0\u7b7e\u5230\u8bb0\u5f55";
                SignStatus signInStatus = SignStatus.getSignStatusByCode((Integer)student.getSignStatus());
                if (signInStatus != null && signInStatus != SignStatus.UNSIGN) {
                    signStatusName = signInStatus.getMessage();
                }
                Date signTime = student.getSignInTime();
                _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)0, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)0, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)student.getName());
                _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)1, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)1, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)signStatusName);
                _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)2, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)2, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)(signTime != null ? sdf.format(student.getSignInTime()) : "~~"));
                ++rowNo;
            }
            if (rowNo == 3) {
                sheet.removeRow((Row)sheet.getRow(rowNo));
            }
            workbook.setSheetName(0, String.format("\u7b2c%s\u6b21\u7b7e\u5230\u8bb0\u5f55", dto.getIndex()));
            return workbook;
        }
        catch (Exception e) {
            log.error("lesson signIn record export error ", (Throwable)e);
            return null;
        }
    }

    public static XSSFWorkbook excel(CourseSigninRecordDto dto, String orgName, Date downloadTime) {
        InputStream in = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream("excel-template/class_signindetail_statistics.xlsx");
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFDrawing patriarch = sheet.createDrawingPatriarch();
            Integer lessonNum = dto.getLessonNum();
            Integer planNum = dto.getPlanNum();
            if (planNum == null) {
                planNum = 0;
            }
            _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)1, (int)1, null, (String)EmojiFilter.filterEmoji(dto.getCourseName()));
            _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)2, (int)1, null, (String)sdf.format(downloadTime));
            _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)3, (int)1, null, (String)dto.getConsumeRuleStr());
            int titleRowNo = 5;
            int titleStartCellNo = 1;
            int titleEndCellNo = 6;
            Map titleFormatMap = _4ClassSigninRecordStatistics.getCellInfoMap((XSSFSheet)sheet, (int)titleRowNo, (int)titleStartCellNo, (int)titleStartCellNo);
            XSSFCellStyle titleCellStyle = sheet.getRow(titleRowNo).getCell(titleStartCellNo).getCellStyle();
            titleCellStyle.setWrapText(true);
            int titleDemoCellWidth = sheet.getColumnWidth(titleEndCellNo);
            SimpleDateFormat datesdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timesdf = new SimpleDateFormat("HH:mm");
            int i = 1;
            for (LessonResponseDto lesson : dto.getLessonCourseList()) {
                int num = lesson.getIndex();
                _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)titleRowNo, (int)(titleEndCellNo - 1 + i), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)titleEndCellNo, (XSSFCellStyle)titleCellStyle, (Map)titleFormatMap), (String)String.format("\u7b2c%d\u8282\n%s  %s - %s\n%s\n%s", num, datesdf.format(lesson.getLessonStartTime()), timesdf.format(lesson.getLessonStartTime()), timesdf.format(lesson.getLessonEndTime()), StringUtils.isNotBlank((String)lesson.getRoomName()) ? lesson.getRoomName() : "\u65e0\u6559\u5ba4", StringUtils.isNotBlank((String)lesson.getTeacherName()) ? lesson.getTeacherName() : "\u65e0\u8001\u5e08"));
                sheet.setColumnWidth(titleEndCellNo - 1 + i, titleDemoCellWidth);
                ++i;
            }
            int demoRowNo = 6;
            int demoCellStartNo = 0;
            int demoCellEndNo = 2;
            Map demoFormatMap = _4ClassSigninRecordStatistics.getCellInfoMap((XSSFSheet)sheet, (int)demoRowNo, (int)demoCellStartNo, (int)demoCellEndNo);
            short demoRowHeight = sheet.getRow(demoRowNo).getHeight();
            List<CourseSigninRecordDto.StudentSigninRecord> studentSigninRecordList = dto.getStudentSigninRecordList();
            if (studentSigninRecordList != null && !studentSigninRecordList.isEmpty()) {
                int rowNo = demoRowNo;
                XSSFCellStyle cellStyle = sheet.getRow(rowNo).getCell(1).getCellStyle();
                cellStyle.setWrapText(true);
                _4ClassSigninRecordStatistics.fillCellStyleWithFullBorder((XSSFCellStyle)cellStyle, (short)1, (short)IndexedColors.BLACK.getIndex());
                for (CourseSigninRecordDto.StudentSigninRecord studentSigninRecord : studentSigninRecordList) {
                    XSSFRow row = sheet.getRow(rowNo);
                    if (sheet.getRow(rowNo) == null) {
                        row = sheet.createRow(rowNo);
                    }
                    row.setHeight(demoRowHeight);
                    int cellNo = demoCellStartNo - 1;
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)EmojiFilter.filterEmoji(studentSigninRecord.getStudentName()));
                    ++cellNo;
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)studentSigninRecord.getSignedCount());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)studentSigninRecord.getLeaveCount());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)studentSigninRecord.getAbsentCount());
                    ++cellNo;
                    Long userId = studentSigninRecord.getUserId();
                    int lessonFinishCout = 0;
                    int arrangeCount = 0;
                    Date now = new Date();
                    for (LessonResponseDto lesson : dto.getLessonCourseList()) {
                        Long lessonId = lesson.getLessonId();
                        ++cellNo;
                        String studentSignKey = lessonId + "|" + userId;
                        Integer signStatusCode = dto.getSignInStatusMap().get(studentSignKey);
                        if (signStatusCode == null) {
                            signStatusCode = dto.getStudentLessonSet().contains(studentSignKey) ? Integer.valueOf(0) : Integer.valueOf(-1);
                        }
                        short color = _4ClassSigninRecordStatistics.change(signStatusCode);
                        if (dto.getStudentLessonSet().contains(studentSignKey)) {
                            ++arrangeCount;
                            if (dto.getConsumRuleValue() == null || dto.getConsumRuleValue() == 0) {
                                if (lesson.getLessonStartTime().before(now)) {
                                    ++lessonFinishCout;
                                }
                            } else {
                                Boolean bool = CourseConsumeRuleEnum.signStatusCodeIsConsume((Integer)dto.getConsumRuleValue(), (Integer)signStatusCode);
                                if (bool.booleanValue()) {
                                    ++lessonFinishCout;
                                }
                            }
                        }
                        String signStatusName = "";
                        if (signStatusCode == -1) {
                            signStatusName = "\u672a\u6392\u8bfe";
                        } else {
                            SignStatus signInStatus = SignStatus.getSignStatusByCode((Integer)signStatusCode);
                            signStatusName = "\u65e0\u7b7e\u5230\u8bb0\u5f55";
                            if (signInStatus != null && signInStatus != SignStatus.UNSIGN) {
                                signStatusName = signInStatus.getMessage();
                            }
                        }
                        _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)demoCellEndNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)signStatusName);
                        XSSFCellStyle tempcellStyle = sheet.getRow(rowNo).getCell(cellNo).getCellStyle();
                        tempcellStyle.setFillForegroundColor(color);
                        tempcellStyle.setFillPattern((short)1);
                        sheet.getRow(rowNo).getCell(cellNo).setCellStyle((CellStyle)tempcellStyle);
                    }
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)5, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)demoCellEndNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)("" + lessonFinishCout));
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)1, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)demoCellEndNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)("" + arrangeCount));
                    ++rowNo;
                }
            }
            workbook.setSheetName(0, String.format("%s\u5168\u90e8\u7b7e\u5230\u8bb0\u5f55", dto.getCourseName()));
            return workbook;
        }
        catch (Exception e) {
            log.error("course signIn record export error ", (Throwable)e);
            return null;
        }
    }

    private boolean checkSign(Integer ruleValue, Integer signStatus) {
        return true;
    }

    private static short change(int s) {
        switch (s) {
            case 0: {
                return IndexedColors.CORNFLOWER_BLUE.getIndex();
            }
            case 1: {
                return IndexedColors.WHITE.getIndex();
            }
            case 2: {
                return IndexedColors.SKY_BLUE.getIndex();
            }
            case 3: {
                return IndexedColors.TAN.getIndex();
            }
            case -1: {
                return IndexedColors.GREY_25_PERCENT.getIndex();
            }
        }
        return IndexedColors.WHITE.getIndex();
    }

    public static XSSFWorkbook excel(StudentSigninRecordDto dto, String orgName, Date downloadTime) {
        InputStream in = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream("excel-template/student_signindetail_statistics.xlsx");
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFDrawing patriarch = sheet.createDrawingPatriarch();
            XSSFCellStyle cellNoBoderStyle = sheet.getRow(3).getCell(0).getCellStyle();
            XSSFCellStyle cellRedFontStyle = sheet.getRow(3).getCell(1).getCellStyle();
            cellRedFontStyle.getFont().setColor(IndexedColors.RED.index);
            _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)1, (int)1, (CellStyle)cellNoBoderStyle, (String)EmojiFilter.filterEmoji(dto.getStudentName()));
            _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)2, (int)1, (CellStyle)cellNoBoderStyle, (String)sdf.format(downloadTime));
            int titleRowNo = 4;
            int titleStartCellNo = 0;
            int titleEndCellNo = 0;
            Map titleFormatMap = _4ClassSigninRecordStatistics.getCellInfoMap((XSSFSheet)sheet, (int)titleRowNo, (int)titleStartCellNo, (int)titleEndCellNo);
            XSSFCellStyle titleCellStyle = sheet.getRow(titleRowNo).getCell(titleStartCellNo).getCellStyle();
            titleCellStyle.setWrapText(true);
            int demoRowNo = 5;
            int demoCellStartNo = 0;
            int demoCellEndNo = 0;
            Map demoFormatMap = _4ClassSigninRecordStatistics.getCellInfoMap((XSSFSheet)sheet, (int)demoRowNo, (int)demoCellStartNo, (int)demoCellEndNo);
            short demoRowHeight = sheet.getRow(demoRowNo).getHeight();
            XSSFCellStyle cellStyle = sheet.getRow(5).getCell(0).getCellStyle();
            cellStyle.setWrapText(true);
            cellStyle.getFont().setColor(IndexedColors.BLACK.getIndex());
            _4ClassSigninRecordStatistics.fillCellStyleWithFullBorder((XSSFCellStyle)cellStyle, (short)1, (short)IndexedColors.BLACK.getIndex());
            List<StudentSigninRecordDto.CourseSigninResult> courseSigninResultList = dto.getCourseSigninResultList();
            if (courseSigninResultList != null && !courseSigninResultList.isEmpty()) {
                int rowNo = demoRowNo;
                XSSFRow row0 = sheet.getRow(rowNo);
                if (sheet.getRow(rowNo) == null) {
                    row0 = sheet.createRow(rowNo);
                }
                int number = 1;
                for (int i = 0; i < courseSigninResultList.size(); ++i) {
                    XSSFRow row = sheet.getRow(rowNo);
                    if (sheet.getRow(rowNo) == null) {
                        row = sheet.createRow(rowNo);
                    }
                    row.setHeight(demoRowHeight);
                    int cellNo = demoCellStartNo - 1;
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)number++);
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)courseSigninResultList.get(i).getCourseName());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)courseSigninResultList.get(i).getPlanCount());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)courseSigninResultList.get(i).getArrangeCount());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)courseSigninResultList.get(i).getSignedCount());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)courseSigninResultList.get(i).getLeaveCount());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)courseSigninResultList.get(i).getAbsentCount());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)courseSigninResultList.get(i).getEndCount());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)(++cellNo), (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)courseSigninResultList.get(i).getCourseConsumeRuleStr());
                    ++rowNo;
                }
                int varRowNo = rowNo + 3;
                for (int courseNum = 0; courseNum < dto.getCourseSigninResultList().size(); ++courseNum) {
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)varRowNo, (int)0, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)0, (XSSFCellStyle)cellNoBoderStyle, (Map)demoFormatMap), (String)"\u8bfe\u7a0b\u540d\u79f0");
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)varRowNo, (int)1, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)1, (XSSFCellStyle)cellNoBoderStyle, (Map)demoFormatMap), (String)dto.getCourseSigninResultList().get(courseNum).getCourseName());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)(++varRowNo), (int)0, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)0, (XSSFCellStyle)cellNoBoderStyle, (Map)demoFormatMap), (String)"\u5df2\u6392\u8bfe\u6b21");
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)varRowNo, (int)1, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)1, (XSSFCellStyle)cellNoBoderStyle, (Map)demoFormatMap), (String)(dto.getCourseSigninResultList().get(courseNum).getArrangeCount() + ""));
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)(++varRowNo), (int)0, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)0, (XSSFCellStyle)cellRedFontStyle, (Map)demoFormatMap), (String)"\u5df2\u4e0a\u8bfe\u6b21");
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)varRowNo, (int)1, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)1, (XSSFCellStyle)cellRedFontStyle, (Map)demoFormatMap), (String)(dto.getCourseSigninResultList().get(courseNum).getEndCount() + ""));
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)(++varRowNo), (int)0, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)0, (XSSFCellStyle)cellRedFontStyle, (Map)demoFormatMap), (String)"\u8bfe\u6d88\u89c4\u5219");
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)varRowNo, (int)1, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)1, (XSSFCellStyle)cellRedFontStyle, (Map)demoFormatMap), (String)dto.getCourseSigninResultList().get(courseNum).getCourseConsumeRuleStr());
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)(++varRowNo), (int)0, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)0, (XSSFCellStyle)titleCellStyle, (Map)titleFormatMap), (String)"\u8bfe\u8282");
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)varRowNo, (int)1, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)0, (XSSFCellStyle)titleCellStyle, (Map)titleFormatMap), (String)"\u4e0a\u8bfe\u65f6\u95f4");
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)varRowNo, (int)2, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)0, (XSSFCellStyle)titleCellStyle, (Map)titleFormatMap), (String)"\u7b7e\u5230\u65f6\u95f4");
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)varRowNo, (int)3, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)0, (XSSFCellStyle)titleCellStyle, (Map)titleFormatMap), (String)"\u7b7e\u5230\u8bb0\u5f55");
                    ++varRowNo;
                    SimpleDateFormat lst = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    SimpleDateFormat let = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    SimpleDateFormat st = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Long courseId = dto.getCourseSigninResultList().get(courseNum).getCourseId();
                    for (LessonResponseDto lesson : dto.getLessonCourseListMap().get(courseId)) {
                        _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)varRowNo, (int)0, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)0, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)lesson.getIndex());
                        String tempDate = DateUtil.getStrByDateFormate((Date)lesson.getLessonStartTime(), (String)"yyyy-MM-dd");
                        String tempStartTime = DateUtil.getStrByDateFormate((Date)lesson.getLessonStartTime(), (String)"HH:mm");
                        String tempEndTime = DateUtil.getStrByDateFormate((Date)lesson.getLessonEndTime(), (String)"HH:mm");
                        _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)varRowNo, (int)1, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)1, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)(tempDate + " " + tempStartTime + "~" + tempEndTime));
                        String studentSignKey = lesson.getLessonId() + "|" + dto.getStudentId();
                        OrgLessonSign orgLessonSign = dto.getSignInStatusMap().get(studentSignKey);
                        Integer signStatusCode = null;
                        if (orgLessonSign != null) {
                            signStatusCode = orgLessonSign.getStatus();
                        }
                        if (signStatusCode == null) {
                            signStatusCode = dto.getStudentLessonSet().contains(studentSignKey) ? Integer.valueOf(0) : Integer.valueOf(-1);
                        }
                        short color = _4ClassSigninRecordStatistics.change(signStatusCode);
                        String signStatusName = "";
                        if (signStatusCode == -1) {
                            signStatusName = "\u672a\u6392\u8bfe";
                        } else {
                            SignStatus signInStatus = SignStatus.getSignStatusByCode((Integer)signStatusCode);
                            signStatusName = "\u65e0\u7b7e\u5230\u8bb0\u5f55";
                            if (signInStatus != null && signInStatus != SignStatus.UNSIGN) {
                                signStatusName = signInStatus.getMessage();
                            }
                        }
                        _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)varRowNo, (int)2, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)2, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)(orgLessonSign != null ? st.format(orgLessonSign.getUpdateTime()) : "--"));
                        _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)varRowNo, (int)3, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)3, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)signStatusName);
                        XSSFCellStyle tempcellStyle = sheet.getRow(varRowNo).getCell(3).getCellStyle();
                        tempcellStyle.setFillForegroundColor(color);
                        tempcellStyle.setFillPattern((short)1);
                        sheet.getRow(varRowNo).getCell(3).setCellStyle((CellStyle)tempcellStyle);
                        ++varRowNo;
                    }
                    ++varRowNo;
                    ++varRowNo;
                }
            }
            workbook.setSheetName(0, String.format("%s\u5168\u90e8\u7b7e\u5230\u8bb0\u5f55", dto.getStudentName()));
            return workbook;
        }
        catch (Exception e) {
            log.error("course signIn record export error ", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws IOException, ParseException {
        FileInputStream in = new FileInputStream(new File("/Users/zhenyujian/Desktop/aa.xlsx"));
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
        XSSFSheet sheet = workbook.getSheetAt(0);
        Map demoFormatMap = _4ClassSigninRecordStatistics.getCellInfoMap((XSSFSheet)sheet, (int)1, (int)0, (int)5);
        XSSFCellStyle cellStyle = sheet.getRow(1).getCell(1).getCellStyle();
        File dir = new File("/Users/zhenyujian/Desktop/\u5c0f\u5b5c\u6821\u5b9d\u56fe\u7247");
        File[] fileArray = dir.listFiles();
        boolean i = false;
        int rowNo = 1;
        for (File file : fileArray) {
            if (!file.getName().endsWith("TXT")) continue;
            String dateStr = file.getName().split("\\.")[0];
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            Date date = sdf.parse(dateStr);
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "GBK");
            BufferedReader br = new BufferedReader(reader);
            String str = "";
            int lineNum = 1;
            String orgName = "";
            String province = "";
            String city = "";
            while ((str = br.readLine()) != null) {
                boolean flag = str.startsWith("1") || str.startsWith("2") || str.startsWith("3") || str.startsWith("4") || str.startsWith("5") || str.startsWith("6") || str.startsWith("7") || str.startsWith("8") || str.startsWith("9");
                str = str.replaceAll("[0-9|.|\uff0e|\uff0c|-|\u3001]*", "");
                if ((str = str.trim()).startsWith("\u90e8")) {
                    ++lineNum;
                    continue;
                }
                str = str.replace("_\u3002", "\u5317");
                str = str.replace("\u9ed1\u9f991\u4e8c\u6614", "\u9ed1\u9f99\u6c5f\u7701");
                str = str.replace("\u5e7f\u672b", "\u5e7f\u4e1c");
                str = str.replace("\u4e09\u6614", "\u5357\u7701");
                str = str.replace("1\u4e8c\u518d\u6614", "\u6c5f\u82cf\u7701");
                str = str.replace("\u6d591\u4e8c\u6614", "\u6d59\u6c5f\u7701");
                str = str.replace("\u5349", "\u5e02");
                str = str.replace("\u5e01", "\u5e02");
                str = str.replace("\u6614", "\u7701");
                str = str.replace("\u66fe", "\u7701");
                str = str.replace("\u6cb3\u4e09", "\u6cb3\u5357");
                if (lineNum % 2 == 1) {
                    orgName = str;
                } else {
                    int cellNo;
                    if (flag) {
                        System.out.println(orgName + "  " + province + "   " + city + "  " + dateStr);
                        cellNo = 0;
                        _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)0, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)rowNo);
                        _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)1, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)orgName);
                        _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)2, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)province);
                        _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)3, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)city);
                        _4ClassSigninRecordStatistics.fillTheXSSFCellWithDateValue((XSSFSheet)sheet, (int)rowNo, (int)4, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)4, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Date)date);
                        ++rowNo;
                        orgName = str;
                        continue;
                    }
                    if (str.contains("\u5185\u8499\u53e4")) {
                        province = "\u5185\u8499\u53e4";
                        str = str.replace("\u5185\u8499\u53e4", "");
                    } else if (str.contains("\u5c71\u8499\u53e4")) {
                        province = "\u5185\u8499\u53e4";
                        str = str.replace("\u5c71\u8499\u53e4", "");
                    } else if (str.contains("\u8089\u8499\u53e4")) {
                        province = "\u5185\u8499\u53e4";
                        str = str.replace("\u8089\u8499\u53e4", "");
                    } else if (str.contains("\u5185\u8499\u5409")) {
                        province = "\u5185\u8499\u53e4";
                        str = str.replace("\u5185\u8499\u5409", "");
                    } else if (str.contains("\u5e7f\u897f\u58ee\u65cf")) {
                        province = "\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a";
                    } else if (str.contains("\u897f\u85cf")) {
                        province = "\u897f\u85cf";
                    } else if (str.contains("\u5b81\u590f")) {
                        province = "\u5b81\u590f";
                    } else if (str.contains("\u65b0\u7586")) {
                        province = "\u65b0\u7586";
                        str = str.replace("\u65b0\u7586", "");
                        str = str.replace("\u7701", "");
                    } else if (str.contains("\u9999\u6e2f")) {
                        province = "\u9999\u6e2f";
                    } else if (str.contains("\u6fb3\u95e8")) {
                        province = "\u6fb3\u95e8";
                    } else if (str.contains("\u7701")) {
                        province = str.substring(0, str.indexOf("\u7701"));
                        str = str.substring(str.indexOf("\u7701") + 1, str.length());
                    } else if (str.contains("\u96c0")) {
                        province = str.substring(0, str.indexOf("\u96c0"));
                        str = str.substring(str.indexOf("\u96c0") + 1, str.length());
                    } else {
                        province = "";
                    }
                    city = str;
                    if (city.endsWith("\u5e02")) {
                        city = city.substring(0, city.length() - 1);
                    }
                    System.out.println(orgName + "  " + province + "   " + city + "  " + dateStr);
                    cellNo = 0;
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)0, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)rowNo);
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)1, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)orgName);
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)2, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)province);
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)3, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (String)city);
                    _4ClassSigninRecordStatistics.fillTheXSSFCellWithDateValue((XSSFSheet)sheet, (int)rowNo, (int)4, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)4, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Date)date);
                    ++rowNo;
                }
                ++lineNum;
            }
            _4ClassSigninRecordStatistics.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowNo, (int)0, (CellStyle)_4ClassSigninRecordStatistics.decorateStyleWithDataFormatMap((int)0, (XSSFCellStyle)cellStyle, (Map)demoFormatMap), (Integer)rowNo);
            ++rowNo;
            br.close();
            reader.close();
        }
        FileOutputStream os = new FileOutputStream("/Users/zhenyujian/Desktop/2.xlsx");
        workbook.write((OutputStream)os);
        os.close();
        System.out.println("end");
    }
}

