/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.service.CourseClassService;
import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncSignupSuccessAndSyncFail")
public class SyncSignupSuccessAndSyncFail
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncSignupSuccessAndSyncFail.class);
    String SIGNUP_SMS_CONTENT_TEMPLATE = "\u60a8\u5df2\u6210\u529f\u5728%s\u62a5\u540d\u4e86\u8bfe\u7a0b%s!";
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;
    @Resource
    private CourseClassService courseClassService;

    @Override
    public void sync() {
        try {
            List syncSignupInfoList = this.orgSignupInfoDao.getSignupSuccessAndNotSync();
            if (CollectionUtils.isNotEmpty((Collection)syncSignupInfoList)) {
                for (OrgSignupInfo signupInfo : syncSignupInfoList) {
                    List signupCourses = this.orgSignupCourseDao.loadByPurchaseId(signupInfo.getSignupPurchaseId(), new String[0]);
                    if (CollectionUtils.isEmpty((Collection)signupCourses)) continue;
                    signupInfo.setOrgSignupCourses(signupCourses);
                    Map courseMap = CollectorUtil.collectMap((Collection)signupCourses, (Function)new Function<OrgSignupCourse, Long>(){

                        public Long apply(OrgSignupCourse orgSignupCourse) {
                            return orgSignupCourse.getOrgCourseId();
                        }
                    });
                    StringBuilder sb = new StringBuilder();
                    List courseList = this.orgCourseDao.getByIds(courseMap.keySet(), new String[0]);
                    for (int i = 0; i < courseList.size(); ++i) {
                        sb.append("\u201c" + ((OrgCourse)courseList.get(i)).getName() + "\u201c");
                        if (i >= courseList.size() - 1) continue;
                        sb.append("\u3001");
                    }
                    Integer orgId = signupInfo.getOrgId().intValue();
                    OrgInfo orginfo = this.orgInfoDao.getOrgInfo(orgId, new String[]{"shortname"});
                    log.info("SignupInfoSmsProcessor :orgsignupInfo={}", (Object)signupInfo);
                    TXSaleClueRule txSaleClueRule = this.tXSaleClueRuleService.getByOrgId(orgId);
                    if (txSaleClueRule != null && txSaleClueRule.getSignupMsg() != null && txSaleClueRule.getSignupMsg() == 0) {
                        SmsSendUtil.sendSms((String)signupInfo.getMobile(), (String)String.format(this.SIGNUP_SMS_CONTENT_TEMPLATE, orginfo.getShortName(), sb.toString()), (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), (Integer)orgId, (Integer)UserRole.ORGANIZATION.getRole(), (boolean)true);
                    }
                    if (signupInfo == null) continue;
                    signupInfo.setSmsSend(Integer.valueOf(1));
                    log.info("sms before orgsignupinfo = {},result={}", (Object)signupInfo, (Object)(signupInfo.getSourceType().intValue() != SignupSourceType.TUIGUANG.getCode().intValue() ? 1 : 0));
                    this.orgSignupInfoDao.update((Object)signupInfo, new String[0]);
                    if (signupInfo.getSourceType().intValue() == SignupSourceType.TUIGUANG.getCode().intValue()) continue;
                    try {
                        this.saveStudentCourse(signupInfo);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            log.warn("sy signup sms fail {}", (Throwable)e);
        }
    }

    private void saveStudentCourse(@NonNull OrgSignupInfo orgSignupInfo) {
        if (orgSignupInfo == null) {
            throw new NullPointerException("orgSignupInfo");
        }
        for (OrgSignupCourse course : orgSignupInfo.getOrgSignupCourses()) {
            OrgCourse orgCourse = this.orgCourseDao.getByCourseId(course.getOrgCourseId(), new String[0]);
            if (orgCourse == null) continue;
            if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                this.courseClassService.createClassFor1V1(orgSignupInfo.getOrgId(), orgSignupInfo.getSignupPurchaseId(), course.getOrgCourseId(), course.getUserId(), course.getCount());
                continue;
            }
            OrgStudentCourse studentCourse = new OrgStudentCourse();
            studentCourse.setCourseId(course.getOrgCourseId());
            studentCourse.setCreateTime(new Date());
            studentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            studentCourse.setOrgId(orgSignupInfo.getOrgId());
            studentCourse.setUserId(orgSignupInfo.getUserId());
            studentCourse.setStudentMobile(orgSignupInfo.getMobile());
            studentCourse.setStudentName(orgSignupInfo.getStudentName());
            studentCourse.setLessonCount(Integer.valueOf(0));
            studentCourse.setSignupPurchaseId(orgSignupInfo.getSignupPurchaseId());
            try {
                this.orgStudentCourseDao.save((Object)studentCourse, new String[0]);
            }
            catch (Exception e) {
                log.warn("can not save student :{} into student course by error :{}", (Object)studentCourse, (Object)e);
                e.printStackTrace();
            }
        }
    }
}

